/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block;

import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ProcessMachineBlock
extends BrassTunnelBlock {
    public ProcessMachineBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMOOTH_STONE));
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.isValidPositionForPlacement(state, worldIn, pos);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        BlockEntity blockEntity;
        super.onPlace(state, world, pos, p_220082_4_, p_220082_5_);
        BlockPos belowPos = pos.below();
        BlockState below = world.getBlockState(belowPos);
        if (below.hasProperty((Property)BeltBlock.CASING)) {
            world.setBlock(belowPos, (BlockState)below.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), 2);
        }
        if ((blockEntity = world.getBlockEntity(belowPos)) instanceof BeltBlockEntity) {
            BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
            belt.setCasingType(BeltBlockEntity.CasingType.ANDESITE);
        }
    }

    public void destroy(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        BlockEntity blockEntity;
        super.destroy(level, pos, state);
        BlockPos belowPos = pos.below();
        BlockState below = level.getBlockState(belowPos);
        if (below.hasProperty((Property)BeltBlock.CASING)) {
            level.setBlock(belowPos, (BlockState)below.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(false)), 2);
        }
        if ((blockEntity = level.getBlockEntity(belowPos)) instanceof BeltBlockEntity) {
            BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
            belt.setCasingType(BeltBlockEntity.CasingType.NONE);
        }
    }
}

