/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block.entity;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.create.shape.item.block.handler.ReadOnlyItemHandler;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessMachineBlockEntity
extends BrassTunnelBlockEntity {
    protected static final int PROCESS_INTERVAL = 4;
    protected static final int MAX_STACK_COUNT = 4;
    protected ItemStack inputStack = ItemStack.EMPTY;
    protected ItemStack outputStack = ItemStack.EMPTY;
    protected Direction insertDirection = Direction.UP;
    private int processTimer;

    public ProcessMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(new LinkedList());
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).onlyInsertWhen(this::isRightForShape).allowingBeltFunnels().setInsertionHandler(this::insertShape));
    }

    private boolean isRightForShape(Direction dir) {
        return dir.get2DDataValue() != -1 && dir.getAxis() == this.getBlockState().getValue(BeltTunnelBlock.HORIZONTAL_AXIS);
    }

    private ItemStack insertShape(TransportedItemStack stack, Direction side, boolean simulate) {
        ItemStack input = stack.stack;
        if (this.isRightForShape(side) && (this.inputStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)this.inputStack, (ItemStack)input))) {
            int remain = 4 - this.inputStack.getCount();
            int inserted = Math.min(input.getCount(), remain);
            if (!simulate) {
                if (this.inputStack.isEmpty()) {
                    this.inputStack = input.copyWithCount(inserted);
                } else {
                    this.inputStack.grow(inserted);
                }
            }
            input.shrink(inserted);
        }
        return input.isEmpty() ? ItemStack.EMPTY : input;
    }

    public void addBehavioursDeferred(List<BlockEntityBehaviour> behaviours) {
        super.addBehavioursDeferred(new LinkedList());
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.inputStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("inputStack"));
        this.outputStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("outputStack"));
        this.insertDirection = Objects.requireNonNullElse(Direction.byName((String)tag.getString("insertDirection")), Direction.UP);
        this.processTimer = tag.getInt("processTimer");
    }

    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("inputStack", this.inputStack.saveOptional(registries));
        tag.put("outputStack", this.outputStack.saveOptional(registries));
        tag.putString("insertDirection", this.insertDirection.getName());
        tag.putInt("processTimer", this.processTimer);
    }

    public void updateTunnelConnections() {
        this.flaps.clear();
        if (this.level == null) {
            return;
        }
        Direction.stream().filter(x -> x.getAxis() == this.getBlockState().getValue(BeltTunnelBlock.HORIZONTAL_AXIS)).forEach(dir -> this.flaps.put(dir, this.createChasingFlap()));
        this.sendData();
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(0.25).chase(0.0, (double)0.05f, LerpedFloat.Chaser.EXP);
    }

    public void setStackToDistribute(ItemStack stack, @Nullable Direction enteredFrom) {
        this.sendData();
        this.setChanged();
    }

    public boolean hasDistributionBehaviour() {
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        List<ItemStack> inputs = this.grabInputs();
        List<ItemStack> outputs = this.grabOutputs();
        if (!inputs.isEmpty()) {
            CreateLang.translate((String)"tooltip.machine.input", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
            for (ItemStack stack : inputs) {
                CreateLang.translate((String)"tooltip.brass_tunnel.contains_entry", (Object[])new Object[]{Component.translatable((String)stack.getDescriptionId()).getString(), stack.getCount()}).style(ChatFormatting.GRAY).forGoggles(tooltip);
            }
        }
        if (!outputs.isEmpty()) {
            CreateLang.translate((String)"tooltip.machine.output", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
            for (ItemStack stack : outputs) {
                CreateLang.translate((String)"tooltip.brass_tunnel.contains_entry", (Object[])new Object[]{Component.translatable((String)stack.getDescriptionId()).getString(), stack.getCount()}).style(ChatFormatting.GRAY).forGoggles(tooltip);
            }
        }
        return true;
    }

    public void tick() {
        super.tick();
        ++this.processTimer;
        if (this.processTimer >= 4) {
            this.processTimer = 0;
            this.process();
        }
        this.distributeOutputs();
    }

    protected abstract void process();

    protected void distributeOutputs() {
        this.outputStack = this.distributeStack(this.outputStack);
    }

    public ItemStack distributeStack(ItemStack stack) {
        assert (this.level != null);
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().offset(this.insertDirection.getOpposite().getNormal()));
        if (blockEntity instanceof ProcessMachineBlockEntity) {
            ProcessMachineBlockEntity process = (ProcessMachineBlockEntity)blockEntity;
            process.canInsert(this.insertDirection, stack);
            process.setStackToDistribute(stack, this.insertDirection);
        } else {
            stack = this.insertIntoTunnel(this, this.insertDirection.getOpposite(), stack, false);
            if (stack == null) {
                stack = ItemStack.EMPTY;
            }
        }
        return stack;
    }

    public boolean canInsert(Direction side, ItemStack stack) {
        this.insertDirection = side;
        if (this.inputStack.isEmpty()) {
            this.inputStack = stack.split(4);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)this.inputStack, (ItemStack)stack)) {
            stack.shrink(4 - this.inputStack.getCount());
            this.inputStack.setCount(4);
        }
        return stack.isEmpty();
    }

    public boolean isSide(Direction dir) {
        return dir.get2DDataValue() != -1;
    }

    protected List<ItemStack> grabInputs() {
        return List.of(this.inputStack);
    }

    protected List<ItemStack> grabOutputs() {
        return List.of(this.outputStack);
    }

    private List<ItemStack> grabAllStacks() {
        return ImmutableList.builder().addAll(this.grabInputs()).addAll(this.grabOutputs()).build();
    }

    public IItemHandler getItemHandler() {
        return new ReadOnlyItemHandler(this::grabAllStacks);
    }
}

