/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block.handler;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ReadOnlyItemHandler
implements IItemHandler {
    private final Supplier<List<ItemStack>> listSupplier;

    public ReadOnlyItemHandler(Supplier<List<ItemStack>> supplier) {
        this.listSupplier = supplier;
    }

    public int getSlots() {
        return this.listSupplier.get().size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.listSupplier.get().get(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int count, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return false;
    }
}

