/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.attribute;

import com.iafenvoy.create.shape.registry.CSCDataComponents;
import com.iafenvoy.create.shape.shape.ShapeInfo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ShapePartEmptyAttribute(ShapeInfo.Quarter quarter, boolean empty) implements ItemAttribute
{
    public static final MapCodec<ShapePartEmptyAttribute> CODEC = RecordCodecBuilder.create(i -> i.group((App)ShapeInfo.Quarter.CODEC.fieldOf("quarter").forGetter(ShapePartEmptyAttribute::quarter), (App)Codec.BOOL.fieldOf("empty").forGetter(ShapePartEmptyAttribute::empty)).apply((Applicative)i, ShapePartEmptyAttribute::new)).fieldOf("value");
    public static final StreamCodec<ByteBuf, ShapePartEmptyAttribute> STREAM_CODEC = StreamCodec.composite(ShapeInfo.Quarter.STREAM_CODEC, ShapePartEmptyAttribute::quarter, (StreamCodec)ByteBufCodecs.BOOL, ShapePartEmptyAttribute::empty, ShapePartEmptyAttribute::new);

    public boolean appliesTo(ItemStack stack, Level world) {
        ShapeInfo info = (ShapeInfo)stack.get(CSCDataComponents.SHAPE);
        return info != null && info.layers().stream().allMatch(x -> x.parts().get((Object)this.quarter).isEmpty()) == this.empty;
    }

    public ItemAttributeType getType() {
        return Type.INSTANCE;
    }

    public String getTranslationKey() {
        return "shape_part_" + (this.empty ? "empty" : "non_empty");
    }

    public Object[] getTranslationParameters() {
        return new Component[]{Component.translatable((String)this.quarter.getTranslateKey())};
    }

    public static enum Type implements ItemAttributeType
    {
        INSTANCE;


        @NotNull
        public ItemAttribute createAttribute() {
            return new ShapePartEmptyAttribute(ShapeInfo.Quarter.TOP_RIGHT, true);
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ShapeInfo info = (ShapeInfo)stack.get(CSCDataComponents.SHAPE);
            LinkedList<ItemAttribute> attributes = new LinkedList<ItemAttribute>();
            if (info != null) {
                ShapeInfo.Quarter.stream().map(x -> new ShapePartEmptyAttribute((ShapeInfo.Quarter)((Object)x), info.layers().stream().allMatch(y -> y.parts().get(x).isEmpty()))).forEach(attributes::add);
            }
            return attributes;
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

