/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block.entity;

import com.iafenvoy.create.shape.item.ShapeDyeItem;
import com.iafenvoy.create.shape.item.ShapeItem;
import com.iafenvoy.create.shape.item.block.DyeProcessMachineBlock;
import com.iafenvoy.create.shape.item.block.entity.ProcessMachineBlockEntity;
import com.iafenvoy.create.shape.registry.CSCBlockEntities;
import com.iafenvoy.create.shape.registry.CSCDataComponents;
import com.iafenvoy.create.shape.shape.ShapeInfo;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DyeProcessMachineBlockEntity
extends ProcessMachineBlockEntity {
    private final BiFunction<ShapeInfo, ShapeInfo.Color, ShapeInfo> processor;
    protected ItemStack dyeStack = ItemStack.EMPTY;

    public DyeProcessMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CSCBlockEntities.DYE_PROCESS_MACHINE.get(), pos, state);
        Block block = state.getBlock();
        if (!(block instanceof DyeProcessMachineBlock)) {
            throw new IllegalArgumentException("DyeProcessMachineBlockEntity need a block with DyeProcessMachineBlock");
        }
        DyeProcessMachineBlock provider = (DyeProcessMachineBlock)block;
        this.processor = provider.getProcessor();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).onlyInsertWhen(this::isSide).allowingBeltFunnels().setInsertionHandler(this::insertColor));
    }

    private ItemStack insertColor(TransportedItemStack stack, Direction side, boolean simulate) {
        ItemStack input = stack.stack.copy();
        if (this.isSide(side) && (this.dyeStack.isEmpty() || ItemStack.isSameItem((ItemStack)this.dyeStack, (ItemStack)input)) && input.getItem() instanceof ShapeDyeItem) {
            int remain = 4 - this.dyeStack.getCount();
            int inserted = Math.min(input.getCount(), remain);
            if (!simulate) {
                if (this.dyeStack.isEmpty()) {
                    this.dyeStack = input.copyWithCount(inserted);
                } else {
                    this.dyeStack.grow(inserted);
                }
            }
            input.shrink(inserted);
        }
        return input.isEmpty() ? ItemStack.EMPTY : input;
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.dyeStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("dyeStack"));
    }

    @Override
    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("dyeStack", this.dyeStack.saveOptional(registries));
    }

    @Override
    protected void process() {
        Item item;
        ShapeInfo info = (ShapeInfo)this.inputStack.get(CSCDataComponents.SHAPE);
        if (this.inputStack.isEmpty() || info == null || !((item = this.dyeStack.getItem()) instanceof ShapeDyeItem)) {
            return;
        }
        ShapeDyeItem dye = (ShapeDyeItem)item;
        ItemStack result = ShapeItem.fromInfo(this.processor.apply(info, dye.getColor()));
        boolean success = false;
        if (this.outputStack.isEmpty()) {
            this.outputStack = result;
            success = true;
        } else if (ItemStack.isSameItemSameComponents((ItemStack)this.outputStack, (ItemStack)result) && this.outputStack.getCount() < 4) {
            this.outputStack.grow(1);
            success = true;
        }
        if (success) {
            this.inputStack.shrink(1);
            this.dyeStack.shrink(1);
            this.setChanged();
        }
    }

    @Override
    protected List<ItemStack> grabInputs() {
        return List.of(this.inputStack, this.dyeStack);
    }
}

