/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block.entity;

import com.iafenvoy.create.shape.item.block.slot.ShapeGeneratorFilterSlot;
import com.iafenvoy.create.shape.item.container.InfiniteProvideContainer;
import com.iafenvoy.create.shape.registry.CSCBlockEntities;
import com.iafenvoy.create.shape.util.Predicates;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;

@EventBusSubscriber
public class ShapeGeneratorBlockEntity
extends SmartBlockEntity {
    protected final InfiniteProvideContainer container = new InfiniteProvideContainer(1, Predicates.ALLOW_GENERATE);
    protected FilteringBehaviour filtering;

    public ShapeGeneratorBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)CSCBlockEntities.SHAPE_GENERATOR.get(), pos, blockState);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new ShapeGeneratorFilterSlot()).showCount().withCallback(stack -> this.container.setProvided(stack.copyWithCount(this.filtering.getAmount()))).withPredicate(Predicates.ALLOW_GENERATE);
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.container.deserializeNBT(registries, tag.getCompound("container"));
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("container", (Tag)this.container.serializeNBT(registries));
    }

    public IItemHandler getItemHandler() {
        return this.container;
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CSCBlockEntities.SHAPE_GENERATOR.get(), (be, context) -> be.getItemHandler());
    }
}

