/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.registry;

import com.iafenvoy.create.shape.item.block.CutProcessMachineBlock;
import com.iafenvoy.create.shape.item.block.DyeProcessMachineBlock;
import com.iafenvoy.create.shape.item.block.ShapeDestroyerBlock;
import com.iafenvoy.create.shape.item.block.ShapeGeneratorBlock;
import com.iafenvoy.create.shape.item.block.ShapeStorageBlock;
import com.iafenvoy.create.shape.item.block.SingleProcessMachineBlock;
import com.iafenvoy.create.shape.item.block.StackProcessMachineBlock;
import com.iafenvoy.create.shape.registry.CSCItems;
import com.iafenvoy.create.shape.shape.ShapeProcessors;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class CSCBlocks {
    public static final DeferredRegister.Blocks REGISTRY = DeferredRegister.createBlocks((String)"create_shape_craft");
    public static final DeferredBlock<ShapeGeneratorBlock> SHAPE_GENERATOR = CSCBlocks.register("shape_generator", ShapeGeneratorBlock::new);
    public static final DeferredBlock<ShapeDestroyerBlock> SHAPE_DESTROYER = CSCBlocks.register("shape_destroyer", ShapeDestroyerBlock::new);
    public static final DeferredBlock<ShapeStorageBlock> SHAPE_STORAGE = CSCBlocks.register("shape_storage", ShapeStorageBlock::new);
    public static final DeferredBlock<SingleProcessMachineBlock> ROTATOR_CW = CSCBlocks.register("rotator_cw", () -> new SingleProcessMachineBlock(ShapeProcessors::rotateClockwise));
    public static final DeferredBlock<SingleProcessMachineBlock> ROTATOR_CCW = CSCBlocks.register("rotator_ccw", () -> new SingleProcessMachineBlock(ShapeProcessors::rotateCounterclockwise));
    public static final DeferredBlock<SingleProcessMachineBlock> ROTATOR_180 = CSCBlocks.register("rotator_180", () -> new SingleProcessMachineBlock(ShapeProcessors::rotate180));
    public static final DeferredBlock<DyeProcessMachineBlock> DYER = CSCBlocks.register("dyer", () -> new DyeProcessMachineBlock(ShapeProcessors::color));
    public static final DeferredBlock<StackProcessMachineBlock> STACKER = CSCBlocks.register("stacker", () -> new StackProcessMachineBlock(ShapeProcessors::stack));
    public static final DeferredBlock<CutProcessMachineBlock> CUTTER_HORIZONTAL = CSCBlocks.register("cutter_horizontal", () -> new CutProcessMachineBlock(ShapeProcessors::cutHorizontal));
    public static final DeferredBlock<CutProcessMachineBlock> CUTTER_VERTICAL = CSCBlocks.register("cutter_vertical", () -> new CutProcessMachineBlock(ShapeProcessors::cutVertical));
    public static final DeferredBlock<CutProcessMachineBlock> CUTTER_QUARTER = CSCBlocks.register("cutter_quarter", () -> new CutProcessMachineBlock(ShapeProcessors::cutQuarter));

    public static <T extends Block> DeferredBlock<T> register(String id, Supplier<T> obj) {
        return CSCBlocks.register(id, obj, block -> new BlockItem(block, new Item.Properties()));
    }

    public static <T extends Block> DeferredBlock<T> register(String id, Supplier<T> obj, Function<Block, Item> itemGetter) {
        DeferredBlock r = REGISTRY.register(id, obj);
        CSCItems.register(id, () -> (Item)itemGetter.apply((Block)r.get()));
        return r;
    }
}

