/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block.entity;

import com.iafenvoy.create.shape.data.ColorMixData;
import com.iafenvoy.create.shape.data.ShapeColor;
import com.iafenvoy.create.shape.item.block.ColorMixerBlock;
import com.iafenvoy.create.shape.item.block.handler.DrainOnlyFluidTankWrapper;
import com.iafenvoy.create.shape.registry.CSCBlockEntities;
import com.simibubi.create.content.fluids.transfer.FluidDrainingBehaviour;
import com.simibubi.create.content.fluids.transfer.FluidFillingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ColorMixerBlockEntity
extends SmartBlockEntity {
    private static final int AMOUNT_PER_TICK = 10;
    private static final int FLUID_CAPACITY = 1000;
    private final FluidTank input1 = new FluidTank(1000);
    private final FluidTank input2 = new FluidTank(1000);
    private final FluidTank output = new FluidTank(1000);

    public ColorMixerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CSCBlockEntities.COLOR_MIXER.get(), pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new FluidFillingBehaviour((SmartBlockEntity)this));
        behaviours.add((BlockEntityBehaviour)new FluidDrainingBehaviour((SmartBlockEntity)this));
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.input1.readFromNBT(registries, tag.getCompound("input1"));
        this.input2.readFromNBT(registries, tag.getCompound("input2"));
        this.output.readFromNBT(registries, tag.getCompound("output"));
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("input1", (Tag)this.input1.writeToNBT(registries, new CompoundTag()));
        tag.put("input2", (Tag)this.input2.writeToNBT(registries, new CompoundTag()));
        tag.put("output", (Tag)this.output.writeToNBT(registries, new CompoundTag()));
    }

    public void tick() {
        super.tick();
        this.process();
    }

    protected void process() {
        if (this.output.getCapacity() - this.output.getFluidAmount() < 20 || this.input1.getFluidAmount() < 10 || this.input2.getFluidAmount() < 10) {
            return;
        }
        ShapeColor color1 = ShapeColor.forFluid(this.input1.getFluid().getFluid());
        ShapeColor color2 = ShapeColor.forFluid(this.input2.getFluid().getFluid());
        if (color1 == null || color2 == null) {
            return;
        }
        ShapeColor result = ColorMixData.getOutput(color1, color2);
        if (result == null) {
            return;
        }
        Fluid fluid = result.getFluid();
        FluidStack stack = this.output.getFluid();
        boolean success = false;
        if (stack.isEmpty()) {
            this.output.setFluid(new FluidStack(fluid, 20));
            success = true;
        } else if (stack.is(fluid)) {
            stack.grow(20);
            success = true;
        }
        if (success) {
            this.input1.drain(10, IFluidHandler.FluidAction.EXECUTE);
            this.input2.drain(10, IFluidHandler.FluidAction.EXECUTE);
            this.setChanged();
        }
    }

    public IFluidHandler getFluidHandler(Direction dir) {
        if (dir == null) {
            return new CombinedTankWrapper(new IFluidHandler[]{this.input1, this.input2, this.output});
        }
        if (dir.get2DDataValue() == -1) {
            return EmptyFluidHandler.INSTANCE;
        }
        int d = (4 + dir.get2DDataValue() - ((Direction)this.getBlockState().getValue(ColorMixerBlock.FACING)).get2DDataValue()) % 4;
        return switch (d) {
            case 1 -> this.input1;
            case 3 -> this.input2;
            case 0 -> new DrainOnlyFluidTankWrapper(this.output);
            default -> EmptyFluidHandler.INSTANCE;
        };
    }
}

