/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block.entity;

import com.iafenvoy.create.shape.data.ShapeColor;
import com.iafenvoy.create.shape.data.ShapeInfo;
import com.iafenvoy.create.shape.item.ShapeItem;
import com.iafenvoy.create.shape.item.block.DyeProcessMachineBlock;
import com.iafenvoy.create.shape.item.block.entity.ProcessMachineBlockEntity;
import com.iafenvoy.create.shape.registry.CSCBlockEntities;
import com.iafenvoy.create.shape.registry.CSCDataComponents;
import com.iafenvoy.create.shape.registry.CSCTags;
import com.simibubi.create.content.fluids.transfer.FluidDrainingBehaviour;
import com.simibubi.create.content.fluids.transfer.FluidFillingBehaviour;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class DyeProcessMachineBlockEntity
extends ProcessMachineBlockEntity {
    private static final int DYE_PER_SHAPE = 50;
    private final BiFunction<ShapeInfo, ShapeColor, ShapeInfo> processor;
    protected final FluidTank dyeHandler = new FluidTank(1000).setValidator(stack -> stack.is(CSCTags.SHAPE_DYES));

    public DyeProcessMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CSCBlockEntities.DYE_PROCESS_MACHINE.get(), pos, state);
        Block block = state.getBlock();
        if (!(block instanceof DyeProcessMachineBlock)) {
            throw new IllegalArgumentException("DyeProcessMachineBlockEntity need a block with DyeProcessMachineBlock");
        }
        DyeProcessMachineBlock provider = (DyeProcessMachineBlock)block;
        this.processor = provider.getProcessor();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add((BlockEntityBehaviour)new FluidFillingBehaviour((SmartBlockEntity)this));
        behaviours.add((BlockEntityBehaviour)new FluidDrainingBehaviour((SmartBlockEntity)this));
    }

    @Override
    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.dyeHandler.readFromNBT(registries, tag.getCompound("fluidTank"));
    }

    @Override
    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.put("fluidTank", (Tag)this.dyeHandler.writeToNBT(registries, new CompoundTag()));
    }

    @Override
    protected void process() {
        ShapeInfo info = (ShapeInfo)this.inputStack.get(CSCDataComponents.SHAPE);
        if (this.inputStack.isEmpty() || info == null || this.dyeHandler.getFluidAmount() < 50) {
            return;
        }
        ItemStack result = ShapeItem.fromInfo(this.processor.apply(info, ShapeColor.forFluid(this.dyeHandler.getFluid().getFluid())));
        boolean success = false;
        if (this.outputStack.isEmpty()) {
            this.outputStack = result;
            success = true;
        } else if (ItemStack.isSameItemSameComponents((ItemStack)this.outputStack, (ItemStack)result) && this.outputStack.getCount() < 4) {
            this.outputStack.grow(1);
            success = true;
        }
        if (success) {
            this.inputStack.shrink(1);
            this.dyeHandler.drain(50, IFluidHandler.FluidAction.EXECUTE);
            this.setChanged();
        }
    }

    public IFluidHandler getFluidHandler(Direction dir) {
        if (dir == null) {
            return this.dyeHandler;
        }
        return dir.getAxis().isHorizontal() && dir.getAxis() != this.getBlockState().getValue(BeltTunnelBlock.HORIZONTAL_AXIS) ? this.dyeHandler : EmptyFluidHandler.INSTANCE;
    }
}

