/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block.entity;

import com.iafenvoy.create.shape.data.ShapeInfo;
import com.iafenvoy.create.shape.item.ShapeItem;
import com.iafenvoy.create.shape.item.block.SingleProcessMachineBlock;
import com.iafenvoy.create.shape.item.block.entity.ProcessMachineBlockEntity;
import com.iafenvoy.create.shape.registry.CSCBlockEntities;
import com.iafenvoy.create.shape.registry.CSCDataComponents;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SingleProcessMachineBlockEntity
extends ProcessMachineBlockEntity {
    private final Function<ShapeInfo, ShapeInfo> processor;

    public SingleProcessMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CSCBlockEntities.SINGLE_PROCESS_MACHINE.get(), pos, state);
        Block block = state.getBlock();
        if (!(block instanceof SingleProcessMachineBlock)) {
            throw new IllegalArgumentException("SingleProcessMachineBlockEntity need a block with SingleProcessMachineBlock");
        }
        SingleProcessMachineBlock provider = (SingleProcessMachineBlock)block;
        this.processor = provider.getProcessor();
    }

    @Override
    protected void process() {
        ShapeInfo info = (ShapeInfo)this.inputStack.get(CSCDataComponents.SHAPE);
        if (this.inputStack.isEmpty() || info == null) {
            return;
        }
        ItemStack result = ShapeItem.fromInfo(this.processor.apply(info));
        boolean success = false;
        if (this.outputStack.isEmpty()) {
            this.outputStack = result;
            success = true;
        } else if (ItemStack.isSameItemSameComponents((ItemStack)this.outputStack, (ItemStack)result) && this.outputStack.getCount() < 4) {
            this.outputStack.grow(1);
            success = true;
        }
        if (success) {
            this.inputStack.shrink(1);
            this.setChanged();
        }
    }
}

