/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.create.shape.item.block.handler;

import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class GenerateItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    private final int maxCountPerTime;
    private final Predicate<ItemStack> allowed;
    private ItemStack provided = ItemStack.EMPTY;

    public GenerateItemHandler(int maxCountPerTime, Predicate<ItemStack> allowed) {
        this.maxCountPerTime = maxCountPerTime;
        this.allowed = allowed;
    }

    public ItemStack getProvided() {
        return this.provided;
    }

    public void setProvided(ItemStack provided) {
        if (this.allowed.test(provided)) {
            this.provided = provided;
        }
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.provided.copyWithCount(this.getSlotLimit(slot));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int count, boolean simulate) {
        return this.getStackInSlot(slot);
    }

    public int getSlotLimit(int slot) {
        return this.maxCountPerTime;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return false;
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.put("provided", this.getProvided().saveOptional(registries));
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider registries, @NotNull CompoundTag tag) {
        this.setProvided(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("provided")));
    }
}

