/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.commands;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.MyShopsGUI;
import MPP.marketPlacePlus.gui.ShopBrowserGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.utils.PlayerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ShopsCommand
implements CommandExecutor,
TabCompleter {
    private final MarketPlacePlus plugin;

    public ShopsCommand(MarketPlacePlus plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (PlayerUtils.checkBanned(player, this.plugin)) {
            return true;
        }
        if (!player.hasPermission("marketplaceplus.shops.use")) {
            player.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            new ShopBrowserGUI(player, this.plugin).open();
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "browse": {
                new ShopBrowserGUI(player, this.plugin).open();
                break;
            }
            case "my": 
            case "mine": {
                new MyShopsGUI(player, this.plugin).open();
                break;
            }
            case "create": {
                if (!player.hasPermission("marketplaceplus.shop.create")) {
                    player.sendMessage("\u00a7cYou don't have permission to create shops!");
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /shops create <name>");
                    return true;
                }
                String shopName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                if (shopName.length() > 32) {
                    player.sendMessage("\u00a7cShop name too long! Max 32 characters.");
                    return true;
                }
                player.sendMessage("\u00a7ePlease enter a description for your shop (or 'none' to skip):");
                this.plugin.getChatInputManager().waitForInput(player, description -> {
                    if (description.equalsIgnoreCase("none")) {
                        description = "";
                    } else if (description.length() > 128) {
                        player.sendMessage("\u00a7cDescription too long! Max 128 characters.");
                        return;
                    }
                    if (this.plugin.getShopManager().createShop(player, shopName, (String)description)) {
                        player.sendMessage("\u00a7aShop created successfully!");
                        new MyShopsGUI(player, this.plugin).open();
                    } else {
                        player.sendMessage("\u00a7cFailed to create shop! You may have reached your shop limit or lack funds.");
                    }
                });
                break;
            }
            case "search": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /shops search <query>");
                    return true;
                }
                String query = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                ShopBrowserGUI browserGUI = new ShopBrowserGUI(player, this.plugin);
                player.closeInventory();
                player.sendMessage("\u00a7eSearching for shops matching: \u00a7f" + query);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> browserGUI.open(), 1L);
                break;
            }
            case "help": {
                this.sendHelpMessage(player);
                break;
            }
            case "nearby": {
                double radius = this.plugin.getConfig().getDouble("player-shops.interaction-radius", 10.0) * 2.0;
                List<PlayerShop> nearbyShops = this.plugin.getShopManager().getNearbyShops(player.getLocation(), radius);
                if (nearbyShops.isEmpty()) {
                    player.sendMessage("\u00a7cNo shops found nearby!");
                    break;
                }
                player.sendMessage("\u00a76\u00a7lNearby Shops:");
                for (PlayerShop shop : nearbyShops) {
                    double distance = shop.getLocation().distance(player.getLocation());
                    player.sendMessage("\u00a7e" + shop.getShopName() + " \u00a77- \u00a7f" + String.format("%.1f", distance) + " blocks away");
                }
                player.sendMessage("\u00a77Right-click near a shop to open it!");
                break;
            }
            case "tp": 
            case "teleport": {
                if (!player.hasPermission("marketplaceplus.shop.teleport")) {
                    player.sendMessage("\u00a7cYou don't have permission to teleport to shops!");
                    return true;
                }
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /shops tp <shop-id or shop-name>");
                    return true;
                }
                String shopIdentifier = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                List<PlayerShop> allShops = this.plugin.getShopManager().getAllShops();
                PlayerShop targetShop = allShops.stream().filter(s -> s.getId().startsWith(shopIdentifier) || s.getShopName().equalsIgnoreCase(shopIdentifier)).findFirst().orElse(null);
                if (targetShop == null) {
                    player.sendMessage("\u00a7cShop not found!");
                    break;
                }
                this.plugin.getShopManager().teleportToShop(player, targetShop.getId());
                break;
            }
            case "setlocation": 
            case "setloc": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /shops setlocation <shop-name>");
                    return true;
                }
                String shopToUpdate = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                List<PlayerShop> playerShops = this.plugin.getShopManager().getPlayerShops(player.getUniqueId());
                PlayerShop shopToSet = playerShops.stream().filter(s -> s.getShopName().equalsIgnoreCase(shopToUpdate)).findFirst().orElse(null);
                if (shopToSet == null) {
                    player.sendMessage("\u00a7cShop not found! Your shops:");
                    playerShops.forEach(s -> player.sendMessage("\u00a77- \u00a7f" + s.getShopName()));
                    break;
                }
                this.plugin.getShopManager().setShopLocation(player, shopToSet.getId());
                break;
            }
            default: {
                player.sendMessage("\u00a7cUnknown subcommand! Use /shops help for a list of commands.");
            }
        }
        return true;
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage("\u00a76\u00a7lShops Commands:");
        player.sendMessage("\u00a7e/shops \u00a77- Open the shop browser");
        player.sendMessage("\u00a7e/shops browse \u00a77- Browse all shops");
        player.sendMessage("\u00a7e/shops my \u00a77- View your shops");
        player.sendMessage("\u00a7e/shops create <name> \u00a77- Create a new shop at your location");
        player.sendMessage("\u00a7e/shops search <query> \u00a77- Search for shops");
        player.sendMessage("\u00a7e/shops nearby \u00a77- List shops near you");
        player.sendMessage("\u00a7e/shops tp <shop> \u00a77- Teleport to a shop");
        player.sendMessage("\u00a7e/shops setlocation <shop> \u00a77- Set shop location to current position");
        player.sendMessage("\u00a7e/shops help \u00a77- Show this help message");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String[] subCommands = new String[]{"browse", "my", "create", "search", "help", "nearby", "tp", "setlocation"};
            String prefix = args[0].toLowerCase();
            for (String subCommand : subCommands) {
                if (!subCommand.startsWith(prefix)) continue;
                completions.add(subCommand);
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("create")) {
                completions.add("<shop_name>");
            } else if (args[0].equalsIgnoreCase("search")) {
                completions.add("<search_query>");
            }
        }
        return completions;
    }
}

