/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.database;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.libs.hikari.HikariConfig;
import MPP.marketPlacePlus.libs.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class DatabaseConnectionPool {
    private final MarketPlacePlus plugin;
    private HikariDataSource dataSource;
    private final ExecutorService executor;
    private final String dbType;

    public DatabaseConnectionPool(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.dbType = plugin.getConfig().getString("database.type", "SQLITE");
        this.executor = Executors.newFixedThreadPool(plugin.getConfig().getInt("database.thread-pool-size", 4));
    }

    public void initialize() throws SQLException {
        HikariConfig config = new HikariConfig();
        if (this.dbType.equalsIgnoreCase("MYSQL")) {
            String host = this.plugin.getConfig().getString("database.mysql.host");
            int port = this.plugin.getConfig().getInt("database.mysql.port");
            String database = this.plugin.getConfig().getString("database.mysql.database");
            String username = this.plugin.getConfig().getString("database.mysql.username");
            String password = this.plugin.getConfig().getString("database.mysql.password");
            config.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database);
            config.setUsername(username);
            config.setPassword(password);
            config.setDriverClassName("com.mysql.cj.jdbc.Driver");
            config.addDataSourceProperty("useSSL", "false");
            config.addDataSourceProperty("autoReconnect", "true");
            config.addDataSourceProperty("maxReconnects", "3");
            config.addDataSourceProperty("initialTimeout", "2");
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.setMaximumPoolSize(10);
            config.setMinimumIdle(2);
            config.setIdleTimeout(600000L);
            config.setMaxLifetime(1800000L);
        } else {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            String dbPath = this.plugin.getDataFolder().getAbsolutePath() + "/marketplace.db";
            config.setJdbcUrl("jdbc:sqlite:" + dbPath);
            config.setDriverClassName("org.sqlite.JDBC");
            config.setMaximumPoolSize(1);
            config.setMinimumIdle(1);
        }
        config.setConnectionTimeout(30000L);
        config.setLeakDetectionThreshold(60000L);
        config.setConnectionTestQuery("SELECT 1");
        config.setPoolName("MarketPlacePlus-Pool");
        try {
            this.dataSource = new HikariDataSource(config);
            this.plugin.getLogger().info("Database connection pool initialized successfully!");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to initialize connection pool: " + e.getMessage());
            throw new SQLException("Failed to initialize HikariCP", e);
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null || this.dataSource.isClosed()) {
            throw new SQLException("Connection pool is not initialized or closed");
        }
        return this.dataSource.getConnection();
    }

    public <T> CompletableFuture<T> executeAsync(Function<Connection, T> task) {
        return CompletableFuture.supplyAsync(() -> {
            Object r;
            block8: {
                Connection conn = this.getConnection();
                try {
                    r = task.apply(conn);
                    if (conn == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().severe("Async database operation failed: " + e.getMessage());
                        throw new RuntimeException("Database operation failed", e);
                    }
                }
                conn.close();
            }
            return r;
        }, this.executor);
    }

    public CompletableFuture<Void> executeUpdateAsync(String sql, Object ... params) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                for (int i = 0; i < params.length; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Async update failed: " + e.getMessage());
                throw new RuntimeException("Database update failed", e);
            }
        }, this.executor);
    }

    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.plugin.getLogger().info("Database connection pool closed.");
        }
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }

    public boolean isConnected() {
        return this.dataSource != null && !this.dataSource.isClosed();
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    public int getActiveConnections() {
        return this.dataSource != null ? this.dataSource.getHikariPoolMXBean().getActiveConnections() : 0;
    }

    public int getTotalConnections() {
        return this.dataSource != null ? this.dataSource.getHikariPoolMXBean().getTotalConnections() : 0;
    }

    public int getIdleConnections() {
        return this.dataSource != null ? this.dataSource.getHikariPoolMXBean().getIdleConnections() : 0;
    }

    public int getThreadsAwaitingConnection() {
        return this.dataSource != null ? this.dataSource.getHikariPoolMXBean().getThreadsAwaitingConnection() : 0;
    }
}

