/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.AuctionBidGUI;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.CategoryFilterGUI;
import MPP.marketPlacePlus.gui.ConfirmCancelGUI;
import MPP.marketPlacePlus.gui.ConfirmPurchaseGUI;
import MPP.marketPlacePlus.gui.MyListingsGUI;
import MPP.marketPlacePlus.gui.ReportItemGUI;
import MPP.marketPlacePlus.gui.SearchGUI;
import MPP.marketPlacePlus.gui.SellItemGUI;
import MPP.marketPlacePlus.managers.AuctionManager;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.utils.ItemUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AuctionHouseGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final AuctionManager auctionManager;
    private List<MarketItem> items;
    private List<MarketItem> filteredItems;
    private int currentPage;
    private String searchQuery = "";
    private SortType sortType = SortType.NEWEST;
    private String categoryFilter = "ALL";
    private static final int ITEMS_PER_PAGE = 28;

    public AuctionHouseGUI(Player player, MarketPlacePlus plugin) {
        super(player, "\u00a76Auction House", 6);
        this.plugin = plugin;
        this.auctionManager = plugin.getAuctionManager();
        this.currentPage = 0;
    }

    public void setSearchAndOpen(String query) {
        this.searchQuery = query;
        this.open();
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.YELLOW_STAINED_GLASS_PANE);
        this.items = this.auctionManager.getActiveListings();
        this.applyFilters();
        this.addControlButtons();
        this.displayItems();
        this.addNavigationButtons(this.currentPage, this.getMaxPages(), this::previousPage, this::nextPage);
    }

    private void addControlButtons() {
        ItemStack searchButton = this.createItem(Material.COMPASS, "\u00a7aSearch Items", "\u00a77Current search: " + (this.searchQuery.isEmpty() ? "None" : this.searchQuery), "\u00a77Click to search for items");
        this.setItem(0, searchButton, e -> {
            this.playClickSound();
            new SearchGUI(this.player, this.plugin, this::setSearchQuery).open();
        });
        ItemStack sortButton = this.createItem(Material.HOPPER, "\u00a7aSort Items", "\u00a77Current sort: " + this.sortType.name(), "\u00a77Click to change sorting");
        this.setItem(1, sortButton, e -> {
            this.playClickSound();
            this.cycleSortType();
            this.refresh();
        });
        ItemStack categoryButton = this.createItem(Material.CHEST, "\u00a7aFilter Category", "\u00a77Current: " + this.categoryFilter, "\u00a77Click to change category");
        this.setItem(2, categoryButton, e -> {
            this.playClickSound();
            new CategoryFilterGUI(this.player, this.plugin, this::setCategoryFilter).open();
        });
        if (!this.searchQuery.isEmpty() || !this.categoryFilter.equals("ALL")) {
            ItemStack clearFilters = this.createItem(Material.BARRIER, "\u00a7cClear Filters", "\u00a77Remove all active filters");
            this.setItem(3, clearFilters, e -> {
                this.playClickSound();
                this.searchQuery = "";
                this.categoryFilter = "ALL";
                this.currentPage = 0;
                this.refresh();
            });
        }
        ItemStack myListingsButton = this.createItem(Material.EMERALD, "\u00a7aMy Listings", "\u00a77View your active listings");
        this.setItem(7, myListingsButton, e -> {
            this.playClickSound();
            new MyListingsGUI(this.player, this.plugin).open();
        });
        ItemStack sellButton = this.createItem(Material.GOLD_INGOT, "\u00a7aSell Item", "\u00a77List an item for sale");
        this.setItem(8, sellButton, e -> {
            this.playClickSound();
            new SellItemGUI(this.player, this.plugin).open();
        });
        ItemStack refreshButton = this.createItem(Material.CLOCK, "\u00a7bRefresh", "\u00a77Refresh listings");
        this.setItem(4, refreshButton, e -> {
            this.playClickSound();
            this.items = this.auctionManager.getActiveListings();
            this.refresh();
        });
        if (this.currentPage > 0) {
            ItemStack prevButton = this.createItem(Material.ARROW, "\u00a7aPrevious Page", "\u00a77Go to page " + this.currentPage, "\u00a77Current: " + (this.currentPage + 1) + "/" + (this.getMaxPages() + 1));
            this.setItem(48, prevButton, e -> {
                this.playClickSound();
                this.previousPage();
            });
        }
        if (this.currentPage < this.getMaxPages()) {
            ItemStack nextButton = this.createItem(Material.ARROW, "\u00a7aNext Page", "\u00a77Go to page " + (this.currentPage + 2), "\u00a77Current: " + (this.currentPage + 1) + "/" + (this.getMaxPages() + 1));
            this.setItem(50, nextButton, e -> {
                this.playClickSound();
                this.nextPage();
            });
        }
        ItemStack pageInfo = this.createItem(Material.PAPER, "\u00a7ePage Info", "\u00a77Page: " + (this.currentPage + 1) + "/" + (this.getMaxPages() + 1), "\u00a77Items: " + this.filteredItems.size() + " total", "\u00a77Showing: " + (this.currentPage * 28 + 1) + "-" + Math.min((this.currentPage + 1) * 28, this.filteredItems.size()));
        this.setItem(49, pageInfo, null);
    }

    private void displayItems() {
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, this.filteredItems.size());
        int displayIndex = 0;
        for (int row = 1; row < 5; ++row) {
            for (int col = 1; col < 8; ++col) {
                int slot = row * 9 + col;
                this.inventory.setItem(slot, null);
                this.clickHandlers.remove(slot);
                int itemIndex = startIndex + displayIndex;
                if (itemIndex < endIndex) {
                    MarketItem marketItem = this.filteredItems.get(itemIndex);
                    if (marketItem.getItemStack() == null) {
                        ++displayIndex;
                        continue;
                    }
                    ItemStack displayItem = marketItem.getItemStack().clone();
                    ItemMeta meta = displayItem.getItemMeta();
                    if (meta == null) {
                        ++displayIndex;
                        continue;
                    }
                    ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
                    lore.add("");
                    lore.add("\u00a77\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
                    if (marketItem.isAuction()) {
                        lore.add("\u00a7d\u00a7lAUCTION");
                        lore.add("\u00a7eSeller: \u00a77" + marketItem.getSellerName());
                        lore.add("\u00a7eCurrent Bid: \u00a76" + this.plugin.getEconomyManager().formatMoney(marketItem.getCurrentBid()));
                        lore.add("\u00a7eBidder: \u00a77" + (marketItem.getHighestBidderName() != null ? marketItem.getHighestBidderName() : "None"));
                        lore.add("\u00a7eBids: \u00a77" + marketItem.getTotalBids());
                        Duration timeLeft = Duration.between(LocalDateTime.now(), marketItem.getExpiryTime());
                        if (timeLeft.isNegative()) {
                            lore.add("\u00a7cAuction Ending Soon!");
                        } else {
                            long hours = timeLeft.toHours();
                            long minutes = timeLeft.toMinutes() % 60L;
                            lore.add("\u00a7eTime Left: \u00a77" + hours + "h " + minutes + "m");
                        }
                        lore.add("");
                        if (this.player.getUniqueId().equals(marketItem.getSellerId())) {
                            lore.add("\u00a77Your auction");
                        } else {
                            lore.add("\u00a7aLeft-click to bid");
                            lore.add("\u00a7cMiddle-click to report");
                        }
                    } else {
                        lore.add("\u00a7eSeller: \u00a77" + marketItem.getSellerName());
                        lore.add("\u00a7ePrice: \u00a76" + this.plugin.getEconomyManager().formatMoney(marketItem.getPrice()));
                        double lastPrice = this.plugin.getPriceManager().getLastPrice(ItemUtils.getItemKey(displayItem));
                        if (lastPrice > 0.0) {
                            lore.add("\u00a7eLast Price: \u00a77" + this.plugin.getEconomyManager().formatMoney(lastPrice));
                        }
                        lore.add("");
                        if (this.player.getUniqueId().equals(marketItem.getSellerId())) {
                            lore.add("\u00a7aLeft-click to view");
                            lore.add("\u00a7cRight-click to cancel");
                        } else {
                            lore.add("\u00a7aLeft-click to buy");
                            lore.add("\u00a7cMiddle-click to report");
                        }
                    }
                    meta.setLore(lore);
                    displayItem.setItemMeta(meta);
                    this.setItem(slot, displayItem, e -> {
                        if (e.getClick() == ClickType.LEFT) {
                            this.handlePurchase(marketItem);
                        } else if (e.getClick() == ClickType.RIGHT && this.player.getUniqueId().equals(marketItem.getSellerId())) {
                            this.handleCancel(marketItem);
                        } else if (e.getClick() == ClickType.MIDDLE && !this.player.getUniqueId().equals(marketItem.getSellerId())) {
                            this.handleReport(marketItem);
                        }
                    });
                }
                ++displayIndex;
            }
        }
    }

    private void handlePurchase(MarketItem item) {
        if (this.player.getUniqueId().equals(item.getSellerId())) {
            this.playErrorSound();
            this.player.sendMessage("\u00a7cYou cannot buy/bid on your own items!");
            return;
        }
        this.playClickSound();
        if (item.isAuction()) {
            new AuctionBidGUI(this.player, this.plugin, item).open();
        } else {
            new ConfirmPurchaseGUI(this.player, this.plugin, item).open();
        }
    }

    private void handleCancel(MarketItem item) {
        this.playClickSound();
        new ConfirmCancelGUI(this.player, this.plugin, item).open();
    }

    private void handleReport(MarketItem item) {
        this.playClickSound();
        new ReportItemGUI(this.player, this.plugin, item).open();
    }

    private void applyFilters() {
        this.filteredItems = this.items.stream().filter(item -> !item.isSold() && !item.isExpired()).filter(item -> this.categoryFilter.equals("ALL") || item.getCategory().equals(this.categoryFilter)).filter(item -> this.searchQuery.isEmpty() || this.matchesSearch((MarketItem)item)).sorted(this::compareItems).collect(Collectors.toList());
    }

    private boolean matchesSearch(MarketItem item) {
        String itemName = ItemUtils.getItemName(item.getItemStack()).toLowerCase();
        return itemName.contains(this.searchQuery.toLowerCase());
    }

    private int compareItems(MarketItem a, MarketItem b) {
        switch (this.sortType.ordinal()) {
            case 0: {
                return b.getListedTime().compareTo(a.getListedTime());
            }
            case 1: {
                return a.getListedTime().compareTo(b.getListedTime());
            }
            case 2: {
                return Double.compare(a.getPrice(), b.getPrice());
            }
            case 3: {
                return Double.compare(b.getPrice(), a.getPrice());
            }
            case 4: {
                return ItemUtils.getItemName(a.getItemStack()).compareTo(ItemUtils.getItemName(b.getItemStack()));
            }
        }
        return 0;
    }

    private void cycleSortType() {
        SortType[] types = SortType.values();
        int currentIndex = this.sortType.ordinal();
        this.sortType = types[(currentIndex + 1) % types.length];
    }

    private void setSearchQuery(String query) {
        this.searchQuery = query;
        this.currentPage = 0;
        this.refresh();
    }

    private void setCategoryFilter(String category) {
        this.categoryFilter = category;
        this.currentPage = 0;
        this.refresh();
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.refresh();
        }
    }

    private void nextPage() {
        if (this.currentPage < this.getMaxPages()) {
            ++this.currentPage;
            this.refresh();
        }
    }

    private int getMaxPages() {
        return Math.max(0, (this.filteredItems.size() - 1) / 28);
    }

    private static enum SortType {
        NEWEST,
        OLDEST,
        PRICE_LOW,
        PRICE_HIGH,
        NAME;

    }
}

