/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class BaseGUI
implements InventoryHolder {
    protected final Player player;
    protected final String title;
    protected final int size;
    protected Inventory inventory;
    protected final Map<Integer, Consumer<InventoryClickEvent>> clickHandlers;
    protected static final Map<UUID, BaseGUI> openGUIs = new ConcurrentHashMap<UUID, BaseGUI>();

    public BaseGUI(Player player, String title, int rows) {
        this.player = player;
        this.title = title;
        this.size = rows * 9;
        this.clickHandlers = new HashMap<Integer, Consumer<InventoryClickEvent>>();
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.size, (String)title);
    }

    public abstract void setupGUI();

    public void open() {
        this.setupGUI();
        this.player.openInventory(this.inventory);
        openGUIs.put(this.player.getUniqueId(), this);
    }

    public void refresh() {
        this.inventory.clear();
        this.clickHandlers.clear();
        this.setupGUI();
    }

    protected void setItem(int slot, ItemStack item, Consumer<InventoryClickEvent> onClick) {
        this.inventory.setItem(slot, item);
        if (onClick != null) {
            this.clickHandlers.put(slot, onClick);
        }
    }

    protected void fillBorder(Material material) {
        ItemStack borderItem = new ItemStack(material);
        ItemMeta meta = borderItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            borderItem.setItemMeta(meta);
        }
        for (int i = 0; i < this.size; ++i) {
            if (i >= 9 && i < this.size - 9 && i % 9 != 0 && i % 9 != 8) continue;
            this.inventory.setItem(i, borderItem);
        }
    }

    protected void addNavigationButtons(int currentPage, int maxPages, Runnable onPrevious, Runnable onNext) {
        if (currentPage > 0) {
            ItemStack previousButton = this.createItem(Material.ARROW, "\u00a7aPrevious Page", "\u00a77Click to go to page " + currentPage);
            this.setItem(this.size - 9, previousButton, e -> {
                this.playClickSound();
                onPrevious.run();
            });
        }
        ItemStack pageInfo = this.createItem(Material.PAPER, "\u00a7ePage " + (currentPage + 1) + "/" + (maxPages + 1), "\u00a77You are on page " + (currentPage + 1));
        this.setItem(this.size - 5, pageInfo, null);
        if (currentPage < maxPages) {
            ItemStack nextButton = this.createItem(Material.ARROW, "\u00a7aNext Page", "\u00a77Click to go to page " + (currentPage + 2));
            this.setItem(this.size - 1, nextButton, e -> {
                this.playClickSound();
                onNext.run();
            });
        }
    }

    protected ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            item.setItemMeta(meta);
        }
        return item;
    }

    protected void playClickSound() {
        this.player.playSound(this.player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
    }

    protected void playSuccessSound() {
        this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.5f, 1.5f);
    }

    protected void playErrorSound() {
        this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        Consumer<InventoryClickEvent> handler = this.clickHandlers.get(event.getSlot());
        if (handler != null) {
            handler.accept(event);
        }
    }

    public void handleClose(InventoryCloseEvent event) {
        openGUIs.remove(this.player.getUniqueId());
    }

    public static BaseGUI getOpenGUI(UUID playerId) {
        return openGUIs.get(playerId);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public static void closeAll() {
        for (Map.Entry<UUID, BaseGUI> entry : openGUIs.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null || !player.isOnline()) continue;
            player.closeInventory();
        }
        openGUIs.clear();
    }

    public static void cleanupOfflinePlayers() {
        openGUIs.entrySet().removeIf(entry -> {
            Player player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
            return player == null || !player.isOnline();
        });
    }
}

