/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.MyListingsGUI;
import MPP.marketPlacePlus.models.MarketItem;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConfirmCancelGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final MarketItem item;

    public ConfirmCancelGUI(Player player, MarketPlacePlus plugin, MarketItem item) {
        super(player, "\u00a76Cancel Listing?", 3);
        this.plugin = plugin;
        this.item = item;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        this.setItem(13, this.item.getItemStack(), null);
        ItemStack confirmButton = this.createItem(Material.EMERALD_BLOCK, "\u00a7aConfirm Cancel", "\u00a77Get your item back");
        this.setItem(11, confirmButton, e -> {
            if (!this.player.hasPermission("marketplaceplus.auction.cancel")) {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cYou don't have permission to cancel listings!");
                return;
            }
            if (this.plugin.getAuctionManager().cancelListing(this.player, this.item.getId())) {
                this.playSuccessSound();
                this.player.sendMessage("\u00a7aListing cancelled successfully!");
                new MyListingsGUI(this.player, this.plugin).open();
            } else {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cFailed to cancel listing!");
            }
        });
        ItemStack cancelButton = this.createItem(Material.REDSTONE_BLOCK, "\u00a7cKeep Listed", "\u00a77Don't cancel the listing");
        this.setItem(15, cancelButton, e -> {
            this.playClickSound();
            new MyListingsGUI(this.player, this.plugin).open();
        });
    }
}

