/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.AuctionHouseGUI;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.utils.AntiScamUtils;
import MPP.marketPlacePlus.utils.ItemUtils;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ConfirmPurchaseGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final MarketItem item;

    public ConfirmPurchaseGUI(Player player, MarketPlacePlus plugin, MarketItem item) {
        super(player, "\u00a76Confirm Purchase", 3);
        this.plugin = plugin;
        this.item = item;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.YELLOW_STAINED_GLASS_PANE);
        ItemStack displayItem = this.item.getItemStack().clone();
        ItemMeta meta = displayItem.getItemMeta();
        ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
        lore.add("");
        lore.add("\u00a77\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        lore.add("\u00a7eSeller: \u00a77" + this.item.getSellerName());
        lore.add("\u00a7ePrice: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.item.getPrice()));
        double lastPrice = this.plugin.getPriceManager().getLastPrice(ItemUtils.getItemKey(displayItem));
        if (lastPrice > 0.0) {
            lore.add("\u00a7eLast Price: \u00a77" + this.plugin.getEconomyManager().formatMoney(lastPrice));
            double priceDiff = this.item.getPrice() - lastPrice;
            if (Math.abs(priceDiff) > lastPrice * 0.5) {
                lore.add("\u00a7c\u26a0 Price differs significantly from last sale!");
            }
        }
        if (this.plugin.getConfig().getBoolean("protection.verify-enchantments") && AntiScamUtils.isItemSuspicious(displayItem, (Plugin)this.plugin)) {
            lore.add("");
            lore.add("\u00a7c\u26a0 WARNING: This item may be suspicious!");
        }
        meta.setLore(lore);
        displayItem.setItemMeta(meta);
        this.setItem(13, displayItem, null);
        ItemStack confirmButton = this.createItem(Material.EMERALD_BLOCK, "\u00a7aConfirm Purchase", "\u00a77Price: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.item.getPrice()), "\u00a77Your balance: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.plugin.getEconomyManager().getBalance(this.player)), "", "\u00a7aClick to purchase");
        this.setItem(11, confirmButton, e -> {
            if (!this.player.hasPermission("marketplaceplus.auction.buy")) {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cYou don't have permission to buy items!");
                return;
            }
            if (this.plugin.getAuctionManager().purchaseListing(this.player, this.item.getId())) {
                this.playSuccessSound();
                this.player.sendMessage("\u00a7aSuccessfully purchased " + ItemUtils.getItemName(this.item.getItemStack()) + " for " + this.plugin.getEconomyManager().formatMoney(this.item.getPrice()));
                this.player.closeInventory();
            } else {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cFailed to purchase item! It may have already been sold.");
                new AuctionHouseGUI(this.player, this.plugin).open();
            }
        });
        ItemStack cancelButton = this.createItem(Material.REDSTONE_BLOCK, "\u00a7cCancel", "\u00a77Return to auction house");
        this.setItem(15, cancelButton, e -> {
            this.playClickSound();
            new AuctionHouseGUI(this.player, this.plugin).open();
        });
    }
}

