/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.SellItemGUI;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CreateAuctionGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final ItemStack auctionItem;
    private double startingBid = 100.0;
    private double bidIncrement = 10.0;
    private int duration = 24;

    public CreateAuctionGUI(Player player, MarketPlacePlus plugin, ItemStack item) {
        super(player, "Create Auction", 4);
        this.plugin = plugin;
        this.auctionItem = item;
    }

    public CreateAuctionGUI(Player player, MarketPlacePlus plugin, ItemStack item, double startingBid, double bidIncrement, int duration) {
        super(player, "Create Auction", 4);
        this.plugin = plugin;
        this.auctionItem = item;
        this.startingBid = startingBid;
        this.bidIncrement = bidIncrement;
        this.duration = duration;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.PURPLE_STAINED_GLASS_PANE);
        this.setItem(13, this.auctionItem, null);
        this.updateBidButtons();
        this.updateDurationButtons();
        ItemStack confirmButton = this.createItem(Material.EMERALD_BLOCK, "\u00a7aCreate Auction", "\u00a77Item: \u00a7f" + this.auctionItem.getType().name(), "\u00a77Starting Bid: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.startingBid), "\u00a77Bid Increment: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.bidIncrement), "\u00a77Duration: \u00a7b" + this.duration + " hours", "", "\u00a77Listing Fee: \u00a7c" + this.plugin.getEconomyManager().formatMoney(this.startingBid * this.plugin.getConfig().getDouble("auction-house.listing-fee-percentage") / 100.0), "", "\u00a7eClick to create auction");
        this.setItem(31, confirmButton, e -> {
            if (this.plugin.getAuctionManager().createAuction(this.player, this.auctionItem, this.startingBid, this.bidIncrement, this.duration)) {
                this.playClickSound();
                this.player.closeInventory();
            }
        });
        ItemStack cancelButton = this.createItem(Material.REDSTONE_BLOCK, "\u00a7cCancel", new String[0]);
        this.setItem(32, cancelButton, e -> {
            this.playClickSound();
            new SellItemGUI(this.player, this.plugin, this.auctionItem, this.startingBid).open();
        });
    }

    private void updateBidButtons() {
        ItemStack startBidDecrease = this.createItem(Material.RED_STAINED_GLASS_PANE, "\u00a7c-$100", "\u00a77Current: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.startingBid));
        this.setItem(10, startBidDecrease, e -> {
            if (this.startingBid > 100.0) {
                this.playClickSound();
                this.startingBid -= 100.0;
                this.refresh();
            }
        });
        ItemStack startBidItem = this.createItem(Material.GOLD_INGOT, "\u00a76Starting Bid", "\u00a77Current: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.startingBid), "", "\u00a7eClick to set custom amount");
        this.setItem(11, startBidItem, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.player.sendMessage("\u00a7eEnter starting bid amount:");
            this.plugin.getChatInputManager().waitForInput(this.player, input -> {
                try {
                    double amount = Double.parseDouble(input);
                    if (amount >= 100.0 && amount <= 100000.0) {
                        this.startingBid = amount;
                        new CreateAuctionGUI(this.player, this.plugin, this.auctionItem, this.startingBid, this.bidIncrement, this.duration).open();
                    } else {
                        this.player.sendMessage("\u00a7cAmount must be between $100 and $100,000!");
                        new CreateAuctionGUI(this.player, this.plugin, this.auctionItem, this.startingBid, this.bidIncrement, this.duration).open();
                    }
                }
                catch (NumberFormatException ex) {
                    this.player.sendMessage("\u00a7cInvalid amount!");
                    new CreateAuctionGUI(this.player, this.plugin, this.auctionItem, this.startingBid, this.bidIncrement, this.duration).open();
                }
            });
        });
        ItemStack startBidIncrease = this.createItem(Material.GREEN_STAINED_GLASS_PANE, "\u00a7a+$100", "\u00a77Current: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.startingBid));
        this.setItem(12, startBidIncrease, e -> {
            if (this.startingBid < 100000.0) {
                this.playClickSound();
                this.startingBid += 100.0;
                this.refresh();
            }
        });
        ItemStack incrementDecrease = this.createItem(Material.RED_STAINED_GLASS_PANE, "\u00a7c-$10", "\u00a77Current: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.bidIncrement));
        this.setItem(14, incrementDecrease, e -> {
            if (this.bidIncrement > 10.0) {
                this.playClickSound();
                this.bidIncrement -= 10.0;
                this.refresh();
            }
        });
        ItemStack incrementItem = this.createItem(Material.GOLD_NUGGET, "\u00a76Bid Increment", "\u00a77Current: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.bidIncrement), "\u00a77Minimum bid increase", "", "\u00a7eClick to set custom amount");
        this.setItem(15, incrementItem, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.player.sendMessage("\u00a7eEnter bid increment amount:");
            this.plugin.getChatInputManager().waitForInput(this.player, input -> {
                try {
                    double amount = Double.parseDouble(input);
                    if (amount >= 1.0 && amount <= 10000.0) {
                        this.bidIncrement = amount;
                        new CreateAuctionGUI(this.player, this.plugin, this.auctionItem, this.startingBid, this.bidIncrement, this.duration).open();
                    } else {
                        this.player.sendMessage("\u00a7cAmount must be between $1 and $10,000!");
                        new CreateAuctionGUI(this.player, this.plugin, this.auctionItem, this.startingBid, this.bidIncrement, this.duration).open();
                    }
                }
                catch (NumberFormatException ex) {
                    this.player.sendMessage("\u00a7cInvalid amount!");
                    new CreateAuctionGUI(this.player, this.plugin, this.auctionItem, this.startingBid, this.bidIncrement, this.duration).open();
                }
            });
        });
        ItemStack incrementIncrease = this.createItem(Material.GREEN_STAINED_GLASS_PANE, "\u00a7a+$10", "\u00a77Current: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.bidIncrement));
        this.setItem(16, incrementIncrease, e -> {
            if (this.bidIncrement < 1000.0) {
                this.playClickSound();
                this.bidIncrement += 10.0;
                this.refresh();
            }
        });
    }

    private void updateDurationButtons() {
        ItemStack durationDecrease = this.createItem(Material.RED_STAINED_GLASS_PANE, "\u00a7c-6 hours", "\u00a77Current: \u00a7b" + this.duration + " hours");
        this.setItem(19, durationDecrease, e -> {
            if (this.duration > 6) {
                this.playClickSound();
                this.duration -= 6;
                this.refresh();
            }
        });
        ItemStack durationItem = this.createItem(Material.CLOCK, "\u00a7bAuction Duration", "\u00a77Current: \u00a7b" + this.duration + " hours", "", "\u00a77Auction will end after", "\u00a77this time period", "", "\u00a7eClick to set custom duration");
        this.setItem(20, durationItem, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.player.sendMessage("\u00a7eEnter auction duration in hours:");
            this.plugin.getChatInputManager().waitForInput(this.player, input -> {
                try {
                    int hours = Integer.parseInt(input);
                    if (hours >= 1 && hours <= 168) {
                        this.duration = hours;
                        new CreateAuctionGUI(this.player, this.plugin, this.auctionItem, this.startingBid, this.bidIncrement, this.duration).open();
                    } else {
                        this.player.sendMessage("\u00a7cDuration must be between 1 and 168 hours!");
                        new CreateAuctionGUI(this.player, this.plugin, this.auctionItem, this.startingBid, this.bidIncrement, this.duration).open();
                    }
                }
                catch (NumberFormatException ex) {
                    this.player.sendMessage("\u00a7cInvalid duration!");
                    new CreateAuctionGUI(this.player, this.plugin, this.auctionItem, this.startingBid, this.bidIncrement, this.duration).open();
                }
            });
        });
        ItemStack durationIncrease = this.createItem(Material.GREEN_STAINED_GLASS_PANE, "\u00a7a+6 hours", "\u00a77Current: \u00a7b" + this.duration + " hours");
        this.setItem(21, durationIncrease, e -> {
            if (this.duration < 72) {
                this.playClickSound();
                this.duration += 6;
                this.refresh();
            }
        });
    }
}

