/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;

public class PriceSelectorGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final ItemStack item;
    private final Consumer<Double> onComplete;
    private double currentPrice = 0.0;
    private boolean isConfirmed = false;

    public PriceSelectorGUI(Player player, MarketPlacePlus plugin, ItemStack item, Consumer<Double> onComplete) {
        super(player, "\u00a76Set Price", 3);
        this.plugin = plugin;
        this.item = item;
        this.onComplete = onComplete;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.YELLOW_STAINED_GLASS_PANE);
        this.updateDisplay();
    }

    private void updateDisplay() {
        ItemStack priceDisplay = this.createItem(Material.GOLD_BLOCK, "\u00a76Current Price", "\u00a7e" + this.plugin.getEconomyManager().formatMoney(this.currentPrice));
        this.setItem(4, priceDisplay, null);
        if (this.item != null) {
            this.setItem(13, this.item.clone(), null);
        }
        double[] increments = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0};
        Material[] materials = new Material[]{Material.IRON_NUGGET, Material.IRON_INGOT, Material.GOLD_NUGGET, Material.GOLD_INGOT, Material.DIAMOND};
        for (int i = 0; i < increments.length; ++i) {
            double amount = increments[i];
            ItemStack addButton = this.createItem(materials[i], "\u00a7a+" + amount, "\u00a77Add \u00a76" + this.plugin.getEconomyManager().formatMoney(amount));
            this.setItem(9 + i, addButton, e -> {
                this.playClickSound();
                this.currentPrice += amount;
                this.updatePriceDisplay();
            });
            ItemStack subtractButton = this.createItem(Material.REDSTONE, "\u00a7c-" + amount, "\u00a77Subtract \u00a76" + this.plugin.getEconomyManager().formatMoney(amount));
            this.setItem(18 + i, subtractButton, e -> {
                this.playClickSound();
                this.currentPrice = Math.max(0.0, this.currentPrice - amount);
                this.updatePriceDisplay();
            });
        }
        ItemStack resetButton = this.createItem(Material.BARRIER, "\u00a7cReset", "\u00a77Reset price to 0");
        this.setItem(14, resetButton, e -> {
            this.playClickSound();
            this.currentPrice = 0.0;
            this.updatePriceDisplay();
        });
        ItemStack confirmButton = this.createItem(Material.EMERALD_BLOCK, "\u00a7aConfirm", "\u00a77Set price to \u00a76" + this.plugin.getEconomyManager().formatMoney(this.currentPrice));
        this.setItem(23, confirmButton, e -> {
            if (this.currentPrice <= 0.0) {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cPrice must be greater than 0!");
                return;
            }
            double minPrice = this.plugin.getConfig().getDouble("auction-house.min-price");
            double maxPrice = this.plugin.getConfig().getDouble("auction-house.max-price");
            if (this.currentPrice < minPrice || this.currentPrice > maxPrice) {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cPrice must be between " + this.plugin.getEconomyManager().formatMoney(minPrice) + " and " + this.plugin.getEconomyManager().formatMoney(maxPrice));
                return;
            }
            this.playSuccessSound();
            this.isConfirmed = true;
            this.player.closeInventory();
            this.onComplete.accept(this.currentPrice);
        });
    }

    @Override
    public void handleClose(InventoryCloseEvent event) {
        super.handleClose(event);
        if (!this.isConfirmed && this.item != null) {
            this.player.getInventory().addItem(new ItemStack[]{this.item});
        }
    }

    private void updatePriceDisplay() {
        ItemStack priceDisplay = this.createItem(Material.GOLD_BLOCK, "\u00a76Current Price", "\u00a7e" + this.plugin.getEconomyManager().formatMoney(this.currentPrice));
        this.inventory.setItem(4, priceDisplay);
        ItemStack confirmButton = this.createItem(Material.EMERALD_BLOCK, "\u00a7aConfirm", "\u00a77Set price to \u00a76" + this.plugin.getEconomyManager().formatMoney(this.currentPrice));
        this.inventory.setItem(23, confirmButton);
    }
}

