/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.models.Report;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ReportItemGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final MarketItem marketItem;
    private final PlayerShop shop;
    private final Report.ReportType reportType;
    private final String targetId;
    private final String reportedId;
    private final String reportedName;

    public ReportItemGUI(Player player, MarketPlacePlus plugin, MarketItem item) {
        super(player, "\u00a7c\u00a7lReport Listing", 3);
        this.plugin = plugin;
        this.marketItem = item;
        this.shop = null;
        this.reportType = Report.ReportType.AUCTION;
        this.targetId = item.getId();
        this.reportedId = item.getSellerId().toString();
        this.reportedName = item.getSellerName();
    }

    public ReportItemGUI(Player player, MarketPlacePlus plugin, PlayerShop shop) {
        super(player, "\u00a7c\u00a7lReport Shop", 3);
        this.plugin = plugin;
        this.marketItem = null;
        this.shop = shop;
        this.reportType = Report.ReportType.SHOP;
        this.targetId = shop.getId();
        this.reportedId = shop.getOwnerId().toString();
        this.reportedName = shop.getOwnerName();
    }

    @Override
    public void setupGUI() {
        ItemStack itemDisplay;
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        if (this.marketItem != null) {
            itemDisplay = this.marketItem.getItemStack().clone();
            ItemMeta meta = itemDisplay.getItemMeta();
            meta.setLore(Arrays.asList("\u00a77Seller: \u00a7e" + this.reportedName, "\u00a77Price: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.marketItem.getPrice()), "", "\u00a7cReporting this listing"));
            itemDisplay.setItemMeta(meta);
        } else {
            itemDisplay = this.createItem(Material.CHEST, "\u00a7e" + this.shop.getName(), "\u00a77Owner: \u00a7e" + this.reportedName, "\u00a77Items: \u00a7e" + this.shop.getItems().size(), "", "\u00a7cReporting this shop");
        }
        this.setItem(4, itemDisplay, null);
        ItemStack scamReport = this.createItem(Material.BARRIER, "\u00a7c\u00a7lScam / Misleading", "\u00a77Report if:", "\u00a77\u2022 Misleading item name", "\u00a77\u2022 Hidden enchantments", "\u00a77\u2022 Wrong item description", "\u00a77\u2022 Overpriced common items", "", "\u00a7eClick to report");
        this.setItem(10, scamReport, e -> this.submitReport("Scam / Misleading Item"));
        ItemStack inappropriateReport = this.createItem(Material.NAME_TAG, "\u00a7c\u00a7lInappropriate Content", "\u00a77Report if:", "\u00a77\u2022 Offensive item names", "\u00a77\u2022 Inappropriate descriptions", "\u00a77\u2022 Harassment in lore", "\u00a77\u2022 Discriminatory content", "", "\u00a7eClick to report");
        this.setItem(12, inappropriateReport, e -> this.submitReport("Inappropriate Content"));
        ItemStack exploitReport = this.createItem(Material.TNT, "\u00a7c\u00a7lExploit / Duped Items", "\u00a77Report if:", "\u00a77\u2022 Suspected duped items", "\u00a77\u2022 Exploited items", "\u00a77\u2022 Illegal enchantments", "\u00a77\u2022 Glitched items", "", "\u00a7eClick to report");
        this.setItem(14, exploitReport, e -> this.submitReport("Exploit / Duped Items"));
        ItemStack otherReport = this.createItem(Material.PAPER, "\u00a7c\u00a7lOther Violation", "\u00a77Report for any other", "\u00a77marketplace violations", "", "\u00a7eClick to report");
        this.setItem(16, otherReport, e -> {
            this.player.closeInventory();
            this.player.sendMessage("\u00a7ePlease describe the violation:");
            this.plugin.getChatInputManager().waitForInput(this.player, input -> {
                if (input != null && !input.isEmpty()) {
                    boolean success = this.plugin.getReportManager().createReport(this.player, this.reportedId, this.reportedName, this.reportType, this.targetId, "Other Violation", (String)input);
                    if (success) {
                        this.player.sendMessage("\u00a7aReport submitted successfully!");
                        this.playSuccessSound();
                    }
                } else {
                    this.player.sendMessage("\u00a7cReport cancelled.");
                }
            });
        });
        ItemStack cancelButton = this.createItem(Material.BARRIER, "\u00a7cCancel", "\u00a77Return without reporting");
        this.setItem(22, cancelButton, e -> {
            this.playClickSound();
            this.player.closeInventory();
        });
    }

    private void submitReport(String reason) {
        boolean success = this.plugin.getReportManager().createReport(this.player, this.reportedId, this.reportedName, this.reportType, this.targetId, reason, null);
        if (success) {
            this.player.sendMessage("\u00a7aReport submitted successfully!");
            this.player.sendMessage("\u00a77An admin will review your report soon.");
            this.playSuccessSound();
            this.player.closeInventory();
        } else {
            this.playErrorSound();
        }
    }
}

