/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.PlayerShopGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShopStatsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final PlayerShop shop;

    public ShopStatsGUI(Player player, MarketPlacePlus plugin, PlayerShop shop) {
        super(player, "\u00a76Shop Statistics", 3);
        this.plugin = plugin;
        this.shop = shop;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemStack earnings = this.createItem(Material.GOLD_BLOCK, "\u00a76Total Earnings", "\u00a7e" + this.plugin.getEconomyManager().formatMoney(this.shop.getTotalEarnings()));
        this.setItem(11, earnings, null);
        ItemStack items = this.createItem(Material.CHEST, "\u00a7bItems in Stock", "\u00a77" + this.shop.getItems().size() + " different items");
        this.setItem(13, items, null);
        ItemStack created = this.createItem(Material.CLOCK, "\u00a7aShop Created", "\u00a77" + this.shop.getCreatedTime().toString());
        this.setItem(15, created, null);
        ItemStack backButton = this.createItem(Material.ARROW, "\u00a7aBack to Shop", new String[0]);
        this.setItem(22, backButton, e -> {
            this.playClickSound();
            new PlayerShopGUI(this.player, this.plugin, this.shop).open();
        });
    }
}

