/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.models.TradeHistory;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TradeHistoryGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final List<TradeHistory> trades;
    private int currentPage = 0;
    private ViewMode viewMode = ViewMode.ALL;
    private static final int ITEMS_PER_PAGE = 28;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm");

    public TradeHistoryGUI(Player player, MarketPlacePlus plugin) {
        super(player, "\u00a76Trade History", 6);
        this.plugin = plugin;
        this.trades = new ArrayList<TradeHistory>();
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.BROWN_STAINED_GLASS_PANE);
        this.loadTrades();
        this.displayTrades();
        this.setupControls();
    }

    private void loadTrades() {
        this.trades.clear();
        List<TradeHistory> allTrades = this.plugin.getDatabaseManager().getPlayerTradeHistory(this.player.getUniqueId(), 100);
        switch (this.viewMode.ordinal()) {
            case 0: {
                this.trades.addAll(allTrades);
                break;
            }
            case 1: {
                for (TradeHistory trade : allTrades) {
                    if (!trade.getBuyerId().equals(this.player.getUniqueId())) continue;
                    this.trades.add(trade);
                }
                break;
            }
            case 2: {
                for (TradeHistory trade : allTrades) {
                    if (!trade.getSellerId().equals(this.player.getUniqueId())) continue;
                    this.trades.add(trade);
                }
                break;
            }
        }
    }

    private void displayTrades() {
        for (int i = 10; i <= 43; ++i) {
            if (i % 9 == 0 || i % 9 == 8) continue;
            this.inventory.setItem(i, null);
        }
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, this.trades.size());
        int slot = 10;
        for (int i = startIndex; i < endIndex; ++i) {
            if (slot % 9 == 0 || slot % 9 == 8) {
                ++slot;
            }
            if (slot > 43) break;
            TradeHistory trade = this.trades.get(i);
            ItemStack displayItem = this.createTradeItem(trade);
            this.setItem(slot, displayItem, null);
            ++slot;
        }
    }

    private ItemStack createTradeItem(TradeHistory trade) {
        ItemStack item = trade.getItem().clone();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
            lore.add("");
            lore.add("\u00a78\u00a7m--------------------");
            boolean isBuyer = trade.getBuyerId().equals(this.player.getUniqueId());
            if (isBuyer) {
                lore.add("\u00a7aPurchased from: \u00a7f" + trade.getSellerName());
            } else {
                lore.add("\u00a7eSold to: \u00a7f" + trade.getBuyerName());
            }
            lore.add("\u00a77Price: \u00a76" + this.plugin.getEconomyManager().formatMoney(trade.getPrice()));
            lore.add("\u00a77Quantity: \u00a7f" + trade.getQuantity());
            lore.add("\u00a77Total: \u00a76" + this.plugin.getEconomyManager().formatMoney(trade.getPrice()));
            lore.add("\u00a77Date: \u00a7f" + trade.getTradeTime().format(DATE_FORMAT));
            lore.add("\u00a77Type: \u00a7f" + this.formatTradeType(trade.getType()));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private String formatTradeType(TradeHistory.TradeType type) {
        switch (type) {
            case AUCTION_HOUSE: {
                return "Auction House";
            }
            case PLAYER_SHOP: {
                return "Player Shop";
            }
            case DIRECT_TRADE: {
                return "Direct Trade";
            }
        }
        return "Unknown";
    }

    private void setupControls() {
        int totalPages;
        ItemStack viewModeItem = this.createItem(Material.COMPASS, "\u00a76View Mode: \u00a7e" + this.viewMode.displayName, "\u00a77Click to change view mode", "", "\u00a7eLeft Click: \u00a77Next mode", "\u00a7eRight Click: \u00a77Previous mode");
        this.setItem(49, viewModeItem, e -> {
            this.playClickSound();
            if (e.isLeftClick()) {
                this.cycleViewMode(true);
            } else if (e.isRightClick()) {
                this.cycleViewMode(false);
            }
        });
        if (this.currentPage > 0) {
            ItemStack prevPage = this.createItem(Material.ARROW, "\u00a7aPrevious Page", "\u00a77Go to page " + this.currentPage);
            this.setItem(48, prevPage, e -> {
                this.playClickSound();
                --this.currentPage;
                this.refresh();
            });
        }
        if (this.currentPage < (totalPages = (int)Math.ceil((double)this.trades.size() / 28.0)) - 1) {
            ItemStack nextPage = this.createItem(Material.ARROW, "\u00a7aNext Page", "\u00a77Go to page " + (this.currentPage + 2));
            this.setItem(50, nextPage, e -> {
                this.playClickSound();
                ++this.currentPage;
                this.refresh();
            });
        }
        ItemStack statsItem = this.createItem(Material.BOOK, "\u00a76Trade Statistics", "\u00a77Total trades: \u00a7f" + this.trades.size(), "\u00a77Page: \u00a7f" + (this.currentPage + 1) + "/" + Math.max(1, totalPages));
        this.setItem(45, statsItem, null);
        ItemStack backButton = this.createItem(Material.BARRIER, "\u00a7cClose", new String[0]);
        this.setItem(53, backButton, e -> {
            this.playClickSound();
            this.player.closeInventory();
        });
    }

    private void cycleViewMode(boolean forward) {
        ViewMode[] modes = ViewMode.values();
        int currentIndex = this.viewMode.ordinal();
        this.viewMode = forward ? modes[(currentIndex + 1) % modes.length] : modes[(currentIndex - 1 + modes.length) % modes.length];
        this.currentPage = 0;
        this.refresh();
    }

    private static enum ViewMode {
        ALL("All Trades"),
        PURCHASES("My Purchases"),
        SALES("My Sales");

        private final String displayName;

        private ViewMode(String displayName) {
            this.displayName = displayName;
        }
    }
}

