/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPanelGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayerManageGUI;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.utils.TimeUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminListingsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final int page;
    private List<MarketItem> allListings;
    private static final int ITEMS_PER_PAGE = 28;
    private SortType currentSort = SortType.NEWEST;

    public AdminListingsGUI(MarketPlacePlus plugin, Player player, int page) {
        super(player, "\u00a7c\u00a7lManage All Listings - Page " + page, 6);
        this.plugin = plugin;
        this.page = page;
        this.loadListings();
    }

    private void loadListings() {
        this.allListings = new ArrayList<MarketItem>(this.plugin.getAuctionManager().getAllListings());
        this.sortListings();
    }

    private void sortListings() {
        switch (this.currentSort.ordinal()) {
            case 0: {
                this.allListings.sort((a, b) -> b.getListedTime().compareTo(a.getListedTime()));
                break;
            }
            case 1: {
                this.allListings.sort(Comparator.comparing(MarketItem::getListedTime));
                break;
            }
            case 2: {
                this.allListings.sort((a, b) -> Double.compare(b.getPrice(), a.getPrice()));
                break;
            }
            case 3: {
                this.allListings.sort(Comparator.comparingDouble(MarketItem::getPrice));
                break;
            }
            case 4: {
                this.allListings.sort((a, b) -> {
                    String nameA = Bukkit.getOfflinePlayer((UUID)a.getSellerId()).getName();
                    String nameB = Bukkit.getOfflinePlayer((UUID)b.getSellerId()).getName();
                    return nameA.compareToIgnoreCase(nameB);
                });
            }
        }
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        ItemStack backButton = this.createItem(Material.BARRIER, "\u00a7cBack to Admin Panel", "\u00a77Click to return");
        this.setItem(45, backButton, e -> new AdminPanelGUI(this.plugin, this.player).open());
        ItemStack sortButton = this.createItem(Material.HOPPER, "\u00a7eSort By: \u00a7f" + this.currentSort.name(), "\u00a77Click to change sorting", "", "\u00a77Current: \u00a7e" + this.currentSort.name());
        this.setItem(47, sortButton, e -> {
            this.currentSort = SortType.values()[(this.currentSort.ordinal() + 1) % SortType.values().length];
            this.sortListings();
            this.refresh();
        });
        ItemStack searchButton = this.createItem(Material.COMPASS, "\u00a7eSearch Listings", "\u00a77Search by item name", "\u00a77or seller name", "", "\u00a7eClick to search");
        this.setItem(49, searchButton, e -> {
            this.player.closeInventory();
            this.player.sendMessage("\u00a7ePlease type your search query:");
            MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                List<MarketItem> searchResults = this.plugin.getAdminManager().searchListings((String)input);
                if (searchResults.isEmpty()) {
                    this.player.sendMessage("\u00a7cNo listings found matching: " + input);
                    new AdminListingsGUI(this.plugin, this.player, this.page).open();
                } else {
                    this.allListings = searchResults;
                    new AdminListingsGUI(this.plugin, this.player, 1).open();
                }
            });
        });
        ItemStack statsItem = this.createItem(Material.BOOK, "\u00a76\u00a7lListing Statistics", "\u00a77Total Listings: \u00a7e" + this.allListings.size(), "\u00a77Auctions: \u00a7d" + this.allListings.stream().filter(MarketItem::isAuction).count(), "\u00a77Buy Now: \u00a76" + this.allListings.stream().filter(i -> !i.isAuction()).count(), "", "\u00a77Total Value: \u00a7a$" + String.format("%.2f", this.allListings.stream().mapToDouble(MarketItem::getPrice).sum()));
        this.setItem(51, statsItem, null);
        ItemStack bulkActions = this.createItem(Material.TNT, "\u00a7c\u00a7lBulk Actions", "\u00a77Mass delete listings", "\u00a77by criteria", "", "\u00a7cClick for options");
        this.setItem(53, bulkActions, e -> {
            this.player.sendMessage("\u00a7c\u00a7lBulk Actions:");
            this.player.sendMessage("\u00a77Coming soon...");
        });
        int startIndex = (this.page - 1) * 28;
        int endIndex = Math.min(startIndex + 28, this.allListings.size());
        int slot = 10;
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (slot % 9 == 0 || slot % 9 == 8) {
                ++slot;
            }
            if (slot >= 44) break;
            MarketItem listing = this.allListings.get(i2);
            ItemStack displayItem = listing.getItemStack().clone();
            ItemMeta meta = displayItem.getItemMeta();
            ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
            lore.add("");
            lore.add("\u00a77\u00a7m                              ");
            lore.add("\u00a77Seller: \u00a7f" + Bukkit.getOfflinePlayer((UUID)listing.getSellerId()).getName());
            lore.add("\u00a77Price: \u00a7a$" + String.format("%.2f", listing.getPrice()));
            lore.add("\u00a77Listed: \u00a7e" + TimeUtils.formatTime(System.currentTimeMillis() - listing.getListedTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
            if (listing.isAuction()) {
                lore.add("\u00a77Type: \u00a7dAuction");
                lore.add("\u00a77Current Bid: \u00a7a$" + String.format("%.2f", listing.getCurrentBid()));
                lore.add("\u00a77Bidders: \u00a7e" + listing.getBidders().size());
            } else {
                lore.add("\u00a77Type: \u00a76Buy Now");
            }
            lore.add("");
            lore.add("\u00a7c\u00a7lAdmin Actions:");
            lore.add("\u00a7e\u00a7lLeft Click \u00a77to delete");
            lore.add("\u00a7e\u00a7lRight Click \u00a77to adjust price");
            lore.add("\u00a7e\u00a7lShift-Left \u00a77to view seller");
            lore.add("\u00a7e\u00a7lShift-Right \u00a77to force expire");
            meta.setLore(lore);
            displayItem.setItemMeta(meta);
            this.setItem(slot, displayItem, e -> {
                if (e.isShiftClick() && e.isLeftClick()) {
                    new AdminPlayerManageGUI(this.plugin, this.player, Bukkit.getOfflinePlayer((UUID)listing.getSellerId())).open();
                } else if (e.isShiftClick() && e.isRightClick()) {
                    if (this.plugin.getAdminManager().forceExpireListing(listing.getIdAsUUID(), this.player)) {
                        this.player.sendMessage("\u00a7aSuccessfully expired listing!");
                        this.playSuccessSound();
                        this.refresh();
                    } else {
                        this.player.sendMessage("\u00a7cFailed to expire listing!");
                        this.playErrorSound();
                    }
                } else if (e.isLeftClick()) {
                    if (this.plugin.getAdminManager().deleteMarketListing(listing.getIdAsUUID(), this.player)) {
                        this.player.sendMessage("\u00a7aSuccessfully deleted listing!");
                        this.playSuccessSound();
                        this.refresh();
                    } else {
                        this.player.sendMessage("\u00a7cFailed to delete listing!");
                        this.playErrorSound();
                    }
                } else if (e.isRightClick()) {
                    this.player.closeInventory();
                    this.player.sendMessage("\u00a7eEnter new price for this listing:");
                    MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                        try {
                            double newPrice = Double.parseDouble(input);
                            if (newPrice <= 0.0) {
                                this.player.sendMessage("\u00a7cPrice must be greater than 0!");
                                new AdminListingsGUI(this.plugin, this.player, this.page).open();
                                return;
                            }
                            if (this.plugin.getAdminManager().adjustListingPrice(listing.getIdAsUUID(), newPrice, this.player)) {
                                this.player.sendMessage("\u00a7aPrice adjusted successfully!");
                                new AdminListingsGUI(this.plugin, this.player, this.page).open();
                            } else {
                                this.player.sendMessage("\u00a7cFailed to adjust price!");
                                new AdminListingsGUI(this.plugin, this.player, this.page).open();
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.player.sendMessage("\u00a7cInvalid price format!");
                            new AdminListingsGUI(this.plugin, this.player, this.page).open();
                        }
                    });
                }
            });
            ++slot;
        }
        int maxPages = (this.allListings.size() - 1) / 28;
        this.addNavigationButtons(this.page - 1, maxPages, () -> new AdminListingsGUI(this.plugin, this.player, this.page - 1).open(), () -> new AdminListingsGUI(this.plugin, this.player, this.page + 1).open());
    }

    private static enum SortType {
        NEWEST,
        OLDEST,
        PRICE_HIGH,
        PRICE_LOW,
        SELLER;

    }
}

