/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPanelGUI;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AdminSettingsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final SettingsCategory category;

    public AdminSettingsGUI(MarketPlacePlus plugin, Player player, SettingsCategory category) {
        super(player, "\u00a7c\u00a7lAdmin Settings - " + AdminSettingsGUI.getCategoryName(category), 6);
        this.plugin = plugin;
        this.category = category;
    }

    private static String getCategoryName(SettingsCategory category) {
        switch (category.ordinal()) {
            case 0: {
                return "Main Menu";
            }
            case 1: {
                return "Marketplace";
            }
            case 2: {
                return "Player Shops";
            }
            case 3: {
                return "Security";
            }
            case 4: {
                return "Discord";
            }
            case 5: {
                return "Advertisements";
            }
        }
        return "Settings";
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        if (this.category == SettingsCategory.MAIN) {
            this.setupMainMenu();
        } else {
            this.setupCategorySettings();
        }
        ItemStack backButton = this.createItem(Material.BARRIER, "\u00a7cBack", this.category == SettingsCategory.MAIN ? "\u00a77Return to Admin Panel" : "\u00a77Return to Settings Menu");
        this.setItem(49, backButton, e -> {
            if (this.category == SettingsCategory.MAIN) {
                new AdminPanelGUI(this.plugin, this.player).open();
            } else {
                new AdminSettingsGUI(this.plugin, this.player, SettingsCategory.MAIN).open();
            }
        });
    }

    private void setupMainMenu() {
        ItemStack marketplaceItem = this.createItem(Material.GOLD_INGOT, "\u00a76\u00a7lMarketplace Settings", "\u00a77Configure auction house settings:", "\u00a77\u2022 Max listings per player", "\u00a77\u2022 Listing fees and duration", "\u00a77\u2022 Price limits", "\u00a77\u2022 Auction settings", "", "\u00a7eClick to manage");
        this.setItem(11, marketplaceItem, e -> new AdminSettingsGUI(this.plugin, this.player, SettingsCategory.MARKETPLACE).open());
        ItemStack shopsItem = this.createItem(Material.CHEST, "\u00a7b\u00a7lPlayer Shop Settings", "\u00a77Configure player shops:", "\u00a77\u2022 Max shops per player", "\u00a77\u2022 Shop creation costs", "\u00a77\u2022 Tax rates", "\u00a77\u2022 Offline earnings", "", "\u00a7eClick to manage");
        this.setItem(13, shopsItem, e -> new AdminSettingsGUI(this.plugin, this.player, SettingsCategory.SHOPS).open());
        ItemStack securityItem = this.createItem(Material.SHIELD, "\u00a7c\u00a7lSecurity Settings", "\u00a77Configure protection features:", "\u00a77\u2022 Anti-scam measures", "\u00a77\u2022 Item verification", "\u00a77\u2022 Transaction logging", "\u00a77\u2022 Trade settings", "", "\u00a7eClick to manage");
        this.setItem(15, securityItem, e -> new AdminSettingsGUI(this.plugin, this.player, SettingsCategory.SECURITY).open());
        ItemStack discordItem = this.createItem(Material.BOOK, "\u00a79\u00a7lDiscord Integration", "\u00a77Configure Discord webhooks:", "\u00a77\u2022 Enable/disable notifications", "\u00a77\u2022 Webhook settings", "\u00a77\u2022 Notification types", "", this.plugin.getConfig().getBoolean("discord.enabled") ? "\u00a7aEnabled" : "\u00a7cDisabled", "", "\u00a7eClick to manage");
        this.setItem(29, discordItem, e -> new AdminSettingsGUI(this.plugin, this.player, SettingsCategory.DISCORD).open());
        ItemStack adsItem = this.createItem(Material.PAPER, "\u00a7e\u00a7lAdvertisement Settings", "\u00a77Configure the ad system:", "\u00a77\u2022 Enable/disable ads", "\u00a77\u2022 Ad costs and duration", "\u00a77\u2022 Broadcast settings", "", this.plugin.getConfig().getBoolean("advertisements.enabled") ? "\u00a7aEnabled" : "\u00a7cDisabled", "", "\u00a7eClick to manage");
        this.setItem(31, adsItem, e -> new AdminSettingsGUI(this.plugin, this.player, SettingsCategory.ADVERTISEMENTS).open());
        ItemStack reloadItem = this.createItem(Material.EMERALD, "\u00a7a\u00a7lReload Configuration", "\u00a77Reload all config files", "", "\u00a7c\u00a7lWarning: \u00a77Some changes may", "\u00a77require a server restart", "", "\u00a7eClick to reload");
        this.setItem(33, reloadItem, e -> {
            this.plugin.reload();
            this.player.sendMessage("\u00a7aConfiguration reloaded successfully!");
            this.playSuccessSound();
            this.refresh();
        });
    }

    private void setupCategorySettings() {
        switch (this.category.ordinal()) {
            case 1: {
                this.setupMarketplaceSettings();
                break;
            }
            case 2: {
                this.setupShopSettings();
                break;
            }
            case 3: {
                this.setupSecuritySettings();
                break;
            }
            case 4: {
                this.setupDiscordSettings();
                break;
            }
            case 5: {
                this.setupAdvertisementSettings();
            }
        }
    }

    private void setupMarketplaceSettings() {
        this.setNumberSetting(10, Material.CHEST, "\u00a76Max Listings Per Player", "auction-house.max-listings-per-player", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("auction-house.max-listings-per-player", 10), "\u00a77Maximum items each player can list");
        this.setNumberSetting(11, Material.CLOCK, "\u00a76Listing Duration", "auction-house.listing-duration-hours", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("auction-house.listing-duration-hours", 48) + " hours", "\u00a77How long listings stay active");
        this.setNumberSetting(12, Material.GOLD_NUGGET, "\u00a76Listing Fee Percentage", "auction-house.listing-fee-percentage", "\u00a77Current: \u00a7e" + String.format("%.1f", this.plugin.getConfig().getDouble("auction-house.listing-fee-percentage", 5.0)) + "%", "\u00a77Tax on creating listings");
        this.setNumberSetting(13, Material.IRON_NUGGET, "\u00a76Minimum Price", "auction-house.min-price", "\u00a77Current: \u00a7e$" + String.format("%.2f", this.plugin.getConfig().getDouble("auction-house.min-price", 1.0)), "\u00a77Lowest allowed listing price");
        this.setNumberSetting(14, Material.DIAMOND, "\u00a76Maximum Price", "auction-house.max-price", "\u00a77Current: \u00a7e$" + String.format("%.2f", this.plugin.getConfig().getDouble("auction-house.max-price", 1000000.0)), "\u00a77Highest allowed listing price");
        this.setNumberSetting(15, Material.ENDER_CHEST, "\u00a76Expired Items Claim Days", "auction-house.expired-items-claim-days", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("auction-house.expired-items-claim-days", 7) + " days", "\u00a77Days before expired items vanish");
        this.setNumberSetting(19, Material.GOLD_INGOT, "\u00a76Min Starting Bid", "auction-house.auctions.min-starting-bid", "\u00a77Current: \u00a7e$" + String.format("%.2f", this.plugin.getConfig().getDouble("auction-house.auctions.min-starting-bid", 100.0)), "\u00a77Minimum auction starting price");
        this.setNumberSetting(20, Material.GOLD_BLOCK, "\u00a76Max Starting Bid", "auction-house.auctions.max-starting-bid", "\u00a77Current: \u00a7e$" + String.format("%.2f", this.plugin.getConfig().getDouble("auction-house.auctions.max-starting-bid", 100000.0)), "\u00a77Maximum auction starting price");
        this.setNumberSetting(21, Material.EMERALD, "\u00a76Min Bid Increment", "auction-house.auctions.min-bid-increment", "\u00a77Current: \u00a7e$" + String.format("%.2f", this.plugin.getConfig().getDouble("auction-house.auctions.min-bid-increment", 10.0)), "\u00a77Minimum bid increase amount");
        this.setNumberSetting(22, Material.CLOCK, "\u00a76Max Auction Duration", "auction-house.auctions.max-duration-hours", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("auction-house.auctions.max-duration-hours", 72) + " hours", "\u00a77Maximum auction time limit");
        this.setToggleSetting(31, Material.LEVER, "\u00a76Marketplace Enabled", "auction-house.enabled", this.plugin.getConfig().getBoolean("auction-house.enabled", true), "\u00a77Enable or disable the marketplace");
    }

    private void setupShopSettings() {
        this.setNumberSetting(10, Material.CHEST, "\u00a7bMax Shops Per Player", "player-shops.max-shops-per-player", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("player-shops.max-shops-per-player", 3), "\u00a77Maximum shops each player can own");
        this.setNumberSetting(11, Material.HOPPER, "\u00a7bMax Items Per Shop", "player-shops.max-items-per-shop", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("player-shops.max-items-per-shop", 27), "\u00a77Items limit per shop");
        this.setNumberSetting(12, Material.GOLD_INGOT, "\u00a7bShop Creation Cost", "player-shops.shop-creation-cost", "\u00a77Current: \u00a7e$" + String.format("%.2f", this.plugin.getConfig().getDouble("player-shops.shop-creation-cost", 5000.0)), "\u00a77One-time fee to create a shop");
        this.setNumberSetting(13, Material.GOLD_NUGGET, "\u00a7bShop Tax Percentage", "player-shops.shop-tax-percentage", "\u00a77Current: \u00a7e" + String.format("%.1f", this.plugin.getConfig().getDouble("player-shops.shop-tax-percentage", 2.0)) + "%", "\u00a77Tax on all shop sales");
        this.setToggleSetting(21, Material.LEVER, "\u00a7bPlayer Shops Enabled", "player-shops.enabled", this.plugin.getConfig().getBoolean("player-shops.enabled", true), "\u00a77Enable or disable player shops");
        this.setToggleSetting(23, Material.RED_BED, "\u00a7bOffline Earnings", "player-shops.offline-earnings", this.plugin.getConfig().getBoolean("player-shops.offline-earnings", true), "\u00a77Allow shops to earn while offline");
    }

    private void setupSecuritySettings() {
        this.setToggleSetting(10, Material.BARRIER, "\u00a7cPrevent Renamed Scams", "protection.prevent-renamed-scams", this.plugin.getConfig().getBoolean("protection.prevent-renamed-scams", true), "\u00a77Block fake named items");
        this.setToggleSetting(11, Material.ENCHANTING_TABLE, "\u00a7cVerify Enchantments", "protection.verify-enchantments", this.plugin.getConfig().getBoolean("protection.verify-enchantments", true), "\u00a77Check enchants are legitimate");
        this.setToggleSetting(12, Material.NETHER_STAR, "\u00a7cCheck NBT Data", "protection.check-nbt-data", this.plugin.getConfig().getBoolean("protection.check-nbt-data", true), "\u00a77Deep item verification");
        this.setToggleSetting(13, Material.BOOK, "\u00a7cLog All Transactions", "protection.log-all-transactions", this.plugin.getConfig().getBoolean("protection.log-all-transactions", true), "\u00a77Keep detailed transaction logs");
        this.setToggleSetting(14, Material.TOTEM_OF_UNDYING, "\u00a7cDuplicate UUID Detection", "protection.duplicate-uuid-detection", this.plugin.getConfig().getBoolean("protection.duplicate-uuid-detection", true), "\u00a77Block items with duplicate UUIDs", "\u00a77Prevents duplication exploits");
        this.setNumberSetting(19, Material.COMPASS, "\u00a7cMax Trade Distance", "trade.max-trade-distance", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("trade.max-trade-distance", 10) + " blocks", "\u00a77Maximum distance for trading", "\u00a77Set to -1 for unlimited");
        this.setNumberSetting(20, Material.CLOCK, "\u00a7cTrade Timeout", "trade.confirmation-timeout-seconds", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("trade.confirmation-timeout-seconds", 30) + " seconds", "\u00a77Time to accept trades");
        this.setToggleSetting(21, Material.IRON_SWORD, "\u00a7cItem Verification", "trade.anti-scam.item-verification", this.plugin.getConfig().getBoolean("trade.anti-scam.item-verification", true), "\u00a77Verify items during trades");
        this.setToggleSetting(22, Material.TRIPWIRE_HOOK, "\u00a7cForce Confirmation", "trade.anti-scam.force-confirmation", this.plugin.getConfig().getBoolean("trade.anti-scam.force-confirmation", true), "\u00a77Both players must confirm trades");
        this.setToggleSetting(23, Material.REDSTONE_TORCH, "\u00a7cLog Suspicious Trades", "trade.anti-scam.log-suspicious-trades", this.plugin.getConfig().getBoolean("trade.anti-scam.log-suspicious-trades", true), "\u00a77Track potentially fraudulent trades");
    }

    private void setupDiscordSettings() {
        this.setToggleSetting(10, Material.LEVER, "\u00a79Discord Integration", "discord.enabled", this.plugin.getConfig().getBoolean("discord.enabled", false), "\u00a77Enable Discord notifications");
        String webhookUrl = this.plugin.getConfig().getString("discord.webhook-url", "");
        ItemStack webhookItem = this.createItem(Material.BOOK, "\u00a79Webhook URL", "\u00a77Current: " + (webhookUrl.isEmpty() ? "\u00a7cNot Set" : "\u00a7aConfigured"), "", "\u00a7eLeft-click to set URL", "\u00a7cRight-click to clear");
        this.setItem(11, webhookItem, e -> {
            if (e.isLeftClick()) {
                this.player.closeInventory();
                this.player.sendMessage("\u00a7eEnter the Discord webhook URL in chat:");
                MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                    if (!input.startsWith("https://discord.com/api/webhooks/") && !input.startsWith("https://discordapp.com/api/webhooks/")) {
                        this.player.sendMessage("\u00a7cInvalid webhook URL! Must be a Discord webhook URL.");
                        new AdminSettingsGUI(this.plugin, this.player, SettingsCategory.DISCORD).open();
                        return;
                    }
                    this.plugin.getConfig().set("discord.webhook-url", input);
                    this.plugin.saveConfig();
                    this.player.sendMessage("\u00a7aWebhook URL updated!");
                    new AdminSettingsGUI(this.plugin, this.player, SettingsCategory.DISCORD).open();
                });
            } else if (e.isRightClick()) {
                this.plugin.getConfig().set("discord.webhook-url", (Object)"");
                this.plugin.saveConfig();
                this.player.sendMessage("\u00a7cWebhook URL cleared!");
                this.refresh();
            }
        });
        this.setTextSetting(12, Material.NAME_TAG, "\u00a79Bot Name", "discord.bot-name", this.plugin.getConfig().getString("discord.bot-name", "MarketPlace Bot"), "\u00a77Discord bot display name");
        this.setTextSetting(13, Material.BEACON, "\u00a79Server Name", "server-name", this.plugin.getConfig().getString("server-name", "Server"), "\u00a77Server name for Discord embeds");
        this.setToggleSetting(19, Material.GOLD_INGOT, "\u00a79Notify Auction Sales", "discord.notify-auction-sales", this.plugin.getConfig().getBoolean("discord.notify-auction-sales", true), "\u00a77Send notifications when auctions sell");
        this.setToggleSetting(20, Material.CHEST, "\u00a79Notify Shop Sales", "discord.notify-shop-sales", this.plugin.getConfig().getBoolean("discord.notify-shop-sales", false), "\u00a77Send notifications for shop sales");
        this.setToggleSetting(21, Material.EMERALD, "\u00a79Notify New Listings", "discord.notify-new-listings", this.plugin.getConfig().getBoolean("discord.notify-new-listings", true), "\u00a77Send notifications for new listings");
        this.setToggleSetting(22, Material.DIAMOND, "\u00a79Notify New Auctions", "discord.notify-new-auctions", this.plugin.getConfig().getBoolean("discord.notify-new-auctions", true), "\u00a77Send notifications for new auctions");
    }

    private void setupAdvertisementSettings() {
        this.setToggleSetting(10, Material.LEVER, "\u00a7eAdvertisements Enabled", "advertisements.enabled", this.plugin.getConfig().getBoolean("advertisements.enabled", true), "\u00a77Enable the advertisement system");
        this.setNumberSetting(11, Material.GOLD_INGOT, "\u00a7eAdvertisement Cost", "advertisements.cost", "\u00a77Current: \u00a7e$" + String.format("%.2f", this.plugin.getConfig().getDouble("advertisements.cost", 5000.0)), "\u00a77Price to create an ad");
        this.setNumberSetting(12, Material.CLOCK, "\u00a7eAd Duration", "advertisements.duration-hours", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("advertisements.duration-hours", 1) + " hours", "\u00a77How long ads run");
        this.setNumberSetting(13, Material.ICE, "\u00a7eAd Cooldown", "advertisements.cooldown-hours", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("advertisements.cooldown-hours", 24) + " hours", "\u00a77Wait time between ads");
        this.setNumberSetting(14, Material.REPEATER, "\u00a7eBroadcast Interval", "advertisements.broadcast-interval-minutes", "\u00a77Current: \u00a7e" + this.plugin.getConfig().getInt("advertisements.broadcast-interval-minutes", 30) + " minutes", "\u00a77How often to show ads");
        this.setTextSetting(20, Material.PAPER, "\u00a7eBroadcast Prefix", "advertisements.broadcast-prefix", this.plugin.getConfig().getString("advertisements.broadcast-prefix", "[AD]"), "\u00a77Prefix for ad messages");
        this.setTextSetting(22, Material.BOOK, "\u00a7eBroadcast Format", "advertisements.broadcast-format", this.plugin.getConfig().getString("advertisements.broadcast-format", "{prefix} {shop}: {message}"), "\u00a77Format for ad messages", "\u00a77Placeholders:", "\u00a77{prefix} {shop} {message}");
    }

    private ItemStack createToggleSetting(Material material, String name, String path, boolean current, String ... lore) {
        ArrayList<Object> loreList = new ArrayList<Object>();
        loreList.add("\u00a77Current: " + (current ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        loreList.add("");
        for (String line : lore) {
            loreList.add(line);
        }
        loreList.add("");
        loreList.add("\u00a7eClick to toggle");
        return this.createItem(material, name, loreList.toArray(new String[0]));
    }

    private void setToggleSetting(int slot, Material material, String name, String path, boolean current, String ... lore) {
        ItemStack item = this.createToggleSetting(material, name, path, current, lore);
        this.setItem(slot, item, e -> {
            boolean newValue = !this.plugin.getConfig().getBoolean(path);
            this.plugin.getConfig().set(path, (Object)newValue);
            this.plugin.saveConfig();
            this.player.sendMessage("\u00a7aSetting updated: " + name + " \u00a77is now " + (newValue ? "\u00a7aEnabled" : "\u00a7cDisabled"));
            this.playSuccessSound();
            this.refresh();
        });
    }

    private ItemStack createNumberSetting(Material material, String name, String path, String ... lore) {
        ArrayList<String> loreList = new ArrayList<String>();
        for (String line : lore) {
            loreList.add(line);
        }
        loreList.add("");
        loreList.add("\u00a7eLeft-click to increase");
        loreList.add("\u00a7eRight-click to decrease");
        loreList.add("\u00a7eShift-click to set custom value");
        return this.createItem(material, name, loreList.toArray(new String[0]));
    }

    private void setNumberSetting(int slot, Material material, String name, String path, String ... lore) {
        ItemStack item = this.createNumberSetting(material, name, path, lore);
        this.setItem(slot, item, e -> {
            if (e.isShiftClick()) {
                this.player.closeInventory();
                this.player.sendMessage("\u00a7eEnter the new value in chat:");
                MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                    try {
                        if (path.contains("percentage") || path.contains("price") || path.contains("cost") || path.contains("bid") || path.contains("increment")) {
                            double value = Double.parseDouble(input);
                            if (value < 0.0) {
                                this.player.sendMessage("\u00a7cValue cannot be negative!");
                                new AdminSettingsGUI(this.plugin, this.player, this.category).open();
                                return;
                            }
                            this.plugin.getConfig().set(path, (Object)value);
                        } else {
                            int value = Integer.parseInt(input);
                            if (path.contains("max-trade-distance")) {
                                if (value < -1) {
                                    this.player.sendMessage("\u00a7cValue must be -1 (unlimited) or greater!");
                                    new AdminSettingsGUI(this.plugin, this.player, this.category).open();
                                    return;
                                }
                            } else if (value < 0) {
                                this.player.sendMessage("\u00a7cValue cannot be negative!");
                                new AdminSettingsGUI(this.plugin, this.player, this.category).open();
                                return;
                            }
                            this.plugin.getConfig().set(path, (Object)value);
                        }
                        this.plugin.saveConfig();
                        this.player.sendMessage("\u00a7aSetting updated!");
                        new AdminSettingsGUI(this.plugin, this.player, this.category).open();
                    }
                    catch (NumberFormatException ex) {
                        this.player.sendMessage("\u00a7cInvalid number! Please enter a valid number.");
                        new AdminSettingsGUI(this.plugin, this.player, this.category).open();
                    }
                });
            } else {
                Object current = this.plugin.getConfig().get(path);
                if (current instanceof Integer) {
                    int value = (Integer)current;
                    if (e.isLeftClick()) {
                        value += this.getIncrement(path);
                    } else {
                        int minValue = path.contains("max-trade-distance") ? -1 : 1;
                        value = Math.max(minValue, value - this.getIncrement(path));
                    }
                    this.plugin.getConfig().set(path, (Object)value);
                } else if (current instanceof Double) {
                    double value = (Double)current;
                    double increment = this.getDoubleIncrement(path);
                    if (e.isLeftClick()) {
                        value += increment;
                    } else {
                        double minValue = path.contains("percentage") ? 0.0 : 0.01;
                        value = Math.max(minValue, value - increment);
                    }
                    this.plugin.getConfig().set(path, (Object)value);
                }
                this.plugin.saveConfig();
                this.playSuccessSound();
                this.refresh();
            }
        });
    }

    private ItemStack createTextSetting(Material material, String name, String path, String current, String ... lore) {
        ArrayList<Object> loreList = new ArrayList<Object>();
        loreList.add("\u00a77Current: \u00a7f" + current);
        loreList.add("");
        for (String line : lore) {
            loreList.add(line);
        }
        loreList.add("");
        loreList.add("\u00a7eClick to edit");
        return this.createItem(material, name, loreList.toArray(new String[0]));
    }

    private void setTextSetting(int slot, Material material, String name, String path, String current, String ... lore) {
        String displayValue = current != null ? current : "";
        ItemStack item = this.createTextSetting(material, name, path, displayValue, lore);
        this.setItem(slot, item, e -> {
            this.player.closeInventory();
            this.player.sendMessage("\u00a7eEnter the new value in chat:");
            MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                if (input == null || input.trim().isEmpty()) {
                    this.player.sendMessage("\u00a7cValue cannot be empty!");
                    new AdminSettingsGUI(this.plugin, this.player, this.category).open();
                    return;
                }
                this.plugin.getConfig().set(path, input);
                this.plugin.saveConfig();
                this.player.sendMessage("\u00a7aSetting updated!");
                new AdminSettingsGUI(this.plugin, this.player, this.category).open();
            });
        });
    }

    private int getIncrement(String path) {
        if (path.contains("hours")) {
            return 1;
        }
        if (path.contains("days")) {
            return 1;
        }
        if (path.contains("minutes")) {
            return 5;
        }
        if (path.contains("seconds")) {
            return 5;
        }
        if (path.contains("distance")) {
            return 1;
        }
        if (path.contains("max-listings")) {
            return 1;
        }
        if (path.contains("max-shops")) {
            return 1;
        }
        if (path.contains("max-items")) {
            return 1;
        }
        return 10;
    }

    private double getDoubleIncrement(String path) {
        if (path.contains("percentage")) {
            return 0.5;
        }
        if (path.contains("min-price") || path.contains("min-starting-bid")) {
            return 10.0;
        }
        if (path.contains("max-price") || path.contains("max-starting-bid")) {
            return 1000.0;
        }
        if (path.contains("cost")) {
            return 100.0;
        }
        if (path.contains("increment")) {
            return 5.0;
        }
        return 1.0;
    }

    public static enum SettingsCategory {
        MAIN,
        MARKETPLACE,
        SHOPS,
        SECURITY,
        DISCORD,
        ADVERTISEMENTS;

    }
}

