/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayerManageGUI;
import MPP.marketPlacePlus.gui.admin.AdminShopsGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.utils.TimeUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminShopDetailsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final PlayerShop shop;

    public AdminShopDetailsGUI(MarketPlacePlus plugin, Player player, PlayerShop shop) {
        super(player, "\u00a7c\u00a7lShop Details: " + shop.getName(), 6);
        this.plugin = plugin;
        this.shop = shop;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        ItemStack backButton = this.createItem(Material.BARRIER, "\u00a7cBack to Shops", "\u00a77Click to return");
        this.setItem(45, backButton, e -> new AdminShopsGUI(this.plugin, this.player, 1).open());
        ItemStack shopInfo = this.createItem(this.shop.getIcon() != null ? this.shop.getIcon() : Material.CHEST, "\u00a7e" + this.shop.getName(), "\u00a77" + this.shop.getDescription(), "", "\u00a77Owner: \u00a7f" + this.shop.getOwnerName(), "\u00a77Location: \u00a7f" + this.shop.getLocationString(), "\u00a77Rating: " + this.shop.getFormattedRating(), "\u00a77Total Ratings: \u00a7e" + this.shop.getRatings().size(), "", "\u00a77Created: \u00a7e" + TimeUtils.formatTime(System.currentTimeMillis() - this.shop.getCreatedTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        this.setItem(4, shopInfo, null);
        ItemStack deleteShop = this.createItem(Material.TNT, "\u00a7c\u00a7lDelete Shop", "\u00a77Permanently delete", "\u00a77this shop", "", "\u00a7c\u00a7lWARNING:", "\u00a77This cannot be undone!", "", "\u00a7cClick to delete");
        this.setItem(49, deleteShop, e -> {
            this.player.closeInventory();
            this.player.sendMessage("\u00a7c\u00a7lWARNING: \u00a77This will permanently delete the shop!");
            this.player.sendMessage("\u00a77Type \u00a7cCONFIRM \u00a77to proceed or anything else to cancel:");
            MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                if (input.equalsIgnoreCase("CONFIRM")) {
                    if (this.plugin.getAdminManager().deletePlayerShop(this.shop.getIdAsUUID(), this.player)) {
                        this.player.sendMessage("\u00a7aShop deleted successfully!");
                        new AdminShopsGUI(this.plugin, this.player, 1).open();
                    } else {
                        this.player.sendMessage("\u00a7cFailed to delete shop!");
                        new AdminShopDetailsGUI(this.plugin, this.player, this.shop).open();
                    }
                } else {
                    this.player.sendMessage("\u00a7aDeletion cancelled.");
                    new AdminShopDetailsGUI(this.plugin, this.player, this.shop).open();
                }
            });
        });
        ItemStack teleportButton = this.createItem(Material.ENDER_PEARL, "\u00a7d\u00a7lTeleport to Shop", "\u00a77Teleport to shop location", "", "\u00a7eClick to teleport");
        this.setItem(51, teleportButton, e -> {
            if (this.shop.getLocation() != null) {
                this.player.teleport(this.shop.getLocation());
                this.player.sendMessage("\u00a7aTeleported to " + this.shop.getName());
                this.playSuccessSound();
            } else {
                this.player.sendMessage("\u00a7cShop location not set!");
                this.playErrorSound();
            }
        });
        ItemStack manageOwner = this.createItem(Material.PLAYER_HEAD, "\u00a7e\u00a7lManage Owner", "\u00a77View owner profile", "\u00a77Owner: \u00a7f" + this.shop.getOwnerName(), "", "\u00a7eClick to manage");
        this.setItem(53, manageOwner, e -> new AdminPlayerManageGUI(this.plugin, this.player, Bukkit.getOfflinePlayer((UUID)this.shop.getOwnerId())).open());
        int slot = 10;
        for (Map.Entry<Integer, ItemStack> entry : this.shop.getItemsAsItemStacks().entrySet()) {
            if (slot % 9 == 0 || slot % 9 == 8) {
                ++slot;
            }
            if (slot >= 44) break;
            ItemStack item = entry.getValue().clone();
            ItemMeta meta = item.getItemMeta();
            ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
            lore.add("");
            lore.add("\u00a77\u00a7m                    ");
            lore.add("\u00a77Price: \u00a7a$" + String.format("%.2f", this.shop.getItemPrice(entry.getKey())));
            lore.add("\u00a77Stock: \u00a7e" + item.getAmount());
            lore.add("");
            lore.add("\u00a7c\u00a7lAdmin Actions:");
            lore.add("\u00a7e\u00a7lLeft Click \u00a77to remove item");
            lore.add("\u00a7e\u00a7lRight Click \u00a77to change price");
            meta.setLore(lore);
            item.setItemMeta(meta);
            this.setItem(slot, item, e -> {
                if (e.isLeftClick()) {
                    this.shop.removeItem((Integer)entry.getKey());
                    this.plugin.getShopManager().saveShop(this.shop);
                    this.player.sendMessage("\u00a7aItem removed from shop!");
                    this.playSuccessSound();
                    this.refresh();
                } else if (e.isRightClick()) {
                    this.player.closeInventory();
                    this.player.sendMessage("\u00a7eEnter new price for this item:");
                    MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                        try {
                            double newPrice = Double.parseDouble(input);
                            if (newPrice <= 0.0) {
                                this.player.sendMessage("\u00a7cPrice must be greater than 0!");
                                new AdminShopDetailsGUI(this.plugin, this.player, this.shop).open();
                                return;
                            }
                            this.shop.setItemPrice((Integer)entry.getKey(), newPrice);
                            this.plugin.getShopManager().saveShop(this.shop);
                            this.player.sendMessage("\u00a7aPrice updated successfully!");
                            new AdminShopDetailsGUI(this.plugin, this.player, this.shop).open();
                        }
                        catch (NumberFormatException ex) {
                            this.player.sendMessage("\u00a7cInvalid price format!");
                            new AdminShopDetailsGUI(this.plugin, this.player, this.shop).open();
                        }
                    });
                }
            });
            ++slot;
        }
    }
}

