/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPanelGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayerManageGUI;
import MPP.marketPlacePlus.gui.admin.AdminShopDetailsGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.utils.TimeUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminShopsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final int page;
    private List<PlayerShop> allShops;
    private static final int ITEMS_PER_PAGE = 28;
    private SortType currentSort = SortType.RATING;

    public AdminShopsGUI(MarketPlacePlus plugin, Player player, int page) {
        super(player, "\u00a7c\u00a7lManage All Shops - Page " + page, 6);
        this.plugin = plugin;
        this.page = page;
        this.loadShops();
    }

    private void loadShops() {
        this.allShops = new ArrayList<PlayerShop>(this.plugin.getShopManager().getAllShops());
        this.sortShops();
    }

    private void sortShops() {
        switch (this.currentSort.ordinal()) {
            case 0: {
                this.allShops.sort((a, b) -> Double.compare(b.getAverageRating(), a.getAverageRating()));
                break;
            }
            case 1: {
                this.allShops.sort(Comparator.comparing(PlayerShop::getName));
                break;
            }
            case 2: {
                this.allShops.sort(Comparator.comparing(PlayerShop::getOwnerName));
                break;
            }
            case 3: {
                this.allShops.sort((a, b) -> Integer.compare(b.getItemsAsItemStacks().size(), a.getItemsAsItemStacks().size()));
                break;
            }
            case 4: {
                this.allShops.sort((a, b) -> b.getCreatedTime().compareTo(a.getCreatedTime()));
            }
        }
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        ItemStack backButton = this.createItem(Material.BARRIER, "\u00a7cBack to Admin Panel", "\u00a77Click to return");
        this.setItem(45, backButton, e -> new AdminPanelGUI(this.plugin, this.player).open());
        ItemStack sortButton = this.createItem(Material.HOPPER, "\u00a7eSort By: \u00a7f" + this.currentSort.name(), "\u00a77Click to change sorting", "", "\u00a77Current: \u00a7e" + this.currentSort.name());
        this.setItem(47, sortButton, e -> {
            this.currentSort = SortType.values()[(this.currentSort.ordinal() + 1) % SortType.values().length];
            this.sortShops();
            this.refresh();
        });
        ItemStack searchButton = this.createItem(Material.COMPASS, "\u00a7eSearch Shops", "\u00a77Search by shop name,", "\u00a77description, or owner", "", "\u00a7eClick to search");
        this.setItem(49, searchButton, e -> {
            this.player.closeInventory();
            this.player.sendMessage("\u00a7ePlease type your search query:");
            MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                List<PlayerShop> searchResults = this.plugin.getAdminManager().searchShops((String)input);
                if (searchResults.isEmpty()) {
                    this.player.sendMessage("\u00a7cNo shops found matching: " + input);
                    new AdminShopsGUI(this.plugin, this.player, this.page).open();
                } else {
                    this.allShops = searchResults;
                    new AdminShopsGUI(this.plugin, this.player, 1).open();
                }
            });
        });
        ItemStack statsItem = this.createItem(Material.BOOK, "\u00a76\u00a7lShop Statistics", "\u00a77Total Shops: \u00a7e" + this.allShops.size(), "\u00a77Total Items: \u00a7e" + this.allShops.stream().mapToInt(s -> s.getItemsAsItemStacks().size()).sum(), "\u00a77Average Rating: \u00a7e" + String.format("%.1f", this.allShops.stream().mapToDouble(PlayerShop::getAverageRating).average().orElse(0.0)), "", "\u00a77Shops with items: \u00a7e" + this.allShops.stream().filter(s -> !s.getItemsAsItemStacks().isEmpty()).count());
        this.setItem(51, statsItem, null);
        ItemStack bulkActions = this.createItem(Material.TNT, "\u00a7c\u00a7lBulk Actions", "\u00a77Delete empty shops", "\u00a77Delete inactive shops", "", "\u00a7cClick for options");
        this.setItem(53, bulkActions, e -> {
            this.player.sendMessage("\u00a7c\u00a7lBulk Actions:");
            this.player.sendMessage("\u00a77Coming soon...");
        });
        int startIndex = (this.page - 1) * 28;
        int endIndex = Math.min(startIndex + 28, this.allShops.size());
        int slot = 10;
        for (int i = startIndex; i < endIndex; ++i) {
            if (slot % 9 == 0 || slot % 9 == 8) {
                ++slot;
            }
            if (slot >= 44) break;
            PlayerShop shop = this.allShops.get(i);
            ItemStack shopItem = new ItemStack(shop.getIcon() != null ? shop.getIcon() : Material.CHEST);
            ItemMeta meta = shopItem.getItemMeta();
            meta.setDisplayName("\u00a7e" + shop.getName());
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77" + shop.getDescription());
            lore.add("");
            lore.add("\u00a77Owner: \u00a7f" + shop.getOwnerName());
            lore.add("\u00a77Items: \u00a7e" + shop.getItemsAsItemStacks().size());
            lore.add("\u00a77Rating: " + shop.getFormattedRating());
            lore.add("\u00a77Location: \u00a7f" + shop.getLocationString());
            lore.add("\u00a77Created: \u00a7e" + TimeUtils.formatTime(System.currentTimeMillis() - shop.getCreatedTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
            lore.add("");
            lore.add("\u00a7c\u00a7lAdmin Actions:");
            lore.add("\u00a7e\u00a7lLeft Click \u00a77to view details");
            lore.add("\u00a7e\u00a7lRight Click \u00a77to delete shop");
            lore.add("\u00a7e\u00a7lShift-Left \u00a77to teleport");
            lore.add("\u00a7e\u00a7lShift-Right \u00a77to manage owner");
            meta.setLore(lore);
            shopItem.setItemMeta(meta);
            this.setItem(slot, shopItem, e -> {
                if (e.isShiftClick() && e.isLeftClick()) {
                    if (shop.getLocation() != null) {
                        this.player.teleport(shop.getLocation());
                        this.player.sendMessage("\u00a7aTeleported to " + shop.getName());
                        this.playSuccessSound();
                    } else {
                        this.player.sendMessage("\u00a7cShop location not set!");
                        this.playErrorSound();
                    }
                } else if (e.isShiftClick() && e.isRightClick()) {
                    new AdminPlayerManageGUI(this.plugin, this.player, Bukkit.getOfflinePlayer((UUID)shop.getOwnerId())).open();
                } else if (e.isLeftClick()) {
                    new AdminShopDetailsGUI(this.plugin, this.player, shop).open();
                } else if (e.isRightClick()) {
                    if (this.plugin.getAdminManager().deletePlayerShop(shop.getIdAsUUID(), this.player)) {
                        this.player.sendMessage("\u00a7aSuccessfully deleted shop!");
                        this.playSuccessSound();
                        this.refresh();
                    } else {
                        this.player.sendMessage("\u00a7cFailed to delete shop!");
                        this.playErrorSound();
                    }
                }
            });
            ++slot;
        }
        int maxPages = (this.allShops.size() - 1) / 28;
        this.addNavigationButtons(this.page - 1, maxPages, () -> new AdminShopsGUI(this.plugin, this.player, this.page - 1).open(), () -> new AdminShopsGUI(this.plugin, this.player, this.page + 1).open());
    }

    private static enum SortType {
        RATING,
        NAME,
        OWNER,
        ITEMS,
        NEWEST;

    }
}

