/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.models.CollectableItem;
import MPP.marketPlacePlus.utils.AntiScamUtils;
import MPP.marketPlacePlus.utils.ItemUtils;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CollectionManager {
    private final MarketPlacePlus plugin;
    private final Map<UUID, List<CollectableItem>> playerCollections;
    private final Map<UUID, Long> lastNotificationTime;
    private static final long NOTIFICATION_COOLDOWN = 60000L;
    private boolean loaded = false;

    public CollectionManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.playerCollections = new ConcurrentHashMap<UUID, List<CollectableItem>>();
        this.lastNotificationTime = new ConcurrentHashMap<UUID, Long>();
        this.loadCollections();
        this.startCleanupTask();
    }

    public void addItem(UUID playerId, ItemStack itemStack, CollectableItem.CollectionType type, double price) {
        this.addItem(playerId, itemStack, type, price, true);
    }

    public void addItem(UUID playerId, ItemStack itemStack, CollectableItem.CollectionType type, double price, boolean sendMessage) {
        Player player;
        if (!this.verifyItemNotDuplicate(playerId, itemStack, type)) {
            this.plugin.getLogger().warning("Attempted to add duplicate item to collection for player: " + String.valueOf(playerId));
            return;
        }
        CollectableItem item = new CollectableItem(playerId, itemStack, type, price);
        this.playerCollections.computeIfAbsent(playerId, k -> new CopyOnWriteArrayList()).add(item);
        if (!this.saveItemToDatabase(item)) {
            this.playerCollections.get(playerId).remove(item);
            this.plugin.getLogger().severe("Failed to save item to database, removing from memory to maintain consistency");
            return;
        }
        if (sendMessage && (player = Bukkit.getPlayer((UUID)playerId)) != null && player.isOnline()) {
            String message = this.formatCollectionMessage(type, itemStack, price);
            player.sendMessage(message);
            player.sendMessage("\u00a7eUse \u00a76/market collect \u00a7eto retrieve your items!");
        }
    }

    public synchronized void addItems(UUID playerId, List<ItemStack> items, CollectableItem.CollectionType type, double price) {
        if (items.isEmpty()) {
            return;
        }
        List existingItems = this.playerCollections.getOrDefault(playerId, new CopyOnWriteArrayList());
        HashSet<Object> existingItemHashes = new HashSet<Object>();
        for (CollectableItem existing : existingItems) {
            if (existing.getType() != type || existing.isExpired()) continue;
            String hash = ItemUtils.serializeItem(existing.getItemStack()) + "_" + String.valueOf((Object)existing.getType());
            existingItemHashes.add(hash);
        }
        ArrayList<CollectableItem> collectables = new ArrayList<CollectableItem>();
        ArrayList<ItemStack> actuallyNewItems = new ArrayList<ItemStack>();
        for (ItemStack itemStack : items) {
            String hash = ItemUtils.serializeItem(itemStack) + "_" + String.valueOf((Object)type);
            if (!existingItemHashes.contains(hash)) {
                CollectableItem item = new CollectableItem(playerId, itemStack, type, price);
                collectables.add(item);
                actuallyNewItems.add(itemStack);
                existingItemHashes.add(hash);
                continue;
            }
            this.plugin.getLogger().warning("Skipped duplicate item in addItems() for player: " + String.valueOf(playerId));
        }
        if (collectables.isEmpty()) {
            return;
        }
        if (!this.saveItemsToDatabase(collectables)) {
            this.plugin.getLogger().severe("Failed to save items to database, aborting add to prevent inconsistency");
            return;
        }
        this.playerCollections.computeIfAbsent(playerId, k -> new CopyOnWriteArrayList()).addAll(collectables);
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player != null && player.isOnline()) {
            if (actuallyNewItems.size() == 1) {
                String message = this.formatCollectionMessage(type, (ItemStack)actuallyNewItems.get(0), price);
                player.sendMessage(message);
            } else if (actuallyNewItems.size() > 1) {
                player.sendMessage("\u00a7e\u00a7l" + actuallyNewItems.size() + " items \u00a7ehave been added to your collection box!");
            }
            if (!actuallyNewItems.isEmpty()) {
                player.sendMessage("\u00a7eUse \u00a76/market collect \u00a7eto retrieve your items!");
            }
        }
    }

    public synchronized void addItemsWithDuplicateCheck(UUID playerId, List<ItemStack> items, CollectableItem.CollectionType type, double price) {
        if (items.isEmpty()) {
            return;
        }
        List existingItems = this.playerCollections.getOrDefault(playerId, new CopyOnWriteArrayList());
        HashSet<Object> existingItemHashes = new HashSet<Object>();
        for (CollectableItem existing : existingItems) {
            if (existing.getType() != type || existing.isExpired()) continue;
            String hash = ItemUtils.serializeItem(existing.getItemStack()) + "_" + String.valueOf((Object)existing.getType());
            existingItemHashes.add(hash);
        }
        ArrayList<CollectableItem> newItems = new ArrayList<CollectableItem>();
        ArrayList<ItemStack> actuallyNewItems = new ArrayList<ItemStack>();
        for (ItemStack itemStack : items) {
            String hash = ItemUtils.serializeItem(itemStack) + "_" + String.valueOf((Object)type);
            if (existingItemHashes.contains(hash)) continue;
            CollectableItem item = new CollectableItem(playerId, itemStack, type, price);
            newItems.add(item);
            actuallyNewItems.add(itemStack);
            existingItemHashes.add(hash);
        }
        if (newItems.isEmpty()) {
            return;
        }
        if (!this.saveItemsToDatabase(newItems)) {
            this.plugin.getLogger().severe("Failed to save items with duplicate check to database, aborting to prevent inconsistency");
            return;
        }
        this.playerCollections.computeIfAbsent(playerId, k -> new CopyOnWriteArrayList()).addAll(newItems);
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player != null && player.isOnline()) {
            Long lastNotified = this.lastNotificationTime.get(playerId);
            long now = System.currentTimeMillis();
            if (lastNotified == null || now - lastNotified > 60000L) {
                if (actuallyNewItems.size() == 1) {
                    String message = this.formatCollectionMessage(type, (ItemStack)actuallyNewItems.get(0), price);
                    player.sendMessage(message);
                } else {
                    player.sendMessage("\u00a7e\u00a7l" + actuallyNewItems.size() + " items \u00a7ehave been added to your collection box!");
                }
                player.sendMessage("\u00a7eUse \u00a76/market collect \u00a7eto retrieve your items!");
                this.lastNotificationTime.put(playerId, now);
            }
        }
    }

    public List<CollectableItem> getPlayerItems(UUID playerId) {
        return ((List)this.playerCollections.getOrDefault(playerId, new ArrayList())).stream().filter(item -> !item.isExpired()).sorted(Comparator.comparing(CollectableItem::getAddedTime).reversed()).collect(Collectors.toList());
    }

    public synchronized boolean removeItem(UUID playerId, UUID itemId) {
        List<CollectableItem> items = this.playerCollections.get(playerId);
        if (items == null) {
            this.plugin.getLogger().warning("Attempted to remove item " + String.valueOf(itemId) + " but player " + String.valueOf(playerId) + " has no items in memory");
            return false;
        }
        CollectableItem foundItem = items.stream().filter(item -> item.getId().equals(itemId)).findFirst().orElse(null);
        if (foundItem == null) {
            this.plugin.getLogger().warning("Attempted to remove item " + String.valueOf(itemId) + " but it doesn't exist in memory for player " + String.valueOf(playerId));
            return false;
        }
        if (!this.removeItemFromDatabase(itemId)) {
            this.plugin.getLogger().severe("Failed to remove item " + String.valueOf(itemId) + " from database, aborting to prevent duplication!");
            return false;
        }
        boolean removedFromMemory = items.removeIf(item -> item.getId().equals(itemId));
        if (!removedFromMemory) {
            this.plugin.getLogger().severe("Critical: Item " + String.valueOf(itemId) + " was removed from DB but failed to remove from memory! This may cause sync issues.");
        }
        if (items.isEmpty()) {
            this.playerCollections.remove(playerId);
        }
        return true;
    }

    public int getItemCount(UUID playerId) {
        return (int)((List)this.playerCollections.getOrDefault(playerId, new ArrayList())).stream().filter(item -> !item.isExpired()).count();
    }

    public void tryAutoCollect(Player player) {
        int remaining;
        UUID playerId = player.getUniqueId();
        List<CollectableItem> items = this.getPlayerItems(playerId);
        if (items.isEmpty()) {
            return;
        }
        int collected = 0;
        ArrayList<CollectableItem> successfullyCollected = new ArrayList<CollectableItem>();
        for (CollectableItem item : items) {
            if (player.getInventory().firstEmpty() == -1) break;
            if (this.removeItem(playerId, item.getId())) {
                ItemStack itemToGive = item.getItemStack().clone();
                AntiScamUtils.clearItemUUID(itemToGive, (Plugin)this.plugin);
                player.getInventory().addItem(new ItemStack[]{itemToGive});
                successfullyCollected.add(item);
                ++collected;
                continue;
            }
            this.plugin.getLogger().severe("Failed to remove item " + String.valueOf(item.getId()) + " for player " + String.valueOf(playerId) + ", skipping to prevent duplication!");
        }
        if (collected > 0) {
            player.sendMessage("\u00a7a\u00a7lAuto-collected \u00a7f" + collected + " \u00a7a\u00a7litems from your collection box!");
        }
        if ((remaining = this.getItemCount(playerId)) > 0) {
            player.sendMessage("\u00a7eYou still have \u00a76" + remaining + " \u00a7eitems in your collection box!");
            player.sendMessage("\u00a7eUse \u00a76/market collect \u00a7eto retrieve them!");
        }
    }

    private synchronized void loadCollections() {
        if (this.loaded) {
            this.plugin.getLogger().warning("Collections already loaded, skipping duplicate load to prevent duplication!");
            return;
        }
        this.playerCollections.clear();
        String sql = "SELECT * FROM collection_items WHERE expiry_time > datetime('now') ORDER BY added_time ASC";
        HashMap<CallSite, CollectableItem> uniqueItems = new HashMap<CallSite, CollectableItem>();
        ArrayList<UUID> duplicatesToRemove = new ArrayList<UUID>();
        HashSet<UUID> loadedIds = new HashSet<UUID>();
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                if (loadedIds.contains(id)) {
                    this.plugin.getLogger().warning("Skipping duplicate ID in database: " + String.valueOf(id));
                    duplicatesToRemove.add(id);
                    continue;
                }
                loadedIds.add(id);
                UUID playerId = UUID.fromString(rs.getString("player_id"));
                ItemStack itemStack = ItemUtils.deserializeItem(rs.getString("item_data"));
                CollectableItem.CollectionType type = CollectableItem.CollectionType.valueOf(rs.getString("type"));
                double price = rs.getDouble("price");
                LocalDateTime addedTime = LocalDateTime.parse(rs.getString("added_time"));
                LocalDateTime expiryTime = LocalDateTime.parse(rs.getString("expiry_time"));
                String uniqueKey = String.valueOf(playerId) + "_" + ItemUtils.serializeItem(itemStack) + "_" + String.valueOf((Object)type);
                if (uniqueItems.containsKey(uniqueKey)) {
                    duplicatesToRemove.add(id);
                    this.plugin.getLogger().warning("Found duplicate collection item for player " + String.valueOf(playerId) + " (same item, different entry), removing duplicate with ID: " + String.valueOf(id));
                    continue;
                }
                CollectableItem item = new CollectableItem(id, playerId, itemStack, type, price, addedTime, expiryTime);
                uniqueItems.put((CallSite)((Object)uniqueKey), item);
                this.playerCollections.computeIfAbsent(playerId, k -> new CopyOnWriteArrayList()).add(item);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to load collection items: " + e.getMessage());
            e.printStackTrace();
        }
        if (!duplicatesToRemove.isEmpty()) {
            this.removeDuplicatesFromDatabase(duplicatesToRemove);
            this.plugin.getLogger().warning("Cleaned up " + duplicatesToRemove.size() + " duplicate collection items from database.");
        }
        this.loaded = true;
        this.plugin.getLogger().info("Loaded " + (loadedIds.size() - duplicatesToRemove.size()) + " collection items for " + this.playerCollections.size() + " players.");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean saveItemToDatabase(CollectableItem item) {
        String sql = "INSERT INTO collection_items (id, player_id, item_data, type, price, added_time, expiry_time) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, item.getId().toString());
                    stmt.setString(2, item.getPlayerId().toString());
                    stmt.setString(3, ItemUtils.serializeItem(item.getItemStack()));
                    stmt.setString(4, item.getType().name());
                    stmt.setDouble(5, item.getPrice());
                    stmt.setString(6, item.getAddedTime().toString());
                    stmt.setString(7, item.getExpiryTime().toString());
                    stmt.executeUpdate();
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to save collection item: " + e.getMessage());
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean saveItemsToDatabase(List<CollectableItem> items) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 23[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean removeItemFromDatabase(UUID itemId) {
        String sql = "DELETE FROM collection_items WHERE id = ?";
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();){
            boolean bl;
            block18: {
                PreparedStatement stmt;
                block16: {
                    boolean bl2;
                    block17: {
                        stmt = conn.prepareStatement(sql);
                        try {
                            conn.setAutoCommit(false);
                            stmt.setString(1, itemId.toString());
                            int rowsDeleted = stmt.executeUpdate();
                            if (rowsDeleted != 0) break block16;
                            conn.rollback();
                            this.plugin.getLogger().warning("Failed to delete collection item from database: " + String.valueOf(itemId));
                            conn.setAutoCommit(true);
                            bl2 = false;
                            if (stmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return bl2;
                }
                conn.commit();
                conn.setAutoCommit(true);
                bl = true;
                if (stmt == null) break block18;
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to remove collection item: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void removeDuplicatesFromDatabase(List<UUID> itemIds) {
        if (itemIds.isEmpty()) {
            return;
        }
        String sql = "DELETE FROM collection_items WHERE id = ?";
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            for (UUID itemId : itemIds) {
                stmt.setString(1, itemId.toString());
                stmt.addBatch();
            }
            int[] results = stmt.executeBatch();
            int totalDeleted = 0;
            for (int result : results) {
                if (result <= 0) continue;
                ++totalDeleted;
            }
            this.plugin.getLogger().info("Removed " + totalDeleted + " duplicate items from database.");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to remove duplicate collection items: " + e.getMessage());
        }
    }

    private void cleanupExpiredItems() {
        ArrayList<CollectableItem> expiredInMemory = new ArrayList<CollectableItem>();
        for (List<CollectableItem> items : this.playerCollections.values()) {
            for (CollectableItem item : items) {
                if (!item.isExpired()) continue;
                expiredInMemory.add(item);
            }
        }
        String sql = "DELETE FROM collection_items WHERE expiry_time <= datetime('now')";
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            int deleted = stmt.executeUpdate();
            if (deleted > 0) {
                this.plugin.getLogger().info("Cleaned up " + deleted + " expired collection items from database");
            }
            for (CollectableItem expired : expiredInMemory) {
                List<CollectableItem> playerItems = this.playerCollections.get(expired.getPlayerId());
                if (playerItems == null) continue;
                playerItems.remove(expired);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to cleanup expired items from database: " + e.getMessage());
        }
    }

    private void startCleanupTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            this.cleanupExpiredItems();
            this.verifyDatabaseSync();
        }, 72000L, 72000L);
    }

    private String formatCollectionMessage(CollectableItem.CollectionType type, ItemStack item, double price) {
        String itemName = item.getType().name().replace("_", " ").toLowerCase();
        switch (type) {
            case EXPIRED_LISTING: {
                return "\u00a7eYour listing for \u00a7f" + itemName + " \u00a7ehas expired and was added to your collection box!";
            }
            case SOLD_ITEM: {
                return "\u00a7aYour \u00a7f" + itemName + " \u00a7asold for \u00a76$" + String.format("%.2f", price) + "\u00a7a! Money has been added to your balance.";
            }
            case AUCTION_WON: {
                return "\u00a7a\u00a7lCongratulations! \u00a7aYou won the auction for \u00a7f" + itemName + "\u00a7a! Item added to collection box.";
            }
            case OUTBID_RETURN: {
                return "\u00a7cYou were outbid! Your bid of \u00a76$" + String.format("%.2f", price) + " \u00a7chas been returned.";
            }
            case CANCELLED_LISTING: {
                return "\u00a7eYour listing was cancelled and the item was added to your collection box.";
            }
            case SHOP_RETURN: {
                return "\u00a7eAn item from your shop was returned to your collection box.";
            }
        }
        return "\u00a7eAn item was added to your collection box!";
    }

    public boolean shouldNotifyPlayer(UUID playerId) {
        Long lastNotified = this.lastNotificationTime.get(playerId);
        if (lastNotified == null) {
            return true;
        }
        return System.currentTimeMillis() - lastNotified > 60000L;
    }

    public void updateLastNotificationTime(UUID playerId) {
        this.lastNotificationTime.put(playerId, System.currentTimeMillis());
    }

    private boolean verifyItemNotDuplicate(UUID playerId, ItemStack itemStack, CollectableItem.CollectionType type) {
        List<CollectableItem> playerItems = this.playerCollections.get(playerId);
        if (playerItems == null || playerItems.isEmpty()) {
            return true;
        }
        String itemHash = ItemUtils.serializeItem(itemStack) + "_" + String.valueOf((Object)type);
        for (CollectableItem existing : playerItems) {
            String existingHash;
            if (existing.getType() != type || existing.isExpired() || !itemHash.equals(existingHash = ItemUtils.serializeItem(existing.getItemStack()) + "_" + String.valueOf((Object)existing.getType()))) continue;
            return false;
        }
        return true;
    }

    public void saveAll() {
        this.verifyDatabaseSync();
        this.plugin.getLogger().info("Collection data is automatically saved to database");
    }

    public void verifyDatabaseSync() {
        String sql = "SELECT id, player_id FROM collection_items WHERE expiry_time > datetime('now')";
        HashSet<UUID> databaseIds = new HashSet<UUID>();
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString("id"));
                databaseIds.add(id);
            }
            HashSet<UUID> memoryIds = new HashSet<UUID>();
            for (List<CollectableItem> items : this.playerCollections.values()) {
                for (CollectableItem item2 : items) {
                    if (item2.isExpired()) continue;
                    memoryIds.add(item2.getId());
                }
            }
            HashSet inMemoryNotInDb = new HashSet(memoryIds);
            inMemoryNotInDb.removeAll(databaseIds);
            if (!inMemoryNotInDb.isEmpty()) {
                this.plugin.getLogger().warning("Found " + inMemoryNotInDb.size() + " items in memory but not in database - removing from memory to prevent duplication");
                for (UUID id : inMemoryNotInDb) {
                    for (List<CollectableItem> items : this.playerCollections.values()) {
                        items.removeIf(item -> item.getId().equals(id));
                    }
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to verify database sync: " + e.getMessage());
        }
    }
}

