/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.models;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class PlayerShop {
    private final String id;
    private final UUID ownerId;
    private final String ownerName;
    private String shopName;
    private String description;
    private final LocalDateTime createdTime;
    private final Map<Integer, ShopItem> items;
    private double totalEarnings;
    private boolean active;
    private int visitCount;
    private double averageRating;
    private int totalRatings;
    private Location location;
    private Material icon;
    private final Map<UUID, Integer> ratings;

    public PlayerShop(String id, UUID ownerId, String ownerName, String shopName, String description, LocalDateTime createdTime) {
        this.id = id;
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        this.shopName = shopName;
        this.description = description;
        this.createdTime = createdTime;
        this.items = new HashMap<Integer, ShopItem>();
        this.totalEarnings = 0.0;
        this.active = true;
        this.visitCount = 0;
        this.averageRating = 0.0;
        this.totalRatings = 0;
        this.ratings = new HashMap<UUID, Integer>();
        this.icon = Material.CHEST;
    }

    public void addItem(int slot, ItemStack item, double price, int stock) {
        this.items.put(slot, new ShopItem(item, price, stock));
    }

    public void removeItem(int slot) {
        this.items.remove(slot);
    }

    public synchronized boolean purchaseItem(int slot, int amount) {
        ShopItem shopItem = this.items.get(slot);
        if (shopItem == null || shopItem.getStock() < amount) {
            return false;
        }
        shopItem.decreaseStock(amount);
        this.totalEarnings += shopItem.getPrice() * (double)amount;
        if (shopItem.getStock() == 0) {
            this.items.remove(slot);
        }
        return true;
    }

    public void restockItem(int slot, int amount) {
        ShopItem shopItem = this.items.get(slot);
        if (shopItem != null) {
            shopItem.increaseStock(amount);
        }
    }

    public String getId() {
        return this.id;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getShopName() {
        return this.shopName;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDateTime getCreatedTime() {
        return this.createdTime;
    }

    public Map<Integer, ShopItem> getItems() {
        return this.items;
    }

    public double getTotalEarnings() {
        return this.totalEarnings;
    }

    public void setTotalEarnings(double totalEarnings) {
        this.totalEarnings = totalEarnings;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getVisitCount() {
        return this.visitCount;
    }

    public void incrementVisitCount() {
        ++this.visitCount;
    }

    public double getAverageRating() {
        return this.averageRating;
    }

    public int getTotalRatings() {
        return this.totalRatings;
    }

    public void setAverageRating(double averageRating) {
        this.averageRating = averageRating;
    }

    public void setTotalRatings(int totalRatings) {
        this.totalRatings = totalRatings;
    }

    public void addRating(int rating) {
        double totalScore = this.averageRating * (double)this.totalRatings;
        ++this.totalRatings;
        this.averageRating = (totalScore + (double)rating) / (double)this.totalRatings;
    }

    public String getDisplayName() {
        return this.shopName != null && !this.shopName.isEmpty() ? this.shopName : this.ownerName + "'s Shop";
    }

    public String getName() {
        return this.getDisplayName();
    }

    public UUID getIdAsUUID() {
        return UUID.fromString(this.id);
    }

    public String getLocationString() {
        if (this.location == null) {
            return "Not set";
        }
        return String.format("%s @ %d, %d, %d", this.location.getWorld().getName(), this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
    }

    public String getFormattedRating() {
        if (this.totalRatings == 0) {
            return "\u00a77No ratings";
        }
        int stars = (int)Math.round(this.averageRating);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            if (i < stars) {
                sb.append("\u00a76\u2605");
                continue;
            }
            sb.append("\u00a77\u2606");
        }
        return sb.toString() + " \u00a77(" + this.totalRatings + ")";
    }

    public Map<Integer, ItemStack> getItemsAsItemStacks() {
        HashMap<Integer, ItemStack> itemStacks = new HashMap<Integer, ItemStack>();
        for (Map.Entry<Integer, ShopItem> entry : this.items.entrySet()) {
            itemStacks.put(entry.getKey(), entry.getValue().getItem());
        }
        return itemStacks;
    }

    public double getItemPrice(int slot) {
        ShopItem item = this.items.get(slot);
        return item != null ? item.getPrice() : 0.0;
    }

    public void setItemPrice(int slot, double price) {
        ShopItem item = this.items.get(slot);
        if (item != null) {
            item.setPrice(price);
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Material getIcon() {
        return this.icon;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public Map<UUID, Integer> getRatings() {
        return this.ratings;
    }

    public static class ShopItem {
        private final ItemStack item;
        private double price;
        private int stock;

        public ShopItem(ItemStack item, double price, int stock) {
            this.item = item;
            this.price = price;
            this.stock = stock;
        }

        public void decreaseStock(int amount) {
            this.stock = Math.max(0, this.stock - amount);
        }

        public void increaseStock(int amount) {
            this.stock += amount;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public double getPrice() {
            return this.price;
        }

        public int getStock() {
            return this.stock;
        }

        public void setPrice(double price) {
            this.price = price;
        }
    }
}

