/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.models;

import java.time.LocalDateTime;
import java.util.UUID;

public class ShopAdvertisement {
    private final String shopId;
    private final UUID ownerId;
    private final String shopName;
    private final String message;
    private final LocalDateTime startTime;
    private final LocalDateTime endTime;
    private final double cost;

    public ShopAdvertisement(String shopId, UUID ownerId, String shopName, String message, LocalDateTime startTime, LocalDateTime endTime, double cost) {
        this.shopId = shopId;
        this.ownerId = ownerId;
        this.shopName = shopName;
        this.message = message;
        this.startTime = startTime;
        this.endTime = endTime;
        this.cost = cost;
    }

    public boolean isActive() {
        LocalDateTime now = LocalDateTime.now();
        return now.isAfter(this.startTime) && now.isBefore(this.endTime);
    }

    public String getShopId() {
        return this.shopId;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getShopName() {
        return this.shopName;
    }

    public String getMessage() {
        return this.message;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public double getCost() {
        return this.cost;
    }
}

