/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.utils;

import java.time.Duration;
import java.time.LocalDateTime;

public class TimeUtils {
    public static String formatTime(long milliseconds) {
        if (milliseconds < 0L) {
            return "Now";
        }
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return String.format("%dd %dh ago", days, hours % 24L);
        }
        if (hours > 0L) {
            return String.format("%dh %dm ago", hours, minutes % 60L);
        }
        if (minutes > 0L) {
            return String.format("%dm ago", minutes);
        }
        return "Just now";
    }

    public static String formatTimeAgo(LocalDateTime dateTime) {
        LocalDateTime now = LocalDateTime.now();
        Duration duration = Duration.between(dateTime, now);
        long days = duration.toDays();
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        if (days > 0L) {
            return String.format("%dd %dh ago", days, hours);
        }
        if (hours > 0L) {
            return String.format("%dh %dm ago", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format("%dm ago", minutes);
        }
        return "Just now";
    }
}

