/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.api;

import MPP.marketPlacePlus.utils.ItemUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemCompatibility {
    private static final Map<String, ItemProvider> providers = new HashMap<String, ItemProvider>();

    private static void registerMMOItemsSupport() {
        if (Bukkit.getPluginManager().getPlugin("MMOItems") != null) {
            providers.put("MMOItems", new ItemProvider(){

                @Override
                public String getItemId(ItemStack item) {
                    try {
                        ItemMeta meta = item.getItemMeta();
                        if (meta == null) {
                            return null;
                        }
                        PersistentDataContainer container = meta.getPersistentDataContainer();
                        NamespacedKey typeKey = new NamespacedKey("mmoitems", "item_type");
                        NamespacedKey idKey = new NamespacedKey("mmoitems", "item_id");
                        String type = (String)container.get(typeKey, PersistentDataType.STRING);
                        String id = (String)container.get(idKey, PersistentDataType.STRING);
                        if (type != null && id != null) {
                            return "mmoitems:" + type + ":" + id;
                        }
                    }
                    catch (Exception e) {
                        ItemCompatibility.logError("MMOItems", e);
                    }
                    return null;
                }

                @Override
                public String getItemName(ItemStack item) {
                    ItemMeta meta = item.getItemMeta();
                    return meta != null && meta.hasDisplayName() ? meta.getDisplayName() : null;
                }

                @Override
                public Map<String, Object> getItemData(ItemStack item) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    String itemId = this.getItemId(item);
                    if (itemId != null) {
                        data.put("plugin", "MMOItems");
                        data.put("id", itemId);
                    }
                    return data;
                }

                @Override
                public boolean isCustomItem(ItemStack item) {
                    return this.getItemId(item) != null;
                }
            });
        }
    }

    private static void registerItemsAdderSupport() {
        if (Bukkit.getPluginManager().getPlugin("ItemsAdder") != null) {
            providers.put("ItemsAdder", new ItemProvider(){

                @Override
                public String getItemId(ItemStack item) {
                    try {
                        Class<?> apiClass = Class.forName("dev.lone.itemsadder.api.CustomStack");
                        Method byItemStack = apiClass.getMethod("byItemStack", ItemStack.class);
                        Method getNamespacedID = apiClass.getMethod("getNamespacedID", new Class[0]);
                        Object customStack = byItemStack.invoke(null, item);
                        if (customStack != null) {
                            return "itemsadder:" + String.valueOf(getNamespacedID.invoke(customStack, new Object[0]));
                        }
                    }
                    catch (Exception e) {
                        ItemCompatibility.logError("ItemsAdder", e);
                    }
                    return null;
                }

                @Override
                public String getItemName(ItemStack item) {
                    ItemMeta meta = item.getItemMeta();
                    return meta != null && meta.hasDisplayName() ? meta.getDisplayName() : null;
                }

                @Override
                public Map<String, Object> getItemData(ItemStack item) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    String itemId = this.getItemId(item);
                    if (itemId != null) {
                        data.put("plugin", "ItemsAdder");
                        data.put("id", itemId);
                    }
                    return data;
                }

                @Override
                public boolean isCustomItem(ItemStack item) {
                    return this.getItemId(item) != null;
                }
            });
        }
    }

    private static void registerOraxenSupport() {
        if (Bukkit.getPluginManager().getPlugin("Oraxen") != null) {
            providers.put("Oraxen", new ItemProvider(){

                @Override
                public String getItemId(ItemStack item) {
                    try {
                        Class<?> apiClass = Class.forName("io.th0rgal.oraxen.api.OraxenItems");
                        Method getIdByItem = apiClass.getMethod("getIdByItem", ItemStack.class);
                        Object id = getIdByItem.invoke(null, item);
                        if (id != null) {
                            return "oraxen:" + String.valueOf(id);
                        }
                    }
                    catch (Exception e) {
                        ItemCompatibility.logError("Oraxen", e);
                    }
                    return null;
                }

                @Override
                public String getItemName(ItemStack item) {
                    ItemMeta meta = item.getItemMeta();
                    return meta != null && meta.hasDisplayName() ? meta.getDisplayName() : null;
                }

                @Override
                public Map<String, Object> getItemData(ItemStack item) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    String itemId = this.getItemId(item);
                    if (itemId != null) {
                        data.put("plugin", "Oraxen");
                        data.put("id", itemId);
                    }
                    return data;
                }

                @Override
                public boolean isCustomItem(ItemStack item) {
                    return this.getItemId(item) != null;
                }
            });
        }
    }

    private static void registerMythicMobsSupport() {
        if (Bukkit.getPluginManager().getPlugin("MythicMobs") != null) {
            providers.put("MythicMobs", new ItemProvider(){

                @Override
                public String getItemId(ItemStack item) {
                    try {
                        NamespacedKey key;
                        ItemMeta meta = item.getItemMeta();
                        if (meta == null) {
                            return null;
                        }
                        PersistentDataContainer container = meta.getPersistentDataContainer();
                        String type = (String)container.get(key = new NamespacedKey("mythicmobs", "type"), PersistentDataType.STRING);
                        if (type != null) {
                            return "mythicmobs:" + type;
                        }
                    }
                    catch (Exception e) {
                        ItemCompatibility.logError("MythicMobs", e);
                    }
                    return null;
                }

                @Override
                public String getItemName(ItemStack item) {
                    ItemMeta meta = item.getItemMeta();
                    return meta != null && meta.hasDisplayName() ? meta.getDisplayName() : null;
                }

                @Override
                public Map<String, Object> getItemData(ItemStack item) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    String itemId = this.getItemId(item);
                    if (itemId != null) {
                        data.put("plugin", "MythicMobs");
                        data.put("id", itemId);
                    }
                    return data;
                }

                @Override
                public boolean isCustomItem(ItemStack item) {
                    return this.getItemId(item) != null;
                }
            });
        }
    }

    public static String getCustomItemId(ItemStack item) {
        for (ItemProvider provider : providers.values()) {
            String id = provider.getItemId(item);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    public static boolean isCustomItem(ItemStack item) {
        for (ItemProvider provider : providers.values()) {
            if (!provider.isCustomItem(item)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> getCustomItemData(ItemStack item) {
        for (ItemProvider provider : providers.values()) {
            Map<String, Object> data = provider.getItemData(item);
            if (data.isEmpty()) continue;
            return data;
        }
        return new HashMap<String, Object>();
    }

    public static String getEnhancedItemKey(ItemStack item) {
        String customId = ItemCompatibility.getCustomItemId(item);
        if (customId != null) {
            return customId;
        }
        return ItemUtils.getItemKey(item);
    }

    public static void registerProvider(String name, ItemProvider provider) {
        providers.put(name, provider);
    }

    private static void logError(String plugin, Exception e) {
        Plugin marketPlacePlus = Bukkit.getPluginManager().getPlugin("MarketPlacePlus");
        if (marketPlacePlus != null) {
            marketPlacePlus.getLogger().log(Level.WARNING, "Error accessing " + plugin + " API: " + e.getMessage());
        }
    }

    static {
        ItemCompatibility.registerMMOItemsSupport();
        ItemCompatibility.registerItemsAdderSupport();
        ItemCompatibility.registerOraxenSupport();
        ItemCompatibility.registerMythicMobsSupport();
    }

    public static interface ItemProvider {
        public String getItemId(ItemStack var1);

        public String getItemName(ItemStack var1);

        public Map<String, Object> getItemData(ItemStack var1);

        public boolean isCustomItem(ItemStack var1);
    }
}

