/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.commands;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.admin.AdminListingsGUI;
import MPP.marketPlacePlus.gui.admin.AdminPanelGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayersGUI;
import MPP.marketPlacePlus.gui.admin.AdminShopsGUI;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.PlayerShop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class AdminCommand
implements CommandExecutor,
TabCompleter {
    private final MarketPlacePlus plugin;

    public AdminCommand(MarketPlacePlus plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getAdminManager().hasAdminPermission(player)) {
            player.sendMessage("\u00a7cYou don't have permission to use admin commands!");
            return true;
        }
        if (args.length == 0) {
            new AdminPanelGUI(this.plugin, player).open();
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "panel": {
                new AdminPanelGUI(this.plugin, player).open();
                break;
            }
            case "players": {
                new AdminPlayersGUI(this.plugin, player, 1).open();
                break;
            }
            case "listings": {
                new AdminListingsGUI(this.plugin, player, 1).open();
                break;
            }
            case "shops": {
                new AdminShopsGUI(this.plugin, player, 1).open();
                break;
            }
            case "ban": {
                this.handleBanCommand(player, args);
                break;
            }
            case "unban": {
                this.handleUnbanCommand(player, args);
                break;
            }
            case "clear": {
                this.handleClearCommand(player, args);
                break;
            }
            case "stats": {
                this.handleStatsCommand(player, args);
                break;
            }
            case "search": {
                this.handleSearchCommand(player, args);
                break;
            }
            case "reload": {
                if (this.plugin.getAdminManager().hasSpecificPermission(player, "reload")) {
                    this.plugin.reload();
                    player.sendMessage("\u00a7aMarketPlacePlus has been reloaded!");
                    break;
                }
                player.sendMessage("\u00a7cYou don't have permission to reload the plugin!");
                break;
            }
            case "help": {
                this.sendHelpMessage(player);
                break;
            }
            default: {
                player.sendMessage("\u00a7cUnknown subcommand. Use \u00a7e/mpadmin help \u00a7cfor a list of commands.");
            }
        }
        return true;
    }

    private void handleBanCommand(Player player, String[] args) {
        if (!this.plugin.getAdminManager().hasSpecificPermission(player, "manage.players")) {
            player.sendMessage("\u00a7cYou don't have permission to ban players!");
            return;
        }
        if (args.length < 3) {
            player.sendMessage("\u00a7cUsage: /mpadmin ban <player> <reason>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore()) {
            player.sendMessage("\u00a7cPlayer not found!");
            return;
        }
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        if (this.plugin.getAdminManager().banPlayerFromMarket(target.getUniqueId(), player, reason)) {
            player.sendMessage("\u00a7aSuccessfully banned \u00a7e" + target.getName() + " \u00a7afrom the marketplace!");
        } else {
            player.sendMessage("\u00a7cFailed to ban player!");
        }
    }

    private void handleUnbanCommand(Player player, String[] args) {
        if (!this.plugin.getAdminManager().hasSpecificPermission(player, "manage.players")) {
            player.sendMessage("\u00a7cYou don't have permission to unban players!");
            return;
        }
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /mpadmin unban <player>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore()) {
            player.sendMessage("\u00a7cPlayer not found!");
            return;
        }
        if (this.plugin.getAdminManager().unbanPlayerFromMarket(target.getUniqueId(), player)) {
            player.sendMessage("\u00a7aSuccessfully unbanned \u00a7e" + target.getName() + " \u00a7afrom the marketplace!");
        } else {
            player.sendMessage("\u00a7cFailed to unban player!");
        }
    }

    private void handleClearCommand(Player player, String[] args) {
        if (!this.plugin.getAdminManager().hasSpecificPermission(player, "manage.players")) {
            player.sendMessage("\u00a7cYou don't have permission to clear player data!");
            return;
        }
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /mpadmin clear <player>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore()) {
            player.sendMessage("\u00a7cPlayer not found!");
            return;
        }
        if (this.plugin.getAdminManager().clearPlayerData(target.getUniqueId(), player)) {
            player.sendMessage("\u00a7aSuccessfully cleared all market data for \u00a7e" + target.getName() + "\u00a7a!");
        } else {
            player.sendMessage("\u00a7cFailed to clear player data!");
        }
    }

    private void handleStatsCommand(Player player, String[] args) {
        if (args.length < 2) {
            Map<String, Object> stats = this.plugin.getAdminManager().getMarketStatistics();
            player.sendMessage("\u00a76\u00a7lMarket Statistics:");
            player.sendMessage("\u00a77Total Listings: \u00a7e" + String.valueOf(stats.get("totalListings")));
            player.sendMessage("\u00a77Total Shops: \u00a7e" + String.valueOf(stats.get("totalShops")));
            player.sendMessage("\u00a77Banned Players: \u00a7e" + String.valueOf(stats.get("totalBannedPlayers")));
            player.sendMessage("\u00a77Total Transactions: \u00a7e" + String.valueOf(stats.get("totalTransactions")));
            player.sendMessage("\u00a77Total Volume: \u00a7a$" + String.format("%.2f", stats.get("totalVolume")));
        } else {
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
            if (!target.hasPlayedBefore()) {
                player.sendMessage("\u00a7cPlayer not found!");
                return;
            }
            Map<String, Object> stats = this.plugin.getAdminManager().getPlayerStatistics(target.getUniqueId());
            player.sendMessage("\u00a76\u00a7lPlayer Statistics for " + target.getName() + ":");
            player.sendMessage("\u00a77Total Listings: \u00a7e" + String.valueOf(stats.get("totalListings")));
            player.sendMessage("\u00a77Active Listings: \u00a7e" + String.valueOf(stats.get("activeListings")));
            player.sendMessage("\u00a77Total Shops: \u00a7e" + String.valueOf(stats.get("totalShops")));
            player.sendMessage("\u00a77Total Earnings: \u00a7a$" + String.format("%.2f", stats.get("totalEarnings")));
            player.sendMessage("\u00a77Total Spent: \u00a7c$" + String.format("%.2f", stats.get("totalSpent")));
            player.sendMessage("\u00a77Banned: " + ((Boolean)stats.get("isBanned") != false ? "\u00a7cYes" : "\u00a7aNo"));
        }
    }

    private void handleSearchCommand(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /mpadmin search <query>");
            return;
        }
        String query = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        player.sendMessage("\u00a76\u00a7lSearch Results for: \u00a7e" + query);
        player.sendMessage("");
        List<MarketItem> listings = this.plugin.getAdminManager().searchListings(query);
        if (!listings.isEmpty()) {
            player.sendMessage("\u00a77Listings found: \u00a7e" + listings.size());
            listings.stream().limit(5L).forEach(item -> player.sendMessage("\u00a77- " + String.valueOf(item.getItemStack().getType()) + " by " + Bukkit.getOfflinePlayer((UUID)item.getSellerId()).getName() + " \u00a7a($" + item.getPrice() + ")"));
            if (listings.size() > 5) {
                player.sendMessage("\u00a77... and " + (listings.size() - 5) + " more");
            }
        }
        player.sendMessage("");
        List<PlayerShop> shops = this.plugin.getAdminManager().searchShops(query);
        if (!shops.isEmpty()) {
            player.sendMessage("\u00a77Shops found: \u00a7e" + shops.size());
            shops.stream().limit(5L).forEach(shop -> player.sendMessage("\u00a77- " + shop.getName() + " by " + shop.getOwnerName()));
            if (shops.size() > 5) {
                player.sendMessage("\u00a77... and " + (shops.size() - 5) + " more");
            }
        }
        if (listings.isEmpty() && shops.isEmpty()) {
            player.sendMessage("\u00a77No results found.");
        }
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage("\u00a76\u00a7lMarketPlacePlus Admin Commands:");
        player.sendMessage("\u00a7e/mpadmin \u00a77- Open admin panel");
        player.sendMessage("\u00a7e/mpadmin panel \u00a77- Open admin panel");
        player.sendMessage("\u00a7e/mpadmin players \u00a77- Manage players");
        player.sendMessage("\u00a7e/mpadmin listings \u00a77- Manage listings");
        player.sendMessage("\u00a7e/mpadmin shops \u00a77- Manage shops");
        player.sendMessage("\u00a7e/mpadmin ban <player> <reason> \u00a77- Ban player from market");
        player.sendMessage("\u00a7e/mpadmin unban <player> \u00a77- Unban player from market");
        player.sendMessage("\u00a7e/mpadmin clear <player> \u00a77- Clear player's market data");
        player.sendMessage("\u00a7e/mpadmin stats [player] \u00a77- View market/player statistics");
        player.sendMessage("\u00a7e/mpadmin search <query> \u00a77- Search listings and shops");
        player.sendMessage("\u00a7e/mpadmin reload \u00a77- Reload plugin configuration");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (!this.plugin.getAdminManager().hasAdminPermission(player)) {
            return Collections.emptyList();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("panel", "players", "listings", "shops", "ban", "unban", "clear", "stats", "search", "reload", "help"));
            return completions.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && ((subCommand = args[0].toLowerCase()).equals("ban") || subCommand.equals("unban") || subCommand.equals("clear") || subCommand.equals("stats"))) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

