/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.commands;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.AuctionHouseGUI;
import MPP.marketPlacePlus.gui.CollectionGUI;
import MPP.marketPlacePlus.gui.MarketStatsGUI;
import MPP.marketPlacePlus.gui.SellItemGUI;
import MPP.marketPlacePlus.gui.ShopManagementGUI;
import MPP.marketPlacePlus.gui.TradeHistoryGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.utils.AntiScamUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MarketCommand
implements CommandExecutor,
TabCompleter {
    private final MarketPlacePlus plugin;

    public MarketCommand(MarketPlacePlus plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (this.plugin.getAdminManager().isPlayerBanned(player.getUniqueId())) {
            player.sendMessage("\u00a7c\u00a7lMarket Ban: \u00a77You are banned from using the marketplace.");
            String reason = this.plugin.getAdminManager().getBanReason(player.getUniqueId());
            player.sendMessage("\u00a77Reason: \u00a7f" + reason);
            return true;
        }
        if (args.length == 0) {
            if (!player.hasPermission("marketplaceplus.use") || !player.hasPermission("marketplaceplus.auction.view")) {
                player.sendMessage("\u00a7cYou don't have permission to use the marketplace!");
                return true;
            }
            new AuctionHouseGUI(player, this.plugin).open();
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(player);
                break;
            }
            case "sell": {
                if (!player.hasPermission("marketplaceplus.auction.sell")) {
                    player.sendMessage("\u00a7cYou don't have permission to sell items!");
                    return true;
                }
                if (args.length >= 2) {
                    this.handleDirectSell(player, args);
                    break;
                }
                new SellItemGUI(player, this.plugin).open();
                break;
            }
            case "shop": {
                this.handleShopCommand(player, args);
                break;
            }
            case "history": {
                if (!player.hasPermission("marketplaceplus.auction.history")) {
                    player.sendMessage("\u00a7cYou don't have permission to view trade history!");
                    return true;
                }
                new TradeHistoryGUI(player, this.plugin).open();
                break;
            }
            case "search": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /market search <item name>");
                    return true;
                }
                String query = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                new AuctionHouseGUI(player, this.plugin).setSearchAndOpen(query);
                break;
            }
            case "reload": {
                if (!player.hasPermission("marketplaceplus.admin.reload")) {
                    player.sendMessage("\u00a7cYou don't have permission to reload the plugin!");
                    return true;
                }
                this.plugin.reloadConfig();
                player.sendMessage("\u00a7aMarketplace configuration reloaded!");
                break;
            }
            case "stats": {
                if (!player.hasPermission("marketplaceplus.stats")) {
                    player.sendMessage("\u00a7cYou don't have permission to view statistics!");
                    return true;
                }
                new MarketStatsGUI(player, this.plugin).open();
                break;
            }
            case "debug": {
                if (!player.hasPermission("marketplaceplus.admin.debug")) {
                    player.sendMessage("\u00a7cYou don't have permission to use debug commands!");
                    return true;
                }
                this.handleDebugCommand(player);
                break;
            }
            case "collect": 
            case "collection": {
                if (!player.hasPermission("marketplaceplus.collect")) {
                    player.sendMessage("\u00a7cYou don't have permission to access collections!");
                    return true;
                }
                new CollectionGUI(this.plugin, player).open();
                int itemCount = this.plugin.getCollectionManager().getItemCount(player.getUniqueId());
                if (itemCount <= 0) break;
                player.sendMessage("\u00a7aOpening collection box... \u00a77(" + itemCount + " items)");
                break;
            }
            default: {
                player.sendMessage("\u00a7cUnknown command. Use /market help for help.");
            }
        }
        return true;
    }

    private void handleDirectSell(Player player, String[] args) {
        try {
            double price = Double.parseDouble(args[1]);
            if (price <= 0.0) {
                player.sendMessage("\u00a7cPrice must be greater than 0!");
                return;
            }
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand == null || itemInHand.getType() == Material.AIR) {
                player.sendMessage("\u00a7cYou must hold an item to sell!");
                return;
            }
            if (this.plugin.getConfig().getBoolean("protection.prevent-renamed-scams") && AntiScamUtils.isItemSuspicious(itemInHand, (Plugin)this.plugin)) {
                player.sendMessage("\u00a7cThis item appears to be suspicious and cannot be sold!");
                return;
            }
            if (this.plugin.getAuctionManager().createListing(player, itemInHand.clone(), price)) {
                player.getInventory().setItemInMainHand(null);
                player.updateInventory();
                player.sendMessage("\u00a7aItem listed successfully for " + this.plugin.getEconomyManager().formatMoney(price) + "!");
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> new AuctionHouseGUI(player, this.plugin).open(), 2L);
            } else {
                player.sendMessage("\u00a7cFailed to list item! Check your balance and listing limit.");
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cInvalid price! Usage: /market sell <price>");
        }
    }

    private void handleShopCommand(Player player, String[] args) {
        String shopAction;
        if (args.length == 1) {
            List<PlayerShop> playerShops = this.plugin.getShopManager().getPlayerShops(player.getUniqueId());
            if (!playerShops.isEmpty()) {
                new ShopManagementGUI(player, this.plugin).open();
            } else {
                player.sendMessage("\u00a7cYou don't have any shops! Use /market shop create <name> to create one.");
            }
            return;
        }
        switch (shopAction = args[1].toLowerCase()) {
            case "create": {
                if (!player.hasPermission("marketplaceplus.shop.create")) {
                    player.sendMessage("\u00a7cYou don't have permission to create shops!");
                    return;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /market shop create <shop name>");
                    return;
                }
                String shopName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                if (this.plugin.getShopManager().createShop(player, shopName, "")) {
                    player.sendMessage("\u00a7aShop created successfully!");
                    break;
                }
                player.sendMessage("\u00a7cFailed to create shop! Check your balance and shop limit.");
                break;
            }
            case "list": {
                List<PlayerShop> playerShops = this.plugin.getShopManager().getPlayerShops(player.getUniqueId());
                if (playerShops.isEmpty()) {
                    player.sendMessage("\u00a7cYou don't own any shops!");
                    break;
                }
                player.sendMessage("\u00a76Your shops:");
                for (PlayerShop shop : playerShops) {
                    player.sendMessage("\u00a7e- " + shop.getShopName() + " \u00a77(ID: " + shop.getId().substring(0, 8) + ")");
                }
                break;
            }
            case "manage": {
                new ShopManagementGUI(player, this.plugin).open();
                break;
            }
            default: {
                player.sendMessage("\u00a7cUnknown shop command. Use /market shop [create/list/manage]");
            }
        }
    }

    private void handleDebugCommand(Player player) {
        block30: {
            player.sendMessage("\u00a76=== MarketPlace Debug Info ===");
            try {
                Connection conn = this.plugin.getDatabaseManager().getConnection();
                if (conn != null && !conn.isClosed()) {
                    ResultSet rs;
                    player.sendMessage("\u00a7aDatabase: Connected");
                    try (Statement stmt = conn.createStatement();){
                        rs = stmt.executeQuery("SELECT COUNT(*) FROM market_listings");
                        try {
                            if (rs.next()) {
                                player.sendMessage("\u00a7eTotal listings in database: " + rs.getInt(1));
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    stmt = conn.createStatement();
                    try {
                        rs = stmt.executeQuery("SELECT COUNT(*) FROM market_listings WHERE sold = 0");
                        try {
                            if (rs.next()) {
                                player.sendMessage("\u00a7eActive listings in database: " + rs.getInt(1));
                            }
                            break block30;
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                player.sendMessage("\u00a7cDatabase: Not connected!");
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cDatabase error: " + e.getMessage());
            }
        }
        player.sendMessage("\u00a7eListings in memory: " + this.plugin.getAuctionManager().getActiveListings().size());
        player.sendMessage("\u00a76=== Recent Listings (Memory) ===");
        this.plugin.getAuctionManager().getActiveListings().stream().limit(5L).forEach(item -> player.sendMessage("\u00a77- " + String.valueOf(item.getItemStack().getType()) + " x" + item.getItemStack().getAmount() + " for $" + item.getPrice() + " by " + item.getSellerName()));
    }

    private void sendHelp(Player player) {
        player.sendMessage("\u00a76=== MarketPlace Plus Help ===");
        player.sendMessage("\u00a7e/market \u00a77- Open the auction house");
        player.sendMessage("\u00a7e/market sell \u00a77- List an item for sale (GUI)");
        player.sendMessage("\u00a7e/market sell <price> \u00a77- Quick sell item in hand");
        player.sendMessage("\u00a7e/market shop \u00a77- Access nearby player shop");
        player.sendMessage("\u00a7e/market shop create <name> \u00a77- Create a shop at your location");
        player.sendMessage("\u00a7e/market shop list \u00a77- List your shops");
        player.sendMessage("\u00a7e/market shop manage \u00a77- Manage your shops");
        player.sendMessage("\u00a7e/market history \u00a77- View trade history");
        player.sendMessage("\u00a7e/market search <item> \u00a77- Search for items");
        player.sendMessage("\u00a7e/market stats \u00a77- View market statistics");
        player.sendMessage("\u00a7e/market collect \u00a77- Access your collection box");
        if (player.hasPermission("marketplaceplus.admin.reload")) {
            player.sendMessage("\u00a7e/market reload \u00a77- Reload configuration");
        }
        if (player.hasPermission("marketplaceplus.admin.debug")) {
            player.sendMessage("\u00a7e/market debug \u00a77- Debug commands");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("help", "sell", "shop", "history", "search", "stats", "collect"));
            if (player.hasPermission("marketplaceplus.admin.reload")) {
                completions.add("reload");
            }
            if (player.hasPermission("marketplaceplus.admin.debug")) {
                completions.add("debug");
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("shop")) {
            completions.addAll(Arrays.asList("create", "list", "manage"));
        }
        return completions.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

