/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.config;

import MPP.marketPlacePlus.MarketPlacePlus;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final MarketPlacePlus plugin;
    private FileConfiguration config;

    public ConfigManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getDatabaseType() {
        return this.config.getString("database.type", "SQLITE");
    }

    public String getCurrencySymbol() {
        return this.config.getString("economy.currency-symbol", "$");
    }

    public boolean useVault() {
        return this.config.getBoolean("economy.use-vault", true);
    }

    public boolean isAuctionHouseEnabled() {
        return this.config.getBoolean("auction-house.enabled", true);
    }

    public int getMaxListingsPerPlayer() {
        return this.config.getInt("auction-house.max-listings-per-player", 10);
    }

    public int getListingDurationHours() {
        return this.config.getInt("auction-house.listing-duration-hours", 48);
    }

    public double getListingFeePercentage() {
        return this.config.getDouble("auction-house.listing-fee-percentage", 5.0);
    }

    public double getMaxPrice() {
        return this.config.getDouble("auction-house.max-price", 1000000.0);
    }

    public double getMinPrice() {
        return this.config.getDouble("auction-house.min-price", 1.0);
    }

    public boolean arePlayerShopsEnabled() {
        return this.config.getBoolean("player-shops.enabled", true);
    }

    public int getMaxShopsPerPlayer() {
        return this.config.getInt("player-shops.max-shops-per-player", 3);
    }

    public double getShopCreationCost() {
        return this.config.getDouble("player-shops.shop-creation-cost", 5000.0);
    }

    public double getShopTaxPercentage() {
        return this.config.getDouble("player-shops.shop-tax-percentage", 2.0);
    }

    public double getShopRadius() {
        return this.config.getDouble("player-shops.shop-radius", 10.0);
    }

    public boolean preventRenamedScams() {
        return this.config.getBoolean("protection.prevent-renamed-scams", true);
    }

    public boolean verifyEnchantments() {
        return this.config.getBoolean("protection.verify-enchantments", true);
    }

    public boolean checkNBTData() {
        return this.config.getBoolean("protection.check-nbt-data", true);
    }

    public boolean logAllTransactions() {
        return this.config.getBoolean("protection.log-all-transactions", true);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

