/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.AuctionHouseGUI;
import MPP.marketPlacePlus.gui.BaseGUI;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CategoryFilterGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final Consumer<String> onSelect;

    public CategoryFilterGUI(Player player, MarketPlacePlus plugin, Consumer<String> onSelect) {
        super(player, "\u00a76Select Category", 4);
        this.plugin = plugin;
        this.onSelect = onSelect;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.ORANGE_STAINED_GLASS_PANE);
        ItemStack allItems = this.createItem(Material.CHEST, "\u00a7aAll Items", "\u00a77Show all items");
        this.setItem(10, allItems, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("ALL"));
        });
        ItemStack weaponsTools = this.createItem(Material.DIAMOND_SWORD, "\u00a7cWeapons & Tools", "\u00a77Swords, axes, pickaxes, etc.");
        this.setItem(11, weaponsTools, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("WEAPONS_TOOLS"));
        });
        ItemStack armor = this.createItem(Material.DIAMOND_CHESTPLATE, "\u00a7bArmor", "\u00a77All armor pieces");
        this.setItem(12, armor, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("ARMOR"));
        });
        ItemStack consumables = this.createItem(Material.GOLDEN_APPLE, "\u00a7dConsumables", "\u00a77Food, potions, etc.");
        this.setItem(13, consumables, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("CONSUMABLES"));
        });
        ItemStack blocks = this.createItem(Material.STONE, "\u00a77Blocks", "\u00a77Building blocks");
        this.setItem(14, blocks, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("BLOCKS"));
        });
        ItemStack materials = this.createItem(Material.IRON_INGOT, "\u00a7eMaterials", "\u00a77Crafting materials");
        this.setItem(15, materials, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("MATERIALS"));
        });
        ItemStack enchantedBooks = this.createItem(Material.ENCHANTED_BOOK, "\u00a7dEnchanted Books", "\u00a77All enchanted books");
        this.setItem(16, enchantedBooks, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("ENCHANTED_BOOKS"));
        });
        ItemStack redstone = this.createItem(Material.REDSTONE, "\u00a7cRedstone", "\u00a77Redstone components");
        this.setItem(19, redstone, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("REDSTONE"));
        });
        ItemStack decorative = this.createItem(Material.PAINTING, "\u00a76Decorative", "\u00a77Decorative items");
        this.setItem(20, decorative, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("DECORATIVE"));
        });
        ItemStack specialItems = this.createItem(Material.ENDER_PEARL, "\u00a75Special Items", "\u00a77Special and unique items");
        this.setItem(21, specialItems, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.onSelect.accept("SPECIAL_ITEMS"));
        });
        ItemStack backButton = this.createItem(Material.ARROW, "\u00a7cBack", "\u00a77Return to auction house");
        this.setItem(31, backButton, e -> {
            this.playClickSound();
            new AuctionHouseGUI(this.player, this.plugin).open();
        });
    }
}

