/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.ShopSettingsGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import java.time.Duration;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CreateAdvertisementGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final PlayerShop shop;

    public CreateAdvertisementGUI(Player player, MarketPlacePlus plugin, PlayerShop shop) {
        super(player, "Advertise " + shop.getShopName(), 4);
        this.plugin = plugin;
        this.shop = shop;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.YELLOW_STAINED_GLASS_PANE);
        double cost = this.plugin.getConfig().getDouble("advertisements.cost", 5000.0);
        int durationHours = this.plugin.getConfig().getInt("advertisements.duration-hours", 1);
        int cooldownHours = this.plugin.getConfig().getInt("advertisements.cooldown-hours", 24);
        boolean canAdvertise = this.plugin.getAdvertisementManager().canAdvertise(this.player);
        long cooldownMillis = this.plugin.getAdvertisementManager().getTimeUntilNextAd(this.player);
        ItemStack info = this.createItem(Material.PAPER, "\u00a76Advertisement Information", "\u00a77Cost: \u00a7a" + this.plugin.getEconomyManager().formatMoney(cost), "\u00a77Duration: \u00a7b" + durationHours + " hour(s)", "\u00a77Cooldown: \u00a7c" + cooldownHours + " hour(s)", "", "\u00a77Your ad will be broadcast", "\u00a77periodically to all players!");
        this.setItem(10, info, null);
        if (canAdvertise) {
            ItemStack create = this.createItem(Material.EMERALD_BLOCK, "\u00a7aCreate Advertisement", "\u00a77Click to create an ad for", "\u00a77your shop: \u00a7e" + this.shop.getShopName(), "", "\u00a77Cost: \u00a7a" + this.plugin.getEconomyManager().formatMoney(cost), "", "\u00a7eClick to continue");
            this.setItem(13, create, e -> {
                if (!this.player.hasPermission("marketplaceplus.shop.advertise")) {
                    this.playErrorSound();
                    this.player.sendMessage("\u00a7cYou don't have permission to create advertisements!");
                    return;
                }
                this.playClickSound();
                if (!this.plugin.getEconomyManager().hasBalance(this.player, cost)) {
                    this.player.sendMessage("\u00a7cYou need " + this.plugin.getEconomyManager().formatMoney(cost) + " to create an advertisement!");
                    this.player.closeInventory();
                    return;
                }
                this.player.closeInventory();
                this.player.sendMessage("\u00a7eEnter your advertisement message:");
                this.player.sendMessage("\u00a77(Max 128 characters, color codes supported with &)");
                this.plugin.getChatInputManager().waitForInput(this.player, message -> {
                    if (message.length() > 128) {
                        this.player.sendMessage("\u00a7cMessage too long! Max 128 characters.");
                        return;
                    }
                    if (this.plugin.getAdvertisementManager().createAdvertisement(this.player, this.shop, (String)message)) {
                        this.player.sendMessage("\u00a7aAdvertisement created successfully!");
                        this.player.sendMessage("\u00a77Your ad will run for \u00a7b" + durationHours + " hour(s)\u00a77.");
                    } else {
                        this.player.sendMessage("\u00a7cFailed to create advertisement!");
                    }
                });
            });
        } else {
            Duration cooldown = Duration.ofMillis(cooldownMillis);
            long hours = cooldown.toHours();
            long minutes = cooldown.toMinutes() % 60L;
            ItemStack onCooldown = this.createItem(Material.REDSTONE_BLOCK, "\u00a7cOn Cooldown", "\u00a77You must wait before", "\u00a77creating another ad.", "", "\u00a77Time remaining:", "\u00a7c" + hours + "h " + minutes + "m", "", "\u00a77Come back later!");
            this.setItem(13, onCooldown, null);
        }
        ItemStack preview = this.createItem(Material.WRITABLE_BOOK, "\u00a76Preview Format", "\u00a77Your ad will look like:", "", this.plugin.getConfig().getString("advertisements.broadcast-prefix", "\u00a76[AD]") + " \u00a7e" + this.shop.getShopName() + " \u00a77- \u00a7f<your message>");
        this.setItem(16, preview, null);
        ItemStack back = this.createItem(Material.ARROW, "\u00a7cBack", new String[0]);
        this.setItem(31, back, e -> {
            this.playClickSound();
            new ShopSettingsGUI(this.player, this.plugin, this.shop).open();
        });
    }
}

