/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.AuctionHouseGUI;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.ConfirmCancelGUI;
import MPP.marketPlacePlus.models.CollectableItem;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.utils.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MyListingsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;

    public MyListingsGUI(Player player, MarketPlacePlus plugin) {
        super(player, "\u00a76My Listings", 5);
        this.plugin = plugin;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.ORANGE_STAINED_GLASS_PANE);
        List<MarketItem> myListings = this.plugin.getAuctionManager().getPlayerListings(this.player.getUniqueId());
        for (int i = 0; i < Math.min(myListings.size(), 28); ++i) {
            ItemStack display;
            ItemMeta meta;
            MarketItem item = myListings.get(i);
            if (item.getItemStack() == null || (meta = (display = item.getItemStack().clone()).getItemMeta()) == null) continue;
            ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
            lore.add("");
            lore.add("\u00a77\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
            lore.add("\u00a7ePrice: \u00a76" + this.plugin.getEconomyManager().formatMoney(item.getPrice()));
            lore.add("\u00a7eExpires in: \u00a77" + ItemUtils.formatTimeRemaining(item.getExpiryTime()));
            lore.add("");
            lore.add("\u00a7cClick to cancel listing");
            meta.setLore(lore);
            display.setItemMeta(meta);
            int slot = i + 10 + i / 7 * 2;
            this.setItem(slot, display, e -> {
                this.playClickSound();
                new ConfirmCancelGUI(this.player, this.plugin, item).open();
            });
        }
        List<MarketItem> expiredListings = this.plugin.getAuctionManager().getExpiredListings(this.player.getUniqueId());
        if (!expiredListings.isEmpty()) {
            ItemStack expiredButton = this.createItem(Material.CLOCK, "\u00a7cExpired Listings", "\u00a77You have \u00a7e" + expiredListings.size() + " \u00a77expired listings", "\u00a77Click to claim them back");
            this.setItem(39, expiredButton, e -> {
                this.playClickSound();
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (MarketItem expired : expiredListings) {
                    items.add(expired.getItemStack());
                    this.plugin.getAuctionManager().removeListingAdmin(UUID.fromString(expired.getId()));
                }
                this.plugin.getCollectionManager().addItems(this.player.getUniqueId(), items, CollectableItem.CollectionType.EXPIRED_LISTING, 0.0);
                this.refresh();
            });
        }
        ItemStack backButton = this.createItem(Material.ARROW, "\u00a7aBack to Auction House", new String[0]);
        this.setItem(40, backButton, e -> {
            this.playClickSound();
            new AuctionHouseGUI(this.player, this.plugin).open();
        });
    }
}

