/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.MyShopsGUI;
import MPP.marketPlacePlus.gui.RateShopGUI;
import MPP.marketPlacePlus.gui.ReportItemGUI;
import MPP.marketPlacePlus.gui.RestockItemGUI;
import MPP.marketPlacePlus.gui.SetPriceGUI;
import MPP.marketPlacePlus.gui.ShopBrowserGUI;
import MPP.marketPlacePlus.gui.ShopSettingsGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.utils.AntiScamUtils;
import MPP.marketPlacePlus.utils.ItemUtils;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class PlayerShopGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final PlayerShop shop;
    private final boolean isOwner;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm");

    public PlayerShopGUI(Player player, MarketPlacePlus plugin, PlayerShop shop) {
        super(player, "\u00a76" + shop.getShopName() + " \u00a77- " + (shop.isActive() ? "\u00a7aOpen" : "\u00a7cClosed"), 6);
        this.plugin = plugin;
        this.shop = shop;
        this.isOwner = player.getUniqueId().equals(shop.getOwnerId());
    }

    @Override
    public void setupGUI() {
        Material borderMaterial = this.isOwner ? Material.CYAN_STAINED_GLASS_PANE : Material.LIGHT_BLUE_STAINED_GLASS_PANE;
        this.fillBorder(borderMaterial);
        this.addHeader();
        this.displayShopItems();
        this.addBottomControls();
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        if (this.isOwner && event.getClickedInventory() == this.player.getInventory()) {
            ItemStack clicked = event.getCurrentItem();
            if (clicked != null && clicked.getType() != Material.AIR) {
                event.setCancelled(true);
                if (!this.player.hasPermission("marketplaceplus.shop.manage")) {
                    this.playErrorSound();
                    this.player.sendMessage("\u00a7cYou don't have permission to manage shops!");
                    return;
                }
                int emptySlot = this.findEmptyShopSlot();
                if (emptySlot != -1) {
                    this.playClickSound();
                    ItemStack itemToAdd = clicked.clone();
                    this.player.getInventory().setItem(event.getSlot(), null);
                    new SetPriceGUI(this.player, this.plugin, this.shop, emptySlot, itemToAdd).open();
                } else {
                    this.playErrorSound();
                    this.player.sendMessage("\u00a7cYour shop is full! Remove items first.");
                }
            }
        } else {
            super.handleClick(event);
        }
    }

    private int findEmptyShopSlot() {
        for (int i = 0; i < 27; ++i) {
            if (this.shop.getItems().get(i) != null) continue;
            return i;
        }
        return -1;
    }

    private void addHeader() {
        ItemStack ownerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)ownerHead.getItemMeta();
        if (meta != null) {
            OfflinePlayer owner = this.plugin.getServer().getOfflinePlayer(this.shop.getOwnerName());
            meta.setOwningPlayer(owner);
            meta.setDisplayName("\u00a7e" + this.shop.getOwnerName() + "'s Shop");
            ArrayList<Object> lore = new ArrayList<Object>();
            if (!this.shop.getDescription().isEmpty()) {
                String[] descLines;
                lore.add("\u00a77Description:");
                for (String line : descLines = this.shop.getDescription().split("(?<=\\G.{30})")) {
                    lore.add("\u00a7f" + line.trim());
                }
                lore.add("");
            }
            lore.add("\u00a77Status: " + (this.shop.isActive() ? "\u00a7aOpen for Business" : "\u00a7cClosed"));
            lore.add("\u00a77Created: \u00a7f" + this.shop.getCreatedTime().format(DATE_FORMAT));
            lore.add("\u00a77Items Listed: \u00a7e" + this.shop.getItems().size() + "/27");
            lore.add("\u00a77Total Sales: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.shop.getTotalEarnings()));
            lore.add("\u00a77Visits: \u00a7f" + this.shop.getVisitCount());
            meta.setLore(lore);
            ownerHead.setItemMeta((ItemMeta)meta);
        }
        this.setItem(4, ownerHead, null);
        if (!this.isOwner && this.shop.isActive()) {
            ItemStack instructions = this.createItem(Material.BOOK, "\u00a76How to Buy", "\u00a7eLeft Click: \u00a77Buy 1 item", "\u00a7eRight Click: \u00a77Buy a stack", "\u00a7eShift + Left Click: \u00a77Buy 16", "\u00a7eShift + Right Click: \u00a77Buy all");
            this.setItem(8, instructions, null);
        }
    }

    private void displayShopItems() {
        for (int slot = 0; slot < 27; ++slot) {
            int finalSlot;
            int guiSlot = slot + 18;
            PlayerShop.ShopItem shopItem = this.shop.getItems().get(slot);
            if (shopItem != null) {
                ItemStack displayItem = this.createShopItemDisplay(shopItem);
                finalSlot = slot;
                this.setItem(guiSlot, displayItem, e -> this.handleItemClick(finalSlot, shopItem, e.getClick()));
                continue;
            }
            if (!this.isOwner) continue;
            ItemStack emptySlot = this.createEmptySlotItem(slot);
            finalSlot = slot;
            this.setItem(guiSlot, emptySlot, e -> this.handleEmptySlotClick(finalSlot, (InventoryClickEvent)e));
        }
    }

    private ItemStack createShopItemDisplay(PlayerShop.ShopItem shopItem) {
        ItemStack displayItem = shopItem.getItem().clone();
        ItemMeta meta = displayItem.getItemMeta();
        if (meta != null) {
            ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
            lore.add("");
            lore.add("\u00a78\u00a7m--------------------");
            lore.add("\u00a76Price: \u00a7e" + this.plugin.getEconomyManager().formatMoney(shopItem.getPrice()));
            lore.add("\u00a76Stock: \u00a7e" + shopItem.getStock());
            lore.add("\u00a76Per Stack: \u00a7e" + this.plugin.getEconomyManager().formatMoney(shopItem.getPrice() * (double)displayItem.getMaxStackSize()));
            String itemKey = ItemUtils.getItemKey(displayItem);
            double avgPrice = this.plugin.getPriceManager().getAveragePrice(itemKey);
            if (avgPrice > 0.0) {
                double priceDiff = (shopItem.getPrice() - avgPrice) / avgPrice * 100.0;
                String priceIndicator = priceDiff > 0.0 ? "\u00a7c+" + String.format("%.1f", priceDiff) + "%" : (priceDiff < 0.0 ? "\u00a7a" + String.format("%.1f", priceDiff) + "%" : "\u00a7e\u00b10%");
                lore.add("\u00a77Market Avg: \u00a7f" + this.plugin.getEconomyManager().formatMoney(avgPrice) + " " + priceIndicator);
            }
            lore.add("");
            if (this.isOwner) {
                lore.add("\u00a7e\u25b8 Left Click: \u00a77Restock");
                lore.add("\u00a7e\u25b8 Right Click: \u00a77Change price");
                lore.add("\u00a7e\u25b8 Middle Click: \u00a77View statistics");
                lore.add("\u00a7c\u25b8 Shift + Right Click: \u00a77Remove");
            } else if (this.shop.isActive()) {
                lore.add("\u00a7a\u25b8 Left Click: \u00a77Buy 1");
                lore.add("\u00a7a\u25b8 Right Click: \u00a77Buy stack (" + displayItem.getMaxStackSize() + ")");
                lore.add("\u00a7a\u25b8 Shift + Left Click: \u00a77Buy 16");
                lore.add("\u00a7a\u25b8 Shift + Right Click: \u00a77Buy all");
                lore.add("\u00a7c\u25b8 Middle Click: \u00a77Report");
            } else {
                lore.add("\u00a7cShop is closed!");
            }
            meta.setLore(lore);
            displayItem.setItemMeta(meta);
        }
        return displayItem;
    }

    private ItemStack createEmptySlotItem(int slot) {
        return this.createItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "\u00a77Empty Slot #" + (slot + 1), "\u00a77Drag an item here or", "\u00a77click with an item to add it", "", "\u00a7eStock items from your inventory");
    }

    private void handleItemClick(int slot, PlayerShop.ShopItem shopItem, ClickType clickType) {
        if (this.isOwner) {
            switch (clickType) {
                case LEFT: {
                    this.playClickSound();
                    new RestockItemGUI(this.player, this.plugin, this.shop, slot).open();
                    break;
                }
                case RIGHT: {
                    this.playClickSound();
                    new SetPriceGUI(this.player, this.plugin, this.shop, slot).open();
                    break;
                }
                case MIDDLE: {
                    this.playClickSound();
                    this.player.sendMessage("\u00a7eItem statistics coming soon!");
                    break;
                }
                case SHIFT_RIGHT: {
                    this.playClickSound();
                    ItemStack returned = shopItem.getItem().clone();
                    returned.setAmount(shopItem.getStock());
                    if (ItemUtils.hasInventorySpace(this.player, returned, shopItem.getStock())) {
                        AntiScamUtils.clearItemUUID(returned, (Plugin)this.plugin);
                        this.player.getInventory().addItem(new ItemStack[]{returned});
                        this.shop.removeItem(slot);
                        this.plugin.getDatabaseManager().updateShop(this.shop);
                        this.plugin.getShopManager().saveShop(this.shop);
                        this.player.sendMessage("\u00a7aItem removed and returned to inventory.");
                        this.refresh();
                        break;
                    }
                    this.player.sendMessage("\u00a7cNot enough inventory space!");
                }
            }
        } else if (this.shop.isActive()) {
            int amount = 1;
            if (clickType == ClickType.RIGHT) {
                amount = Math.min(shopItem.getItem().getMaxStackSize(), shopItem.getStock());
            } else if (clickType == ClickType.SHIFT_LEFT) {
                amount = Math.min(16, shopItem.getStock());
            } else if (clickType == ClickType.SHIFT_RIGHT) {
                amount = shopItem.getStock();
            } else if (clickType == ClickType.MIDDLE) {
                this.playClickSound();
                new ReportItemGUI(this.player, this.plugin, this.shop).open();
                return;
            }
            this.handlePurchase(slot, shopItem, amount);
        } else {
            this.playErrorSound();
            this.player.sendMessage("\u00a7cThis shop is currently closed!");
        }
    }

    private void handleEmptySlotClick(int slot, InventoryClickEvent event) {
        ItemStack cursor = event.getCursor();
        if (cursor != null && cursor.getType() != Material.AIR) {
            event.setCancelled(true);
            this.playClickSound();
            ItemStack itemToAdd = cursor.clone();
            event.setCursor(null);
            new SetPriceGUI(this.player, this.plugin, this.shop, slot, itemToAdd).open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePurchase(int slot, PlayerShop.ShopItem shopItem, int amount) {
        if (!this.player.hasPermission("marketplaceplus.shop.buy")) {
            this.playErrorSound();
            this.player.sendMessage("\u00a7cYou don't have permission to buy from shops!");
            return;
        }
        if (this.player.getUniqueId().equals(this.shop.getOwnerId())) {
            this.playErrorSound();
            this.player.sendMessage("\u00a7cYou cannot buy from your own shop!");
            return;
        }
        double totalCost = shopItem.getPrice() * (double)amount;
        if (!this.plugin.getEconomyManager().hasBalance(this.player, totalCost)) {
            this.playErrorSound();
            this.player.sendMessage("\u00a7cInsufficient funds! You need " + this.plugin.getEconomyManager().formatMoney(totalCost));
            return;
        }
        ItemStack purchaseItem = shopItem.getItem().clone();
        purchaseItem.setAmount(amount);
        if (!ItemUtils.hasInventorySpace(this.player, purchaseItem, amount)) {
            this.playErrorSound();
            this.player.sendMessage("\u00a7cNot enough inventory space!");
            return;
        }
        PlayerShop playerShop = this.shop;
        synchronized (playerShop) {
            if (!this.shop.purchaseItem(slot, amount)) {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cNot enough stock! Item may have been purchased by another player.");
                return;
            }
            if (!this.plugin.getEconomyManager().withdrawPlayer(this.player, totalCost)) {
                this.shop.restockItem(slot, amount);
                this.playErrorSound();
                this.player.sendMessage("\u00a7cTransaction failed! Please try again.");
                return;
            }
            this.plugin.getDatabaseManager().updateShop(this.shop);
            OfflinePlayer shopOwner = this.plugin.getServer().getOfflinePlayer(this.shop.getOwnerId());
            double taxRate = shopOwner.isOnline() && shopOwner.getPlayer().hasPermission("marketplaceplus.admin.bypass.tax") ? 0.0 : this.plugin.getConfig().getDouble("player-shops.shop-tax-percentage", 5.0) / 100.0;
            double ownerAmount = totalCost * (1.0 - taxRate);
            this.plugin.getEconomyManager().depositPlayer(this.shop.getOwnerId(), ownerAmount);
            AntiScamUtils.clearItemUUID(purchaseItem, (Plugin)this.plugin);
            this.player.getInventory().addItem(new ItemStack[]{purchaseItem});
            this.plugin.getPriceManager().recordPrice(purchaseItem, shopItem.getPrice(), amount);
            this.plugin.getTradeHistoryManager().recordShopPurchase(this.shop, this.player, purchaseItem, totalCost);
            if (this.plugin.getDiscordWebhookManager() != null) {
                this.plugin.getDiscordWebhookManager().sendShopSaleNotification(this.shop, this.player, purchaseItem, totalCost, amount);
            }
            this.playSuccessSound();
            this.player.sendMessage("\u00a7aSuccess! \u00a77Purchased \u00a7e" + amount + "x " + ItemUtils.getItemName(purchaseItem) + " \u00a77for \u00a76" + this.plugin.getEconomyManager().formatMoney(totalCost));
            OfflinePlayer owner = this.plugin.getServer().getOfflinePlayer(this.shop.getOwnerId());
            if (owner.isOnline()) {
                owner.getPlayer().sendMessage("\u00a7a[Shop] \u00a7e" + this.player.getName() + " \u00a77purchased \u00a7e" + amount + "x " + ItemUtils.getItemName(purchaseItem) + " \u00a77for \u00a76" + this.plugin.getEconomyManager().formatMoney(ownerAmount));
            }
            this.refresh();
        }
    }

    private void addBottomControls() {
        if (this.isOwner) {
            ItemStack settingsButton = this.createItem(Material.COMPARATOR, "\u00a76Shop Settings", "\u00a77Configure shop name, description,", "\u00a77and other settings");
            this.setItem(48, settingsButton, e -> {
                this.playClickSound();
                new ShopSettingsGUI(this.player, this.plugin, this.shop).open();
            });
            ItemStack quickStock = this.createItem(Material.HOPPER, "\u00a7aQuick Stock", "\u00a77Add all matching items", "\u00a77from your inventory");
            this.setItem(49, quickStock, e -> {
                this.playClickSound();
                this.player.sendMessage("\u00a7eQuick stock coming soon!");
            });
            ItemStack statsButton = this.createItem(Material.BOOK, "\u00a7eShop Statistics", "\u00a77View detailed shop analytics");
            this.setItem(50, statsButton, e -> {
                this.playClickSound();
                this.player.sendMessage("\u00a7eShop statistics coming soon!");
            });
            ItemStack backButton = this.createItem(Material.ARROW, "\u00a7cBack", "\u00a77Return to my shops");
            this.setItem(53, backButton, e -> {
                this.playClickSound();
                new MyShopsGUI(this.player, this.plugin).open();
            });
        } else {
            ItemStack backButton = this.createItem(Material.ARROW, "\u00a7cBack", "\u00a77Return to shop browser");
            this.setItem(49, backButton, e -> {
                this.playClickSound();
                new ShopBrowserGUI(this.player, this.plugin).open();
            });
            if (this.shop.isActive()) {
                ItemStack rateButton = this.createItem(Material.NETHER_STAR, "\u00a76Rate Shop", "\u00a77Current Rating: \u00a76" + String.format("%.1f", this.shop.getAverageRating()) + " \u2605", "\u00a77Total Ratings: \u00a7b" + this.shop.getTotalRatings(), "", "\u00a7eClick to rate this shop");
                this.setItem(50, rateButton, e -> {
                    this.playClickSound();
                    new RateShopGUI(this.player, this.plugin, this.shop).open();
                });
                ItemStack searchSimilar = this.createItem(Material.COMPASS, "\u00a76Find Similar Shops", "\u00a77Search for shops with", "\u00a77similar items");
                this.setItem(51, searchSimilar, e -> {
                    this.playClickSound();
                    this.player.sendMessage("\u00a7eSimilar shops search coming soon!");
                });
            }
        }
    }
}

