/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.AuctionHouseGUI;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class SearchGUI {
    private final Player player;
    private final MarketPlacePlus plugin;
    private final Consumer<String> onSearch;

    public SearchGUI(Player player, MarketPlacePlus plugin, Consumer<String> onSearch) {
        this.player = player;
        this.plugin = plugin;
        this.onSearch = onSearch;
    }

    public void open() {
        this.player.closeInventory();
        this.player.sendMessage("\u00a76\u00a7l[MarketPlace] \u00a7aPlease type your search query in chat:");
        this.player.sendMessage("\u00a77Type \u00a7c'cancel' \u00a77to cancel the search.");
        this.player.sendMessage("\u00a77Search tips: Use item names, materials, or categories.");
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.player.isOnline()) {
                new ChatInputHandler(this.plugin, this.player, input -> {
                    if (!input.equalsIgnoreCase("cancel")) {
                        if (input.length() < 2) {
                            this.player.sendMessage("\u00a7cSearch query must be at least 2 characters long!");
                            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> new AuctionHouseGUI(this.player, this.plugin).open());
                        } else {
                            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                                AuctionHouseGUI gui = new AuctionHouseGUI(this.player, this.plugin);
                                gui.setSearchAndOpen((String)input);
                            });
                        }
                    } else {
                        this.player.sendMessage("\u00a7cSearch cancelled.");
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> new AuctionHouseGUI(this.player, this.plugin).open());
                    }
                }).register();
            }
        }, 5L);
    }

    private static class ChatInputHandler
    implements Listener {
        private final MarketPlacePlus plugin;
        private final Player player;
        private final Consumer<String> callback;

        public ChatInputHandler(MarketPlacePlus plugin, Player player, Consumer<String> callback) {
            this.plugin = plugin;
            this.player = player;
            this.callback = callback;
        }

        public void register() {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onChat(AsyncPlayerChatEvent event) {
            if (!event.getPlayer().equals((Object)this.player)) {
                return;
            }
            event.setCancelled(true);
            String message = event.getMessage();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                this.callback.accept(message);
                AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this);
            });
        }
    }
}

