/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.MyShopsGUI;
import MPP.marketPlacePlus.gui.PlayerShopGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ShopBrowserGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private List<PlayerShop> shops;
    private int currentPage = 0;
    private String searchQuery = "";
    private SortType sortType = SortType.NEWEST;
    private static final int SHOPS_PER_PAGE = 28;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MM/dd/yyyy");

    public ShopBrowserGUI(Player player, MarketPlacePlus plugin) {
        super(player, "\u00a76Shop Browser", 6);
        this.plugin = plugin;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.BROWN_STAINED_GLASS_PANE);
        this.loadShops();
        this.displayShops();
        this.setupControls();
    }

    private void loadShops() {
        this.shops = this.searchQuery.isEmpty() ? this.plugin.getShopManager().getAllActiveShops() : this.plugin.getShopManager().searchShops(this.searchQuery);
        this.sortShops();
    }

    private void sortShops() {
        switch (this.sortType.ordinal()) {
            case 0: {
                this.shops.sort((a, b) -> b.getCreatedTime().compareTo(a.getCreatedTime()));
                break;
            }
            case 1: {
                this.shops.sort((a, b) -> a.getCreatedTime().compareTo(b.getCreatedTime()));
                break;
            }
            case 2: {
                this.shops.sort((a, b) -> Integer.compare(b.getVisitCount(), a.getVisitCount()));
                break;
            }
            case 3: {
                this.shops.sort((a, b) -> a.getShopName().compareTo(b.getShopName()));
            }
        }
    }

    private void displayShops() {
        for (int i = 10; i <= 43; ++i) {
            if (i % 9 == 0 || i % 9 == 8) continue;
            this.inventory.setItem(i, null);
        }
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, this.shops.size());
        int slot = 10;
        for (int i = startIndex; i < endIndex; ++i) {
            if (slot % 9 == 0 || slot % 9 == 8) {
                ++slot;
            }
            if (slot > 43) break;
            PlayerShop shop = this.shops.get(i);
            ItemStack shopItem = this.createShopItem(shop);
            this.setItem(slot, shopItem, e -> {
                this.playClickSound();
                this.plugin.getShopManager().incrementVisitCount(shop.getId());
                new PlayerShopGUI(this.player, this.plugin, shop).open();
            });
            ++slot;
        }
    }

    private ItemStack createShopItem(PlayerShop shop) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            OfflinePlayer owner = this.plugin.getServer().getOfflinePlayer(shop.getOwnerName());
            meta.setOwningPlayer(owner);
            meta.setDisplayName("\u00a7e" + shop.getShopName());
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77Owner: \u00a7f" + shop.getOwnerName());
            lore.add("");
            if (!shop.getDescription().isEmpty()) {
                String[] descLines;
                lore.add("\u00a77Description:");
                for (String line : descLines = shop.getDescription().split("(?<=\\G.{30})")) {
                    lore.add("\u00a7f" + line.trim());
                }
                lore.add("");
            }
            lore.add("\u00a77Items: \u00a7e" + shop.getItems().size());
            lore.add("\u00a77Created: \u00a7f" + shop.getCreatedTime().format(DATE_FORMAT));
            lore.add("\u00a77Visits: \u00a7f" + shop.getVisitCount());
            if (shop.getTotalRatings() > 0) {
                double rating = shop.getAverageRating();
                String stars = this.getStarDisplay(rating);
                lore.add("\u00a77Rating: " + stars + " \u00a7f(" + String.format("%.1f", rating) + "/5.0)");
                lore.add("\u00a77Reviews: \u00a7f" + shop.getTotalRatings());
            } else {
                lore.add("\u00a77Rating: \u00a78No ratings yet");
            }
            lore.add("\u00a77Total Sales: \u00a76" + this.plugin.getEconomyManager().formatMoney(shop.getTotalEarnings()));
            lore.add("");
            lore.add("\u00a7aClick to visit shop!");
            meta.setLore(lore);
            skull.setItemMeta((ItemMeta)meta);
        }
        return skull;
    }

    private void setupControls() {
        ItemStack searchItem = this.createItem(Material.COMPASS, "\u00a76Search Shops", "\u00a77Current search: " + (String)(this.searchQuery.isEmpty() ? "\u00a7cNone" : "\u00a7e" + this.searchQuery), "", "\u00a7eClick to search by name/owner");
        this.setItem(45, searchItem, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.player.sendMessage("\u00a7ePlease type your search query in chat:");
            this.plugin.getChatInputManager().waitForInput(this.player, input -> {
                this.searchQuery = input;
                this.currentPage = 0;
                new ShopBrowserGUI(this.player, this.plugin).open();
            });
        });
        ItemStack sortItem = this.createItem(Material.HOPPER, "\u00a76Sort: \u00a7e" + this.sortType.displayName, "\u00a77Click to change sorting");
        this.setItem(46, sortItem, e -> {
            this.playClickSound();
            this.cycleSortType();
            this.refresh();
        });
        if (!this.searchQuery.isEmpty()) {
            ItemStack clearSearch = this.createItem(Material.BARRIER, "\u00a7cClear Search", "\u00a77Click to show all shops");
            this.setItem(47, clearSearch, e -> {
                this.playClickSound();
                this.searchQuery = "";
                this.currentPage = 0;
                this.refresh();
            });
        }
        if (this.currentPage > 0) {
            ItemStack prevPage = this.createItem(Material.ARROW, "\u00a7aPrevious Page", "\u00a77Go to page " + this.currentPage);
            this.setItem(48, prevPage, e -> {
                this.playClickSound();
                --this.currentPage;
                this.refresh();
            });
        }
        ItemStack info = this.createItem(Material.BOOK, "\u00a76Shop Browser", "\u00a77Total shops: \u00a7f" + this.shops.size(), "\u00a77Page: \u00a7f" + (this.currentPage + 1) + "/" + Math.max(1, (this.shops.size() + 28 - 1) / 28));
        this.setItem(49, info, null);
        int totalPages = (this.shops.size() + 28 - 1) / 28;
        if (this.currentPage < totalPages - 1) {
            ItemStack nextPage = this.createItem(Material.ARROW, "\u00a7aNext Page", "\u00a77Go to page " + (this.currentPage + 2));
            this.setItem(50, nextPage, e -> {
                this.playClickSound();
                ++this.currentPage;
                this.refresh();
            });
        }
        ItemStack myShops = this.createItem(Material.CHEST, "\u00a7aMy Shops", "\u00a77View your own shops");
        this.setItem(52, myShops, e -> {
            this.playClickSound();
            new MyShopsGUI(this.player, this.plugin).open();
        });
        ItemStack close = this.createItem(Material.BARRIER, "\u00a7cClose", new String[0]);
        this.setItem(53, close, e -> {
            this.playClickSound();
            this.player.closeInventory();
        });
    }

    private void cycleSortType() {
        SortType[] types = SortType.values();
        int current = this.sortType.ordinal();
        this.sortType = types[(current + 1) % types.length];
    }

    private String getStarDisplay(double rating) {
        int i;
        StringBuilder stars = new StringBuilder();
        int fullStars = (int)rating;
        boolean hasHalfStar = rating - (double)fullStars >= 0.5;
        for (i = 0; i < fullStars; ++i) {
            stars.append("\u00a76\u2605");
        }
        if (hasHalfStar && fullStars < 5) {
            stars.append("\u00a76\u2606");
            ++fullStars;
        }
        for (i = fullStars; i < 5; ++i) {
            stars.append("\u00a77\u2606");
        }
        return stars.toString();
    }

    private static enum SortType {
        NEWEST("Newest First"),
        OLDEST("Oldest First"),
        POPULAR("Most Popular"),
        NAME("Alphabetical");

        private final String displayName;

        private SortType(String displayName) {
            this.displayName = displayName;
        }
    }
}

