/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.PlayerShopGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShopManagementGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;

    public ShopManagementGUI(Player player, MarketPlacePlus plugin) {
        super(player, "\u00a76Manage Your Shops", 4);
        this.plugin = plugin;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.CYAN_STAINED_GLASS_PANE);
        List<PlayerShop> shops = this.plugin.getShopManager().getPlayerShops(this.player.getUniqueId());
        for (int i = 0; i < Math.min(shops.size(), 21); ++i) {
            PlayerShop shop = shops.get(i);
            ItemStack shopItem = this.createItem(shop.isActive() ? Material.LIME_WOOL : Material.RED_WOOL, "\u00a76" + shop.getShopName(), "\u00a77Shop ID: " + shop.getId().substring(0, 8), "\u00a77Earnings: \u00a7a" + this.plugin.getEconomyManager().formatMoney(shop.getTotalEarnings()), "\u00a77Items: \u00a7b" + shop.getItems().size(), "", "\u00a7eClick to manage");
            int slot = i + 10 + i / 7 * 2;
            this.setItem(slot, shopItem, e -> {
                this.playClickSound();
                new PlayerShopGUI(this.player, this.plugin, shop).open();
            });
        }
        ItemStack backButton = this.createItem(Material.ARROW, "\u00a7aBack", new String[0]);
        this.setItem(31, backButton, e -> {
            this.playClickSound();
            this.player.closeInventory();
        });
    }
}

