/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayerManageGUI;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.utils.TimeUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminPlayerListingsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final OfflinePlayer targetPlayer;
    private final int page;
    private final List<MarketItem> playerListings;
    private static final int ITEMS_PER_PAGE = 28;

    public AdminPlayerListingsGUI(MarketPlacePlus plugin, Player player, OfflinePlayer targetPlayer, int page) {
        super(player, "\u00a7c\u00a7l" + targetPlayer.getName() + "'s Listings - Page " + page, 6);
        this.plugin = plugin;
        this.targetPlayer = targetPlayer;
        this.page = page;
        this.playerListings = plugin.getAuctionManager().getPlayerActiveListings(targetPlayer.getUniqueId());
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        ItemStack backButton = this.createItem(Material.BARRIER, "\u00a7cBack to Player", "\u00a77Return to " + this.targetPlayer.getName() + "'s profile");
        this.setItem(45, backButton, e -> new AdminPlayerManageGUI(this.plugin, this.player, this.targetPlayer).open());
        ItemStack infoItem = this.createItem(Material.BOOK, "\u00a7e\u00a7lListing Info", "\u00a77Player: \u00a7f" + this.targetPlayer.getName(), "\u00a77Total Listings: \u00a7e" + this.playerListings.size(), "", "\u00a7cClick listings to manage them");
        this.setItem(49, infoItem, null);
        int startIndex = (this.page - 1) * 28;
        int endIndex = Math.min(startIndex + 28, this.playerListings.size());
        int slot = 10;
        for (int i = startIndex; i < endIndex; ++i) {
            if (slot % 9 == 0 || slot % 9 == 8) {
                ++slot;
            }
            if (slot >= 44) break;
            MarketItem listing = this.playerListings.get(i);
            ItemStack displayItem = listing.getItemStack().clone();
            ItemMeta meta = displayItem.getItemMeta();
            ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
            lore.add("");
            lore.add("\u00a77\u00a7m                              ");
            lore.add("\u00a77Price: \u00a7a$" + String.format("%.2f", listing.getPrice()));
            lore.add("\u00a77Listed: \u00a7e" + TimeUtils.formatTime(System.currentTimeMillis() - listing.getListedTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
            if (listing.isAuction()) {
                lore.add("\u00a77Type: \u00a7dAuction");
                lore.add("\u00a77Current Bid: \u00a7a$" + String.format("%.2f", listing.getCurrentBid()));
                lore.add("\u00a77Bidders: \u00a7e" + listing.getBidders().size());
            } else {
                lore.add("\u00a77Type: \u00a76Buy Now");
            }
            lore.add("");
            lore.add("\u00a7c\u00a7lAdmin Actions:");
            lore.add("\u00a7e\u00a7lLeft Click \u00a77to delete");
            lore.add("\u00a7e\u00a7lRight Click \u00a77to adjust price");
            lore.add("\u00a7e\u00a7lShift-Click \u00a77to force expire");
            meta.setLore(lore);
            displayItem.setItemMeta(meta);
            this.setItem(slot, displayItem, e -> {
                if (e.isLeftClick()) {
                    if (this.plugin.getAdminManager().deleteMarketListing(listing.getIdAsUUID(), this.player)) {
                        this.player.sendMessage("\u00a7aSuccessfully deleted listing!");
                        this.playSuccessSound();
                        this.refresh();
                    } else {
                        this.player.sendMessage("\u00a7cFailed to delete listing!");
                        this.playErrorSound();
                    }
                } else if (e.isRightClick()) {
                    this.player.closeInventory();
                    this.player.sendMessage("\u00a7eEnter new price for this listing:");
                    MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                        try {
                            double newPrice = Double.parseDouble(input);
                            if (newPrice <= 0.0) {
                                this.player.sendMessage("\u00a7cPrice must be greater than 0!");
                                new AdminPlayerListingsGUI(this.plugin, this.player, this.targetPlayer, this.page).open();
                                return;
                            }
                            if (this.plugin.getAdminManager().adjustListingPrice(listing.getIdAsUUID(), newPrice, this.player)) {
                                this.player.sendMessage("\u00a7aPrice adjusted successfully!");
                                new AdminPlayerListingsGUI(this.plugin, this.player, this.targetPlayer, this.page).open();
                            } else {
                                this.player.sendMessage("\u00a7cFailed to adjust price!");
                                new AdminPlayerListingsGUI(this.plugin, this.player, this.targetPlayer, this.page).open();
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.player.sendMessage("\u00a7cInvalid price format!");
                            new AdminPlayerListingsGUI(this.plugin, this.player, this.targetPlayer, this.page).open();
                        }
                    });
                } else if (e.isShiftClick()) {
                    if (this.plugin.getAdminManager().forceExpireListing(listing.getIdAsUUID(), this.player)) {
                        this.player.sendMessage("\u00a7aSuccessfully expired listing!");
                        this.playSuccessSound();
                        this.refresh();
                    } else {
                        this.player.sendMessage("\u00a7cFailed to expire listing!");
                        this.playErrorSound();
                    }
                }
            });
            ++slot;
        }
        int maxPages = (this.playerListings.size() - 1) / 28;
        this.addNavigationButtons(this.page - 1, maxPages, () -> new AdminPlayerListingsGUI(this.plugin, this.player, this.targetPlayer, this.page - 1).open(), () -> new AdminPlayerListingsGUI(this.plugin, this.player, this.targetPlayer, this.page + 1).open());
    }
}

