/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayerListingsGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayerShopsGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayersGUI;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.models.TradeHistory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class AdminPlayerManageGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final OfflinePlayer targetPlayer;

    public AdminPlayerManageGUI(MarketPlacePlus plugin, Player player, OfflinePlayer targetPlayer) {
        super(player, "\u00a7c\u00a7lManaging: " + targetPlayer.getName(), 5);
        this.plugin = plugin;
        this.targetPlayer = targetPlayer;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        ItemStack backButton = this.createItem(Material.BARRIER, "\u00a7cBack to Players", "\u00a77Click to return");
        this.setItem(36, backButton, e -> new AdminPlayersGUI(this.plugin, this.player, 1).open());
        Map<String, Object> stats = this.plugin.getAdminManager().getPlayerStatistics(this.targetPlayer.getUniqueId());
        boolean isBanned = (Boolean)stats.get("isBanned");
        ItemStack playerInfo = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)playerInfo.getItemMeta();
        meta.setOwningPlayer(this.targetPlayer);
        meta.setDisplayName("\u00a7e" + this.targetPlayer.getName());
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77UUID: \u00a7f" + String.valueOf(this.targetPlayer.getUniqueId()));
        lore.add("");
        lore.add("\u00a77Status: " + (isBanned ? "\u00a7cBanned" : "\u00a7aActive"));
        if (isBanned) {
            lore.add("\u00a77Reason: \u00a7c" + this.plugin.getAdminManager().getBanReason(this.targetPlayer.getUniqueId()));
        }
        lore.add("");
        lore.add("\u00a77Total Listings: \u00a7e" + String.valueOf(stats.get("totalListings")));
        lore.add("\u00a77Active Listings: \u00a7e" + String.valueOf(stats.get("activeListings")));
        lore.add("\u00a77Total Shops: \u00a7e" + String.valueOf(stats.get("totalShops")));
        lore.add("\u00a77Total Earnings: \u00a7a$" + String.format("%.2f", stats.get("totalEarnings")));
        lore.add("\u00a77Total Spent: \u00a7c$" + String.format("%.2f", stats.get("totalSpent")));
        meta.setLore(lore);
        playerInfo.setItemMeta((ItemMeta)meta);
        this.setItem(4, playerInfo, null);
        if (isBanned) {
            ItemStack unbanItem = this.createItem(Material.EMERALD_BLOCK, "\u00a7a\u00a7lUnban Player", "\u00a77Remove market ban for", "\u00a77" + this.targetPlayer.getName(), "", "\u00a7aClick to unban");
            this.setItem(20, unbanItem, e -> {
                if (this.plugin.getAdminManager().unbanPlayerFromMarket(this.targetPlayer.getUniqueId(), this.player)) {
                    this.player.sendMessage("\u00a7aSuccessfully unbanned " + this.targetPlayer.getName());
                    this.playSuccessSound();
                    this.refresh();
                } else {
                    this.player.sendMessage("\u00a7cFailed to unban player!");
                    this.playErrorSound();
                }
            });
        } else {
            ItemStack banItem = this.createItem(Material.REDSTONE_BLOCK, "\u00a7c\u00a7lBan Player", "\u00a77Ban from marketplace", "", "\u00a7cClick to ban");
            this.setItem(20, banItem, e -> {
                this.player.closeInventory();
                this.player.sendMessage("\u00a7ePlease type the ban reason:");
                MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, reason -> {
                    if (this.plugin.getAdminManager().banPlayerFromMarket(this.targetPlayer.getUniqueId(), this.player, (String)reason)) {
                        this.player.sendMessage("\u00a7aBanned " + this.targetPlayer.getName() + " successfully!");
                        new AdminPlayerManageGUI(this.plugin, this.player, this.targetPlayer).open();
                    } else {
                        this.player.sendMessage("\u00a7cFailed to ban player!");
                        new AdminPlayerManageGUI(this.plugin, this.player, this.targetPlayer).open();
                    }
                });
            });
        }
        ItemStack viewListingsItem = this.createItem(Material.GOLD_INGOT, "\u00a7e\u00a7lView Listings", "\u00a77View all listings by", "\u00a77" + this.targetPlayer.getName(), "", "\u00a77Active: \u00a7e" + String.valueOf(stats.get("activeListings")), "", "\u00a7eClick to view");
        this.setItem(22, viewListingsItem, e -> {
            List<MarketItem> playerListings = this.plugin.getAuctionManager().getPlayerActiveListings(this.targetPlayer.getUniqueId());
            if (playerListings.isEmpty()) {
                this.player.sendMessage("\u00a7cThis player has no active listings!");
                this.playErrorSound();
            } else {
                new AdminPlayerListingsGUI(this.plugin, this.player, this.targetPlayer, 1).open();
            }
        });
        ItemStack viewShopsItem = this.createItem(Material.CHEST, "\u00a7e\u00a7lView Shops", "\u00a77View all shops owned by", "\u00a77" + this.targetPlayer.getName(), "", "\u00a77Total shops: \u00a7e" + String.valueOf(stats.get("totalShops")), "", "\u00a7eClick to view");
        this.setItem(24, viewShopsItem, e -> {
            List<PlayerShop> playerShops = this.plugin.getShopManager().getPlayerShops(this.targetPlayer.getUniqueId());
            if (playerShops.isEmpty()) {
                this.player.sendMessage("\u00a7cThis player has no shops!");
                this.playErrorSound();
            } else {
                new AdminPlayerShopsGUI(this.plugin, this.player, this.targetPlayer).open();
            }
        });
        ItemStack clearDataItem = this.createItem(Material.TNT, "\u00a7c\u00a7lClear All Data", "\u00a77Remove all market data", "\u00a77for " + this.targetPlayer.getName(), "", "\u00a7c\u00a7lWARNING: \u00a77This action", "\u00a77cannot be undone!", "", "\u00a7cClick to clear");
        this.setItem(30, clearDataItem, e -> {
            this.player.closeInventory();
            this.player.sendMessage("\u00a7c\u00a7lWARNING: \u00a77This will delete all market data for " + this.targetPlayer.getName());
            this.player.sendMessage("\u00a77Type \u00a7cCONFIRM \u00a77to proceed or anything else to cancel:");
            MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                if (input.equalsIgnoreCase("CONFIRM")) {
                    if (this.plugin.getAdminManager().clearPlayerData(this.targetPlayer.getUniqueId(), this.player)) {
                        this.player.sendMessage("\u00a7aSuccessfully cleared all data for " + this.targetPlayer.getName());
                        new AdminPlayerManageGUI(this.plugin, this.player, this.targetPlayer).open();
                    } else {
                        this.player.sendMessage("\u00a7cFailed to clear player data!");
                        new AdminPlayerManageGUI(this.plugin, this.player, this.targetPlayer).open();
                    }
                } else {
                    this.player.sendMessage("\u00a7aCancelled data clearing.");
                    new AdminPlayerManageGUI(this.plugin, this.player, this.targetPlayer).open();
                }
            });
        });
        ItemStack tradeHistoryItem = this.createItem(Material.BOOK, "\u00a7b\u00a7lTrade History", "\u00a77View transaction history", "\u00a77for " + this.targetPlayer.getName(), "", "\u00a77Total earned: \u00a7a$" + String.format("%.2f", stats.get("totalEarnings")), "\u00a77Total spent: \u00a7c$" + String.format("%.2f", stats.get("totalSpent")), "", "\u00a7eClick to view");
        this.setItem(32, tradeHistoryItem, e -> {
            this.player.sendMessage("\u00a76\u00a7lRecent Transactions for " + this.targetPlayer.getName() + ":");
            List<TradeHistory> history = this.plugin.getTradeHistoryManager().getPlayerHistory(this.targetPlayer.getUniqueId());
            if (history.isEmpty()) {
                this.player.sendMessage("\u00a77No transaction history found.");
            } else {
                history.stream().limit(10L).forEach(transaction -> this.player.sendMessage("\u00a77" + transaction.getFormattedMessage()));
            }
        });
    }
}

