/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayerManageGUI;
import MPP.marketPlacePlus.gui.admin.AdminReportsGUI;
import MPP.marketPlacePlus.gui.admin.AdminShopDetailsGUI;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.models.Report;
import MPP.marketPlacePlus.utils.TimeUtils;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class AdminReportDetailsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final Report report;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm");

    public AdminReportDetailsGUI(MarketPlacePlus plugin, Player player, Report report) {
        super(player, "\u00a7c\u00a7lReport Details - #" + report.getId().substring(0, 8), 5);
        this.plugin = plugin;
        this.report = report;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        this.displayReportInfo();
        this.displayReportedContent();
        this.displayActions();
    }

    private void displayReportInfo() {
        ItemStack reportInfo = this.createItem(Material.BOOK, "\u00a76\u00a7lReport Information", "\u00a77Report ID: \u00a7e#" + this.report.getId().substring(0, 8), "\u00a77Type: \u00a7e" + this.report.getReportType().name(), "\u00a77Status: \u00a7e" + this.report.getStatus().name(), "\u00a77Submitted: \u00a7f" + this.report.getReportTime().format(DATE_FORMAT), "\u00a77Time Ago: \u00a7f" + TimeUtils.formatTimeAgo(this.report.getReportTime()), "", "\u00a77Reason: \u00a7c" + this.report.getReason());
        if (this.report.getDetails() != null && !this.report.getDetails().isEmpty()) {
            ItemMeta meta = reportInfo.getItemMeta();
            List lore = meta.getLore();
            lore.add("\u00a77Details: \u00a7f" + this.report.getDetails());
            meta.setLore(lore);
            reportInfo.setItemMeta(meta);
        }
        this.setItem(4, reportInfo, null);
        ItemStack reporterHead = this.createPlayerHead(this.report.getReporterName(), "\u00a7e\u00a7lReporter", "\u00a77Name: \u00a7f" + this.report.getReporterName(), "\u00a77UUID: \u00a78" + this.report.getReporterId().substring(0, 8) + "...", "", "\u00a7eClick to view player");
        this.setItem(11, reporterHead, e -> {
            this.playClickSound();
            new AdminPlayerManageGUI(this.plugin, this.player, this.plugin.getServer().getOfflinePlayer(UUID.fromString(this.report.getReporterId()))).open();
        });
        ItemStack reportedHead = this.createPlayerHead(this.report.getReportedName(), "\u00a7c\u00a7lReported Player", "\u00a77Name: \u00a7f" + this.report.getReportedName(), "\u00a77UUID: \u00a78" + this.report.getReportedId().substring(0, 8) + "...", "", "\u00a77Previous Reports: \u00a7e" + this.plugin.getReportManager().getReportsByPlayer(this.report.getReportedId()).size(), "", "\u00a7eClick to view player");
        this.setItem(15, reportedHead, e -> {
            this.playClickSound();
            new AdminPlayerManageGUI(this.plugin, this.player, this.plugin.getServer().getOfflinePlayer(UUID.fromString(this.report.getReportedId()))).open();
        });
    }

    private void displayReportedContent() {
        ItemStack contentItem = null;
        switch (this.report.getReportType()) {
            case AUCTION: {
                MarketItem marketItem = this.plugin.getAuctionManager().getListingById(UUID.fromString(this.report.getTargetId()));
                if (marketItem != null) {
                    contentItem = marketItem.getItemStack().clone();
                    ItemMeta meta = contentItem.getItemMeta();
                    ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
                    lore.add("");
                    lore.add("\u00a7c\u00a7lReported Listing");
                    lore.add("\u00a77Seller: \u00a7e" + marketItem.getSellerName());
                    lore.add("\u00a77Price: \u00a76" + this.plugin.getEconomyManager().formatMoney(marketItem.getPrice()));
                    lore.add("\u00a77Listed: \u00a7f" + TimeUtils.formatTimeAgo(marketItem.getListedTime()));
                    lore.add("");
                    lore.add("\u00a7eClick to view listing");
                    meta.setLore(lore);
                    contentItem.setItemMeta(meta);
                    break;
                }
                contentItem = this.createItem(Material.BARRIER, "\u00a7cListing Not Found", "\u00a77The reported listing has been", "\u00a77removed or expired.");
                break;
            }
            case SHOP: {
                PlayerShop shop = this.plugin.getShopManager().getShop(this.report.getTargetId());
                if (shop != null) {
                    contentItem = this.createItem(Material.CHEST, "\u00a7e" + shop.getName(), "\u00a77Owner: \u00a7e" + shop.getOwnerName(), "\u00a77Items: \u00a7e" + shop.getItems().size(), "\u00a77Total Sales: \u00a76" + this.plugin.getEconomyManager().formatMoney(shop.getTotalEarnings()), "\u00a77Created: \u00a7f" + shop.getCreatedTime().format(DATE_FORMAT), "", "\u00a7eClick to view shop");
                    break;
                }
                contentItem = this.createItem(Material.BARRIER, "\u00a7cShop Not Found", "\u00a77The reported shop has been", "\u00a77removed or deleted.");
                break;
            }
            case PLAYER: {
                contentItem = this.createItem(Material.PLAYER_HEAD, "\u00a7cPlayer Report", "\u00a77Direct player report", "\u00a77Check player's listings and shops", "\u00a77for potential violations");
            }
        }
        if (contentItem != null) {
            this.setItem(22, contentItem, e -> {
                PlayerShop shop;
                if (this.report.getReportType() == Report.ReportType.AUCTION) {
                    MarketItem item = this.plugin.getAuctionManager().getListingById(UUID.fromString(this.report.getTargetId()));
                    if (item != null) {
                        this.playClickSound();
                        this.player.closeInventory();
                        this.player.sendMessage("\u00a7eListing ID: \u00a7f" + item.getId());
                    }
                } else if (this.report.getReportType() == Report.ReportType.SHOP && (shop = this.plugin.getShopManager().getShop(this.report.getTargetId())) != null) {
                    this.playClickSound();
                    new AdminShopDetailsGUI(this.plugin, this.player, shop).open();
                }
            });
        }
    }

    private void displayActions() {
        if (this.report.getStatus() == Report.ReportStatus.RESOLVED || this.report.getStatus() == Report.ReportStatus.DISMISSED) {
            ItemStack resolvedInfo = this.createItem(Material.EMERALD_BLOCK, "\u00a7a\u00a7lReport Closed", "\u00a77Status: \u00a7e" + this.report.getStatus().name(), "\u00a77Resolved by: \u00a7e" + this.plugin.getServer().getOfflinePlayer(UUID.fromString(this.report.getResolvedBy())).getName(), "\u00a77Resolved: \u00a7f" + this.report.getResolvedTime().format(DATE_FORMAT), "", "\u00a77Resolution: \u00a7f" + (this.report.getResolution() != null ? this.report.getResolution() : "No details"));
            this.setItem(40, resolvedInfo, null);
        } else {
            ItemStack dismissButton = this.createItem(Material.GRAY_DYE, "\u00a77\u00a7lDismiss Report", "\u00a77Mark as invalid/false report", "\u00a77No action will be taken", "", "\u00a7eClick to dismiss");
            this.setItem(29, dismissButton, e -> {
                this.playClickSound();
                this.plugin.getReportManager().dismissReport(this.report.getId(), this.player.getUniqueId().toString());
                this.player.sendMessage("\u00a7aReport dismissed successfully.");
                new AdminReportsGUI(this.plugin, this.player).open();
            });
            ItemStack warnButton = this.createItem(Material.YELLOW_DYE, "\u00a7e\u00a7lWarn Player", "\u00a77Send a warning to the", "\u00a77reported player", "", "\u00a7eClick to warn");
            this.setItem(31, warnButton, e -> {
                this.playClickSound();
                OfflinePlayer reported = this.plugin.getServer().getOfflinePlayer(UUID.fromString(this.report.getReportedId()));
                if (reported.isOnline()) {
                    reported.getPlayer().sendMessage("\u00a7c\u00a7lWARNING: \u00a77Your marketplace activity has been reported for: \u00a7e" + this.report.getReason());
                    reported.getPlayer().sendMessage("\u00a77Please ensure you follow all marketplace rules.");
                }
                this.plugin.getReportManager().resolveReport(this.report.getId(), this.player.getUniqueId().toString(), "Warned player for: " + this.report.getReason());
                this.player.sendMessage("\u00a7aPlayer warned and report resolved.");
                new AdminReportsGUI(this.plugin, this.player).open();
            });
            ItemStack deleteButton = this.createItem(Material.ORANGE_DYE, "\u00a76\u00a7lDelete Content", "\u00a77Remove the reported", "\u00a77listing or shop", "", "\u00a7eClick to delete");
            this.setItem(32, deleteButton, e -> {
                PlayerShop shop;
                this.playClickSound();
                boolean deleted = false;
                Object resolution = "";
                if (this.report.getReportType() == Report.ReportType.AUCTION) {
                    MarketItem item = this.plugin.getAuctionManager().getListingById(UUID.fromString(this.report.getTargetId()));
                    if (item != null) {
                        this.plugin.getAuctionManager().cancelListing(this.player, item.getId());
                        deleted = true;
                        resolution = "Listing removed for: " + this.report.getReason();
                    }
                } else if (this.report.getReportType() == Report.ReportType.SHOP && (shop = this.plugin.getShopManager().getShop(this.report.getTargetId())) != null) {
                    this.plugin.getShopManager().deleteShop(shop.getId());
                    deleted = true;
                    resolution = "Shop deleted for: " + this.report.getReason();
                }
                if (deleted) {
                    this.plugin.getReportManager().resolveReport(this.report.getId(), this.player.getUniqueId().toString(), (String)resolution);
                    this.player.sendMessage("\u00a7aContent deleted and report resolved.");
                } else {
                    this.player.sendMessage("\u00a7cContent already removed.");
                }
                new AdminReportsGUI(this.plugin, this.player).open();
            });
            ItemStack banButton = this.createItem(Material.RED_DYE, "\u00a7c\u00a7lBan Player", "\u00a77Ban player from marketplace", "\u00a77They cannot buy, sell, or", "\u00a77create shops", "", "\u00a7cClick to ban");
            this.setItem(33, banButton, e -> {
                this.playClickSound();
                String reason = "Banned for: " + this.report.getReason();
                this.plugin.getAdminManager().banPlayerFromMarket(UUID.fromString(this.report.getReportedId()), this.player, reason);
                this.plugin.getReportManager().resolveReport(this.report.getId(), this.player.getUniqueId().toString(), "Player banned from marketplace");
                this.player.sendMessage("\u00a7aPlayer banned and report resolved.");
                new AdminReportsGUI(this.plugin, this.player).open();
            });
        }
        ItemStack backButton = this.createItem(Material.ARROW, "\u00a7cBack to Reports", new String[0]);
        this.setItem(36, backButton, e -> new AdminReportsGUI(this.plugin, this.player).open());
    }

    private ItemStack createPlayerHead(String playerName, String ... lore) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(playerName);
        meta.setOwningPlayer(offlinePlayer);
        meta.setDisplayName(lore[0]);
        ArrayList<String> loreList = new ArrayList<String>();
        for (int i = 1; i < lore.length; ++i) {
            loreList.add(lore[i]);
        }
        meta.setLore(loreList);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }
}

