/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.models.ShopAdvertisement;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AdvertisementManager {
    private final MarketPlacePlus plugin;
    private final Map<UUID, LocalDateTime> lastAdvertisement;
    private final List<ShopAdvertisement> activeAds;

    public AdvertisementManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.lastAdvertisement = new ConcurrentHashMap<UUID, LocalDateTime>();
        this.activeAds = new ArrayList<ShopAdvertisement>();
    }

    public boolean canAdvertise(Player player) {
        LocalDateTime lastAd = this.lastAdvertisement.get(player.getUniqueId());
        if (lastAd == null) {
            return true;
        }
        int cooldownHours = this.plugin.getConfig().getInt("advertisements.cooldown-hours", 24);
        return LocalDateTime.now().isAfter(lastAd.plusHours(cooldownHours));
    }

    public long getTimeUntilNextAd(Player player) {
        LocalDateTime lastAd = this.lastAdvertisement.get(player.getUniqueId());
        if (lastAd == null) {
            return 0L;
        }
        int cooldownHours = this.plugin.getConfig().getInt("advertisements.cooldown-hours", 24);
        LocalDateTime nextAvailable = lastAd.plusHours(cooldownHours);
        return Duration.between(LocalDateTime.now(), nextAvailable).toMillis();
    }

    public boolean createAdvertisement(Player player, PlayerShop shop, String message) {
        if (!this.canAdvertise(player)) {
            return false;
        }
        double cost = this.plugin.getConfig().getDouble("advertisements.cost", 5000.0);
        if (!this.plugin.getEconomyManager().hasBalance(player, cost)) {
            return false;
        }
        this.plugin.getEconomyManager().withdrawPlayer(player, cost);
        int durationHours = this.plugin.getConfig().getInt("advertisements.duration-hours", 1);
        LocalDateTime startTime = LocalDateTime.now();
        LocalDateTime endTime = startTime.plusHours(durationHours);
        ShopAdvertisement ad = new ShopAdvertisement(shop.getId(), player.getUniqueId(), shop.getShopName(), message, startTime, endTime, cost);
        this.activeAds.add(ad);
        this.lastAdvertisement.put(player.getUniqueId(), startTime);
        this.plugin.getDatabaseManager().saveAdvertisement(ad);
        this.broadcastAdvertisement(ad);
        return true;
    }

    public void broadcastAdvertisement(ShopAdvertisement ad) {
        String prefix = this.plugin.getConfig().getString("advertisements.broadcast-prefix", "&6[AD]");
        String format = this.plugin.getConfig().getString("advertisements.broadcast-format", "{prefix} &e{shop} &7- &f{message}");
        String broadcast = format.replace("{prefix}", prefix).replace("{shop}", ad.getShopName()).replace("{message}", ad.getMessage());
        this.plugin.getServer().broadcastMessage(broadcast.replace("&", "\u00a7"));
    }

    public void loadAdvertisements() {
        this.activeAds.clear();
        this.activeAds.addAll(this.plugin.getDatabaseManager().loadActiveAdvertisements());
        for (ShopAdvertisement ad : this.activeAds) {
            this.lastAdvertisement.put(ad.getOwnerId(), ad.getStartTime());
        }
    }

    public void cleanupExpiredAds() {
        this.activeAds.removeIf(ad -> !ad.isActive());
    }

    public List<ShopAdvertisement> getActiveAdvertisements() {
        this.cleanupExpiredAds();
        return new ArrayList<ShopAdvertisement>(this.activeAds);
    }

    public void startBroadcastTask() {
        int intervalMinutes = this.plugin.getConfig().getInt("advertisements.broadcast-interval-minutes", 30);
        long intervalTicks = (long)(intervalMinutes * 60) * 20L;
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            List<ShopAdvertisement> currentAds = this.getActiveAdvertisements();
            if (!currentAds.isEmpty()) {
                ShopAdvertisement randomAd = currentAds.get(new Random().nextInt(currentAds.size()));
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.broadcastAdvertisement(randomAd));
            }
        }, intervalTicks, intervalTicks);
    }
}

