/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.models.Bid;
import MPP.marketPlacePlus.models.CollectableItem;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.TradeHistory;
import MPP.marketPlacePlus.utils.AntiScamUtils;
import MPP.marketPlacePlus.utils.ItemUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AuctionManager {
    private final MarketPlacePlus plugin;
    private final Map<String, MarketItem> listings;
    private final Map<UUID, List<String>> playerListings;
    private final Map<String, List<Bid>> auctionBids;

    public AuctionManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.listings = new ConcurrentHashMap<String, MarketItem>();
        this.playerListings = new ConcurrentHashMap<UUID, List<String>>();
        this.auctionBids = new ConcurrentHashMap<String, List<Bid>>();
    }

    public boolean createListing(Player seller, ItemStack item, double price) {
        if (this.plugin.getAdminManager().isPlayerBanned(seller.getUniqueId())) {
            seller.sendMessage("\u00a7c\u00a7lMarket Ban: \u00a77You are banned from using the marketplace.");
            return false;
        }
        if (item == null || item.getType() == Material.AIR || item.getType() == Material.VOID_AIR || item.getType() == Material.CAVE_AIR || !item.getType().isItem()) {
            seller.sendMessage("\u00a7cCannot list this type of item!");
            return false;
        }
        UUID sellerId = seller.getUniqueId();
        int maxListings = this.plugin.getConfig().getInt("auction-house.max-listings-per-player");
        if (this.getPlayerListingCount(sellerId) >= maxListings && !seller.hasPermission("marketplaceplus.admin.bypass.limit")) {
            seller.sendMessage("\u00a7cYou have reached your maximum number of listings (" + maxListings + ")!");
            return false;
        }
        double minPrice = Math.max(0.01, this.plugin.getConfig().getDouble("auction-house.min-price"));
        double maxPrice = this.plugin.getConfig().getDouble("auction-house.max-price");
        if (price < minPrice || price > maxPrice || price < 0.0) {
            seller.sendMessage("\u00a7cPrice must be between " + this.plugin.getEconomyManager().formatMoney(minPrice) + " and " + this.plugin.getEconomyManager().formatMoney(maxPrice) + "!");
            return false;
        }
        double listingFee = price * (this.plugin.getConfig().getDouble("auction-house.listing-fee-percentage") / 100.0);
        if (listingFee > 0.0 && !seller.hasPermission("marketplaceplus.admin.bypass.fee")) {
            if (!this.plugin.getEconomyManager().hasBalance(seller, listingFee)) {
                seller.sendMessage("\u00a7cYou need " + this.plugin.getEconomyManager().formatMoney(listingFee) + " to list this item!");
                return false;
            }
            if (!this.plugin.getEconomyManager().withdrawPlayer(seller, listingFee)) {
                seller.sendMessage("\u00a7cFailed to withdraw listing fee!");
                return false;
            }
        }
        String id = UUID.randomUUID().toString();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime expiry = now.plusHours(this.plugin.getConfig().getInt("auction-house.listing-duration-hours"));
        String category = ItemUtils.getCategory(item);
        String serialized = ItemUtils.serializeItem(item);
        if (serialized == null) {
            seller.sendMessage("\u00a7cFailed to serialize item! This item cannot be listed.");
            this.plugin.getLogger().warning("Failed to serialize item for player " + seller.getName());
            return false;
        }
        MarketItem marketItem = new MarketItem(id, sellerId, seller.getName(), item.clone(), price, now, expiry, category, serialized);
        this.listings.put(id, marketItem);
        this.playerListings.computeIfAbsent(sellerId, k -> new ArrayList()).add(id);
        this.plugin.getDatabaseManager().saveListing(marketItem);
        if (this.plugin.getDiscordWebhookManager() != null) {
            this.plugin.getDiscordWebhookManager().sendListingNotification(marketItem, seller);
        }
        return true;
    }

    public boolean createAuction(Player seller, ItemStack item, double startingBid, double bidIncrement, int durationHours) {
        if (this.plugin.getAdminManager().isPlayerBanned(seller.getUniqueId())) {
            seller.sendMessage("\u00a7c\u00a7lMarket Ban: \u00a77You are banned from using the marketplace.");
            return false;
        }
        if (item == null || item.getType() == Material.AIR || item.getType() == Material.VOID_AIR || item.getType() == Material.CAVE_AIR || !item.getType().isItem()) {
            seller.sendMessage("\u00a7cCannot auction this type of item!");
            return false;
        }
        UUID sellerId = seller.getUniqueId();
        int maxListings = this.plugin.getConfig().getInt("auction-house.max-listings-per-player");
        if (this.getPlayerListingCount(sellerId) >= maxListings && !seller.hasPermission("marketplaceplus.admin.bypass.limit")) {
            seller.sendMessage("\u00a7cYou have reached your maximum number of listings (" + maxListings + ")!");
            return false;
        }
        double minBid = Math.max(0.01, this.plugin.getConfig().getDouble("auction-house.min-starting-bid", 100.0));
        double maxBid = this.plugin.getConfig().getDouble("auction-house.max-starting-bid", 100000.0);
        if (startingBid < minBid || startingBid > maxBid || startingBid < 0.0) {
            seller.sendMessage("\u00a7cStarting bid must be between " + this.plugin.getEconomyManager().formatMoney(minBid) + " and " + this.plugin.getEconomyManager().formatMoney(maxBid) + "!");
            return false;
        }
        String category = ItemUtils.getCategory(item);
        String serialized = ItemUtils.serializeItem(item);
        if (serialized == null) {
            seller.sendMessage("\u00a7cFailed to serialize item! This item cannot be auctioned.");
            this.plugin.getLogger().warning("Failed to serialize item for auction by player " + seller.getName());
            return false;
        }
        double listingFee = startingBid * (this.plugin.getConfig().getDouble("auction-house.listing-fee-percentage") / 100.0);
        if (listingFee > 0.0 && !seller.hasPermission("marketplaceplus.admin.bypass.fee")) {
            if (!this.plugin.getEconomyManager().hasBalance(seller, listingFee)) {
                seller.sendMessage("\u00a7cYou need " + this.plugin.getEconomyManager().formatMoney(listingFee) + " to create this auction!");
                return false;
            }
            this.plugin.getEconomyManager().withdrawPlayer(seller, listingFee);
        }
        seller.getInventory().removeItem(new ItemStack[]{item});
        String id = UUID.randomUUID().toString();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime expiry = now.plusHours(durationHours);
        MarketItem marketItem = new MarketItem(id, sellerId, seller.getName(), item, startingBid, now, expiry, category, serialized);
        marketItem.enableAuction(startingBid, bidIncrement);
        this.plugin.getDatabaseManager().saveListing(marketItem);
        this.listings.put(id, marketItem);
        this.playerListings.computeIfAbsent(sellerId, k -> new ArrayList()).add(id);
        this.auctionBids.put(id, new ArrayList());
        if (this.plugin.getDiscordWebhookManager() != null) {
            this.plugin.getDiscordWebhookManager().sendAuctionCreatedNotification(marketItem, seller);
        }
        seller.sendMessage("\u00a7a\u00a7lAuction Created!");
        seller.sendMessage("\u00a77Your auction for \u00a7f" + ItemUtils.getItemName(item) + " \u00a77has been listed!");
        seller.sendMessage("\u00a77Starting bid: \u00a76" + this.plugin.getEconomyManager().formatMoney(startingBid));
        seller.sendMessage("\u00a77Duration: \u00a7b" + durationHours + " hours");
        if (listingFee > 0.0) {
            seller.sendMessage("\u00a77Listing fee: \u00a7c" + this.plugin.getEconomyManager().formatMoney(listingFee));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean purchaseListing(Player buyer, String listingId) {
        Map<String, MarketItem> map = this.listings;
        synchronized (map) {
            MarketItem item = this.listings.get(listingId);
            if (item == null || item.isSold() || item.isExpired()) {
                return false;
            }
            if (buyer.getUniqueId().equals(item.getSellerId())) {
                return false;
            }
            if (!this.plugin.getEconomyManager().hasBalance(buyer, item.getPrice())) {
                return false;
            }
            if (!this.plugin.getEconomyManager().withdrawPlayer(buyer, item.getPrice())) {
                return false;
            }
            if (item.isSold()) {
                this.plugin.getEconomyManager().depositPlayer(buyer, item.getPrice());
                return false;
            }
            item.markAsSold(buyer.getUniqueId(), buyer.getName());
            this.plugin.getDatabaseManager().updateListing(item);
            try {
                if (!ItemUtils.hasInventorySpace(buyer, item.getItemStack(), item.getItemStack().getAmount())) {
                    int collectionLimit = this.plugin.getConfig().getInt("collection.max-items-per-player", 100);
                    if (this.plugin.getCollectionManager().getItemCount(buyer.getUniqueId()) >= collectionLimit) {
                        item.markAsSold(null, null);
                        this.plugin.getDatabaseManager().updateListing(item);
                        this.plugin.getEconomyManager().depositPlayer(buyer, item.getPrice());
                        buyer.sendMessage("\u00a7cYour collection box is full! Please collect items before purchasing.");
                        return false;
                    }
                    this.plugin.getCollectionManager().addItem(buyer.getUniqueId(), item.getItemStack(), CollectableItem.CollectionType.AUCTION_WON, item.getPrice());
                    buyer.sendMessage("\u00a7eYour inventory is full! Item has been added to your collection box.");
                    buyer.sendMessage("\u00a7eUse \u00a76/market collect \u00a7eto retrieve it!");
                } else {
                    ItemStack itemToGive = item.getItemStack().clone();
                    AntiScamUtils.clearItemUUID(itemToGive, (Plugin)this.plugin);
                    buyer.getInventory().addItem(new ItemStack[]{itemToGive});
                }
                this.plugin.getEconomyManager().depositPlayer(item.getSellerId(), item.getPrice());
                this.plugin.getPriceManager().recordPrice(item.getItemStack(), item.getPrice(), item.getItemStack().getAmount());
                this.plugin.getTradeHistoryManager().recordAuctionPurchase(item, buyer);
                if (this.plugin.getDiscordWebhookManager() != null) {
                    this.plugin.getDiscordWebhookManager().sendAuctionSaleNotification(item, buyer);
                }
                this.plugin.getCacheManager().invalidatePlayerCache(buyer.getUniqueId());
                this.plugin.getCacheManager().invalidatePlayerCache(item.getSellerId());
                this.plugin.getCacheManager().invalidateListingCache();
                return true;
            }
            catch (Exception e) {
                item.markAsSold(null, null);
                this.plugin.getDatabaseManager().updateListing(item);
                this.plugin.getEconomyManager().depositPlayer(buyer, item.getPrice());
                this.plugin.getLogger().severe("Failed to complete purchase, refunding buyer: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
    }

    public boolean cancelListing(Player seller, String listingId) {
        MarketItem item = this.listings.get(listingId);
        if (item == null || !item.getSellerId().equals(seller.getUniqueId()) || item.isSold()) {
            return false;
        }
        if (!ItemUtils.hasInventorySpace(seller, item.getItemStack(), item.getItemStack().getAmount())) {
            this.plugin.getCollectionManager().addItem(seller.getUniqueId(), item.getItemStack(), CollectableItem.CollectionType.CANCELLED_LISTING, item.getPrice());
            seller.sendMessage("\u00a7eYour inventory is full! Item has been added to your collection box.");
            seller.sendMessage("\u00a7eUse \u00a76/market collect \u00a7eto retrieve it!");
        } else {
            ItemStack itemToGive = item.getItemStack().clone();
            AntiScamUtils.clearItemUUID(itemToGive, (Plugin)this.plugin);
            seller.getInventory().addItem(new ItemStack[]{itemToGive});
        }
        this.listings.remove(listingId);
        this.playerListings.computeIfPresent(seller.getUniqueId(), (k, list) -> {
            list.remove(listingId);
            return list.isEmpty() ? null : list;
        });
        this.plugin.getCacheManager().invalidatePlayerCache(seller.getUniqueId());
        this.plugin.getCacheManager().invalidateListingCache();
        this.plugin.getDatabaseManager().deleteListing(listingId);
        return true;
    }

    public synchronized boolean placeBid(Player bidder, String auctionId, double bidAmount) {
        MarketItem auction = this.listings.get(auctionId);
        if (auction == null || !auction.isAuction() || auction.isSold() || auction.isExpired()) {
            bidder.sendMessage("\u00a7cThis auction is no longer available!");
            return false;
        }
        if (auction.getSellerId().equals(bidder.getUniqueId())) {
            bidder.sendMessage("\u00a7cYou cannot bid on your own auction!");
            return false;
        }
        double minimumBid = auction.getMinimumBid();
        if (bidAmount < minimumBid) {
            bidder.sendMessage("\u00a7cYou must bid at least " + this.plugin.getEconomyManager().formatMoney(minimumBid) + "!");
            return false;
        }
        double maxBid = this.plugin.getConfig().getDouble("auction-house.max-bid-amount", 1.0E9);
        if (bidAmount > maxBid) {
            bidder.sendMessage("\u00a7cBid amount cannot exceed " + this.plugin.getEconomyManager().formatMoney(maxBid) + "!");
            return false;
        }
        if (!this.plugin.getEconomyManager().hasBalance(bidder, bidAmount)) {
            bidder.sendMessage("\u00a7cYou don't have enough money to place this bid!");
            return false;
        }
        if (!this.plugin.getEconomyManager().withdrawPlayer(bidder, bidAmount)) {
            bidder.sendMessage("\u00a7cFailed to withdraw money! Please try again.");
            return false;
        }
        UUID previousBidderId = auction.getHighestBidderId();
        double previousBid = auction.getCurrentBid();
        if (previousBidderId != null && !previousBidderId.equals(bidder.getUniqueId())) {
            this.plugin.getEconomyManager().depositPlayer(previousBidderId, previousBid);
            Player previousBidder = this.plugin.getServer().getPlayer(previousBidderId);
            if (previousBidder != null) {
                previousBidder.sendMessage("\u00a7eYou have been outbid on " + ItemUtils.getItemName(auction.getItemStack()) + "! Your bid of " + this.plugin.getEconomyManager().formatMoney(previousBid) + " has been refunded.");
            }
        }
        auction.placeBid(bidder.getUniqueId(), bidder.getName(), bidAmount);
        String bidId = UUID.randomUUID().toString();
        Bid bid = new Bid(bidId, auctionId, bidder.getUniqueId(), bidder.getName(), bidAmount, LocalDateTime.now());
        bid.setWinning(true);
        List<Bid> auctionBidList = this.auctionBids.get(auctionId);
        if (auctionBidList != null) {
            auctionBidList.forEach(b -> b.setWinning(false));
            auctionBidList.add(bid);
        }
        this.plugin.getDatabaseManager().saveBid(bid);
        this.plugin.getDatabaseManager().updateListing(auction);
        bidder.sendMessage("\u00a7aYou have successfully bid " + this.plugin.getEconomyManager().formatMoney(bidAmount) + " on " + ItemUtils.getItemName(auction.getItemStack()) + "!");
        Player seller = this.plugin.getServer().getPlayer(auction.getSellerId());
        if (seller != null) {
            seller.sendMessage("\u00a7a" + bidder.getName() + " has bid " + this.plugin.getEconomyManager().formatMoney(bidAmount) + " on your auction!");
        }
        return true;
    }

    public List<MarketItem> getActiveListings() {
        return this.listings.values().stream().filter(item -> !item.isSold() && !item.isExpired()).sorted(Comparator.comparing(MarketItem::getListedTime).reversed()).collect(Collectors.toList());
    }

    public List<MarketItem> getPlayerListings(UUID playerId) {
        List<String> ids = this.playerListings.get(playerId);
        if (ids == null) {
            return new ArrayList<MarketItem>();
        }
        return ids.stream().map(this.listings::get).filter(Objects::nonNull).filter(item -> !item.isSold()).collect(Collectors.toList());
    }

    public List<MarketItem> getExpiredListings(UUID playerId) {
        List<String> ids = this.playerListings.get(playerId);
        if (ids == null) {
            return new ArrayList<MarketItem>();
        }
        return ids.stream().map(this.listings::get).filter(Objects::nonNull).filter(item -> !item.isSold() && item.isExpired()).collect(Collectors.toList());
    }

    public void loadListings() {
        this.listings.clear();
        this.playerListings.clear();
        List<MarketItem> savedListings = this.plugin.getDatabaseManager().loadAllListings();
        int activeCount = 0;
        int expiredCount = 0;
        int soldCount = 0;
        for (MarketItem item : savedListings) {
            this.listings.put(item.getId(), item);
            this.playerListings.computeIfAbsent(item.getSellerId(), k -> new ArrayList()).add(item.getId());
            if (item.isSold()) {
                ++soldCount;
                continue;
            }
            if (item.isExpired()) {
                ++expiredCount;
                continue;
            }
            ++activeCount;
        }
    }

    public synchronized void cleanupExpiredListings() {
        LocalDateTime now = LocalDateTime.now();
        List expiredItems = this.listings.values().stream().filter(item -> !item.isSold() && item.isExpired() && !item.isAuction()).collect(Collectors.toList());
        if (expiredItems.isEmpty()) {
            return;
        }
        HashMap<UUID, List> expiredByPlayer = new HashMap<UUID, List>();
        HashSet<String> processedListingIds = new HashSet<String>();
        for (MarketItem marketItem : expiredItems) {
            if (processedListingIds.contains(marketItem.getId())) {
                this.plugin.getLogger().warning("Skipping duplicate listing ID during cleanup: " + marketItem.getId());
                continue;
            }
            expiredByPlayer.computeIfAbsent(marketItem.getSellerId(), k -> new ArrayList()).add(marketItem);
            processedListingIds.add(marketItem.getId());
        }
        for (Map.Entry entry : expiredByPlayer.entrySet()) {
            UUID sellerId = (UUID)entry.getKey();
            List playerExpiredItems = (List)entry.getValue();
            List<String> listingIds = playerExpiredItems.stream().map(MarketItem::getId).collect(Collectors.toList());
            List<ItemStack> itemStacks = playerExpiredItems.stream().map(MarketItem::getItemStack).collect(Collectors.toList());
            this.plugin.getCollectionManager().addItemsWithDuplicateCheck(sellerId, itemStacks, CollectableItem.CollectionType.EXPIRED_LISTING, 0.0);
            this.plugin.getDatabaseManager().deleteListings(listingIds);
            for (MarketItem item3 : playerExpiredItems) {
                this.listings.remove(item3.getId());
                this.playerListings.computeIfPresent(sellerId, (k, list) -> {
                    list.remove(item3.getId());
                    return list.isEmpty() ? null : list;
                });
            }
            this.plugin.getCacheManager().invalidatePlayerCache(sellerId);
        }
        this.plugin.getCacheManager().invalidateListingCache();
        this.plugin.getLogger().info("Cleaned up " + processedListingIds.size() + " expired listings for " + expiredByPlayer.size() + " players");
    }

    public void processEndedAuctions() {
        List endedAuctions = this.listings.values().stream().filter(item -> item.isAuction() && !item.isSold() && item.isExpired()).collect(Collectors.toList());
        if (endedAuctions.isEmpty()) {
            return;
        }
        for (MarketItem auction : endedAuctions) {
            if (auction.getHighestBidderId() != null) {
                UUID winnerId = auction.getHighestBidderId();
                Player winner = this.plugin.getServer().getPlayer(winnerId);
                auction.markAsSold(winnerId, auction.getHighestBidderName());
                this.plugin.getDatabaseManager().updateListing(auction);
                double finalPrice = auction.getCurrentBid();
                double tax = finalPrice * (this.plugin.getConfig().getDouble("player-shops.shop-tax-percentage", 2.0) / 100.0);
                double sellerEarnings = finalPrice - tax;
                this.plugin.getEconomyManager().depositPlayer(auction.getSellerId(), sellerEarnings);
                Player seller = this.plugin.getServer().getPlayer(auction.getSellerId());
                if (seller != null) {
                    seller.sendMessage("\u00a7aYour auction for " + ItemUtils.getItemName(auction.getItemStack()) + " has ended! Winner: " + auction.getHighestBidderName() + " for " + this.plugin.getEconomyManager().formatMoney(finalPrice));
                    seller.sendMessage("\u00a7aYou received " + this.plugin.getEconomyManager().formatMoney(sellerEarnings) + " after taxes.");
                }
                this.plugin.getCollectionManager().addItem(winnerId, auction.getItemStack(), CollectableItem.CollectionType.AUCTION_WON, finalPrice);
                this.plugin.getCacheManager().invalidatePlayerCache(winnerId);
                this.plugin.getCacheManager().invalidatePlayerCache(auction.getSellerId());
                if (winner != null) {
                    winner.sendMessage("\u00a7a\u00a7lAuction Won! \u00a7aYou won " + ItemUtils.getItemName(auction.getItemStack()) + " for " + this.plugin.getEconomyManager().formatMoney(finalPrice) + "!");
                    winner.sendMessage("\u00a7eUse \u00a76/market collect \u00a7eto claim your item!");
                }
                TradeHistory tradeRecord = new TradeHistory(UUID.randomUUID().toString(), auction.getSellerId(), auction.getSellerName(), winnerId, auction.getHighestBidderName(), auction.getItemStack(), auction.getSerializedItem(), finalPrice, auction.getItemStack().getAmount(), LocalDateTime.now(), TradeHistory.TradeType.AUCTION);
                this.plugin.getDatabaseManager().saveTradeHistory(tradeRecord);
                if (this.plugin.getDiscordWebhookManager() != null && winner != null) {
                    this.plugin.getDiscordWebhookManager().sendAuctionSaleNotification(auction, winner);
                }
            } else {
                this.plugin.getCollectionManager().addItem(auction.getSellerId(), auction.getItemStack(), CollectableItem.CollectionType.EXPIRED_LISTING, auction.getStartingBid());
                Player seller = this.plugin.getServer().getPlayer(auction.getSellerId());
                if (seller != null) {
                    seller.sendMessage("\u00a7eYour auction for " + ItemUtils.getItemName(auction.getItemStack()) + " ended with no bids. The item has been added to your collection box.");
                    seller.sendMessage("\u00a7eUse \u00a76/market collect \u00a7eto retrieve it!");
                }
            }
            this.listings.remove(auction.getId());
            this.playerListings.computeIfPresent(auction.getSellerId(), (k, list) -> {
                list.remove(auction.getId());
                return list.isEmpty() ? null : list;
            });
            this.auctionBids.remove(auction.getId());
            this.plugin.getCacheManager().invalidatePlayerCache(auction.getSellerId());
        }
        this.plugin.getCacheManager().invalidateListingCache();
    }

    public void debugListings() {
    }

    public void saveListings() {
        for (MarketItem item : this.listings.values()) {
            if (item.isSold()) continue;
            this.plugin.getDatabaseManager().saveListing(item);
        }
    }

    public MarketItem getListingById(UUID listingId) {
        return this.listings.get(listingId.toString());
    }

    public void removeListingAdmin(UUID listingId) {
        String id = listingId.toString();
        MarketItem item = this.listings.get(id);
        if (item != null) {
            UUID sellerId = item.getSellerId();
            this.listings.remove(id);
            List<String> playerIds = this.playerListings.get(sellerId);
            if (playerIds != null) {
                playerIds.remove(id);
            }
            this.plugin.getDatabaseManager().deleteListing(id);
            this.plugin.getCacheManager().invalidatePlayerCache(sellerId);
            this.plugin.getCacheManager().invalidateListingCache();
        }
    }

    public void removeAllPlayerListings(UUID playerId) {
        List<String> ids = this.playerListings.get(playerId);
        if (ids != null) {
            for (String id : new ArrayList<String>(ids)) {
                this.listings.remove(id);
                this.plugin.getDatabaseManager().deleteListing(id);
            }
            this.playerListings.remove(playerId);
            this.plugin.getCacheManager().invalidatePlayerCache(playerId);
            this.plugin.getCacheManager().invalidateListingCache();
        }
    }

    public void expireListingAdmin(UUID listingId) {
        MarketItem item = this.listings.get(listingId.toString());
        if (item != null) {
            item.expire();
            this.plugin.getDatabaseManager().saveListing(item);
        }
    }

    public void updateListingPrice(UUID listingId, double newPrice) {
        MarketItem item = this.listings.get(listingId.toString());
        if (item != null) {
            item.setPrice(newPrice);
            this.plugin.getDatabaseManager().saveListing(item);
        }
    }

    public int getPlayerListingCount(UUID playerId) {
        List<String> ids = this.playerListings.get(playerId);
        if (ids == null) {
            return 0;
        }
        return (int)ids.stream().map(this.listings::get).filter(Objects::nonNull).count();
    }

    public List<MarketItem> getPlayerActiveListings(UUID playerId) {
        List<String> ids = this.playerListings.get(playerId);
        if (ids == null) {
            return new ArrayList<MarketItem>();
        }
        return ids.stream().map(this.listings::get).filter(Objects::nonNull).filter(item -> !item.isSold() && !item.isExpired()).collect(Collectors.toList());
    }

    public List<MarketItem> getAllListings() {
        return new ArrayList<MarketItem>(this.listings.values());
    }
}

