/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyManager {
    private final MarketPlacePlus plugin;
    private Economy economy;
    private final boolean useVault;

    public EconomyManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.useVault = plugin.getConfig().getBoolean("economy.use-vault");
        if (this.useVault) {
            this.setupEconomy();
        }
    }

    private boolean setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public boolean hasBalance(Player player, double amount) {
        if (this.useVault && this.economy != null) {
            return this.economy.has((OfflinePlayer)player, amount);
        }
        return this.plugin.getDatabaseManager().getPlayerBalance(player.getUniqueId()) >= amount;
    }

    public double getBalance(Player player) {
        if (this.useVault && this.economy != null) {
            return this.economy.getBalance((OfflinePlayer)player);
        }
        return this.plugin.getDatabaseManager().getPlayerBalance(player.getUniqueId());
    }

    public boolean withdrawPlayer(Player player, double amount) {
        if (this.useVault && this.economy != null) {
            return this.economy.withdrawPlayer((OfflinePlayer)player, amount).transactionSuccess();
        }
        double balance = this.plugin.getDatabaseManager().getPlayerBalance(player.getUniqueId());
        if (balance >= amount) {
            this.plugin.getDatabaseManager().setPlayerBalance(player.getUniqueId(), balance - amount);
            return true;
        }
        return false;
    }

    public boolean depositPlayer(Player player, double amount) {
        if (this.useVault && this.economy != null) {
            return this.economy.depositPlayer((OfflinePlayer)player, amount).transactionSuccess();
        }
        double balance = this.plugin.getDatabaseManager().getPlayerBalance(player.getUniqueId());
        this.plugin.getDatabaseManager().setPlayerBalance(player.getUniqueId(), balance + amount);
        return true;
    }

    public boolean depositPlayer(UUID playerId, double amount) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player != null) {
            return this.depositPlayer(player, amount);
        }
        if (this.useVault && this.economy != null) {
            return this.economy.depositPlayer(Bukkit.getOfflinePlayer((UUID)playerId), amount).transactionSuccess();
        }
        double balance = this.plugin.getDatabaseManager().getPlayerBalance(playerId);
        this.plugin.getDatabaseManager().setPlayerBalance(playerId, balance + amount);
        return true;
    }

    public String formatMoney(double amount) {
        String symbol = this.plugin.getConfig().getString("economy.currency-symbol");
        return String.format("%s%.2f", symbol, amount);
    }

    public boolean isAvailable() {
        return !this.useVault || this.economy != null;
    }
}

