/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.models.MarketItem;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class PlaceholderDataManager {
    private final MarketPlacePlus plugin;
    private final Map<UUID, Double> playerTaxSaved = new ConcurrentHashMap<UUID, Double>();
    private double totalMarketVolume = 0.0;
    private double averageItemPrice = 0.0;
    private double totalTaxCollected = 0.0;
    private String trendingItem = "None";
    private List<UUID> topSellers = new ArrayList<UUID>();
    private List<UUID> topBuyers = new ArrayList<UUID>();
    private List<UUID> topEarners = new ArrayList<UUID>();
    private List<UUID> topAuctioneers = new ArrayList<UUID>();
    private List<UUID> topTraders = new ArrayList<UUID>();

    public PlaceholderDataManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
    }

    public void updateCacheData() {
        this.calculateMarketVolume();
        this.calculateAveragePrice();
        this.updateTopLists();
        this.updateTrendingItem();
    }

    private void calculateMarketVolume() {
        this.totalMarketVolume = this.plugin.getAuctionManager().getAllListings().stream().filter(MarketItem::isSold).mapToDouble(MarketItem::getPrice).sum();
        this.totalMarketVolume += this.plugin.getShopManager().getAllShops().stream().mapToDouble(shop -> shop.getTotalEarnings()).sum();
    }

    private void calculateAveragePrice() {
        List activeItems = this.plugin.getAuctionManager().getAllListings().stream().filter(item -> !item.isSold() && !item.isExpired()).collect(Collectors.toList());
        if (!activeItems.isEmpty()) {
            this.averageItemPrice = activeItems.stream().mapToDouble(MarketItem::getPrice).average().orElse(0.0);
        }
    }

    private void updateTopLists() {
        HashMap<UUID, Double> earningsMap = new HashMap<UUID, Double>();
        HashMap<UUID, Integer> salesMap = new HashMap<UUID, Integer>();
        HashMap<UUID, Integer> purchasesMap = new HashMap<UUID, Integer>();
        HashMap<UUID, Integer> auctionMap = new HashMap<UUID, Integer>();
        for (MarketItem item : this.plugin.getAuctionManager().getAllListings()) {
            UUID sellerId = item.getSellerId();
            if (item.isSold()) {
                earningsMap.merge(sellerId, item.getPrice(), Double::sum);
                salesMap.merge(sellerId, 1, Integer::sum);
                if (item.getBuyerId() != null) {
                    purchasesMap.merge(item.getBuyerId(), 1, Integer::sum);
                }
            }
            if (!item.isAuction()) continue;
            auctionMap.merge(sellerId, 1, Integer::sum);
        }
        this.topSellers = salesMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).map(Map.Entry::getKey).collect(Collectors.toList());
        this.topBuyers = purchasesMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).map(Map.Entry::getKey).collect(Collectors.toList());
        this.topEarners = earningsMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).map(Map.Entry::getKey).collect(Collectors.toList());
        this.topAuctioneers = auctionMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).map(Map.Entry::getKey).collect(Collectors.toList());
        this.topTraders = new ArrayList<UUID>();
        HashMap tradeCount = new HashMap();
        salesMap.forEach((uuid, count) -> tradeCount.merge(uuid, count, Integer::sum));
        purchasesMap.forEach((uuid, count) -> tradeCount.merge(uuid, count, Integer::sum));
        this.topTraders = tradeCount.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private void updateTrendingItem() {
        HashMap itemCounts = new HashMap();
        LocalDateTime cutoff = LocalDateTime.now().minusDays(1L);
        this.plugin.getAuctionManager().getAllListings().stream().filter(item -> item.getListedTime().isAfter(cutoff)).forEach(item -> {
            String itemType = item.getItemStack().getType().name();
            itemCounts.merge(itemType, item.getItemStack().getAmount(), Integer::sum);
        });
        this.trendingItem = itemCounts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse("None");
    }

    public double getTotalMarketVolume() {
        return this.totalMarketVolume;
    }

    public double getAverageItemPrice() {
        return this.averageItemPrice;
    }

    public String getTrendingItem() {
        return this.trendingItem;
    }

    public double getTotalTaxCollected() {
        return this.totalTaxCollected;
    }

    public void addTaxCollected(double amount) {
        this.totalTaxCollected += amount;
    }

    public List<UUID> getTopSellers() {
        return new ArrayList<UUID>(this.topSellers);
    }

    public List<UUID> getTopBuyers() {
        return new ArrayList<UUID>(this.topBuyers);
    }

    public List<UUID> getTopEarners() {
        return new ArrayList<UUID>(this.topEarners);
    }

    public List<UUID> getTopAuctioneers() {
        return new ArrayList<UUID>(this.topAuctioneers);
    }

    public List<UUID> getTopTraders() {
        return new ArrayList<UUID>(this.topTraders);
    }

    public double getPlayerTaxSaved(UUID playerId) {
        return this.playerTaxSaved.getOrDefault(playerId, 0.0);
    }

    public void addPlayerTaxSaved(UUID playerId, double amount) {
        this.playerTaxSaved.merge(playerId, amount, Double::sum);
    }
}

