/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.models.Report;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ReportManager {
    private final MarketPlacePlus plugin;
    private final Map<String, Report> reportCache = new HashMap<String, Report>();
    private final Map<String, Long> cooldowns = new HashMap<String, Long>();
    private static final long REPORT_COOLDOWN = 60000L;

    public ReportManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.loadReports();
    }

    public boolean createReport(Player reporter, String reportedId, String reportedName, Report.ReportType type, String targetId, String reason, String details) {
        long timeSince;
        String cooldownKey = String.valueOf(reporter.getUniqueId()) + "_" + targetId;
        if (this.cooldowns.containsKey(cooldownKey) && (timeSince = System.currentTimeMillis() - this.cooldowns.get(cooldownKey)) < 60000L) {
            long remaining = (60000L - timeSince) / 1000L;
            reporter.sendMessage("\u00a7cPlease wait " + remaining + " seconds before reporting this item again.");
            return false;
        }
        if (this.hasActiveReport(reporter.getUniqueId().toString(), targetId)) {
            reporter.sendMessage("\u00a7cYou already have an active report for this item.");
            return false;
        }
        Report report = new Report(reporter.getUniqueId().toString(), reporter.getName(), reportedId, reportedName, type, targetId, reason);
        if (details != null && !details.isEmpty()) {
            report.setDetails(details);
        }
        if (this.saveReport(report)) {
            this.reportCache.put(report.getId(), report);
            this.cooldowns.put(cooldownKey, System.currentTimeMillis());
            this.notifyAdmins("\u00a7c[REPORT] \u00a7e" + reporter.getName() + " \u00a77reported " + type.name().toLowerCase() + " from \u00a7e" + reportedName);
            if (this.plugin.getConfig().getBoolean("discord.enabled") && this.plugin.getConfig().getBoolean("discord.send-reports")) {
                this.plugin.getDiscordWebhookManager().sendReportNotification(report);
            }
            return true;
        }
        return false;
    }

    private boolean hasActiveReport(String reporterId, String targetId) {
        return this.reportCache.values().stream().anyMatch(r -> r.getReporterId().equals(reporterId) && r.getTargetId().equals(targetId) && (r.getStatus() == Report.ReportStatus.PENDING || r.getStatus() == Report.ReportStatus.REVIEWING));
    }

    private void notifyAdmins(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("marketplaceplus.admin.reports")) continue;
            player.sendMessage(message);
        }
    }

    public List<Report> getPendingReports() {
        return this.reportCache.values().stream().filter(r -> r.getStatus() == Report.ReportStatus.PENDING).sorted(Comparator.comparing(Report::getReportTime).reversed()).collect(Collectors.toList());
    }

    public List<Report> getReviewingReports() {
        return this.reportCache.values().stream().filter(r -> r.getStatus() == Report.ReportStatus.REVIEWING).sorted(Comparator.comparing(Report::getReportTime).reversed()).collect(Collectors.toList());
    }

    public List<Report> getResolvedReports(int limit) {
        return this.reportCache.values().stream().filter(r -> r.getStatus() == Report.ReportStatus.RESOLVED || r.getStatus() == Report.ReportStatus.DISMISSED).sorted(Comparator.comparing(Report::getResolvedTime, Comparator.nullsLast(Comparator.reverseOrder()))).limit(limit).collect(Collectors.toList());
    }

    public List<Report> getReportsByPlayer(String playerId) {
        return this.reportCache.values().stream().filter(r -> r.getReportedId().equals(playerId)).sorted(Comparator.comparing(Report::getReportTime).reversed()).collect(Collectors.toList());
    }

    public Report getReport(String reportId) {
        return this.reportCache.get(reportId);
    }

    public boolean updateReportStatus(String reportId, Report.ReportStatus status, String updatedBy) {
        Report report = this.reportCache.get(reportId);
        if (report == null) {
            return false;
        }
        report.setStatus(status);
        if (status == Report.ReportStatus.REVIEWING) {
            this.notifyAdmins("\u00a76[REPORT] \u00a7e" + Bukkit.getPlayer((UUID)UUID.fromString(updatedBy)).getName() + " \u00a77is reviewing report #" + reportId.substring(0, 8));
        }
        return this.updateReport(report);
    }

    public boolean resolveReport(String reportId, String resolvedBy, String resolution) {
        Report report = this.reportCache.get(reportId);
        if (report == null) {
            return false;
        }
        report.resolve(resolvedBy, resolution);
        this.notifyAdmins("\u00a7a[REPORT] \u00a7e" + Bukkit.getPlayer((UUID)UUID.fromString(resolvedBy)).getName() + " \u00a77resolved report #" + reportId.substring(0, 8));
        return this.updateReport(report);
    }

    public boolean dismissReport(String reportId, String dismissedBy) {
        Report report = this.reportCache.get(reportId);
        if (report == null) {
            return false;
        }
        report.dismiss(dismissedBy);
        this.notifyAdmins("\u00a7e[REPORT] \u00a7e" + Bukkit.getPlayer((UUID)UUID.fromString(dismissedBy)).getName() + " \u00a77dismissed report #" + reportId.substring(0, 8));
        return this.updateReport(report);
    }

    public Map<String, Integer> getReportStatistics() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("total", this.reportCache.size());
        stats.put("pending", (int)this.reportCache.values().stream().filter(r -> r.getStatus() == Report.ReportStatus.PENDING).count());
        stats.put("reviewing", (int)this.reportCache.values().stream().filter(r -> r.getStatus() == Report.ReportStatus.REVIEWING).count());
        stats.put("resolved", (int)this.reportCache.values().stream().filter(r -> r.getStatus() == Report.ReportStatus.RESOLVED).count());
        stats.put("dismissed", (int)this.reportCache.values().stream().filter(r -> r.getStatus() == Report.ReportStatus.DISMISSED).count());
        return stats;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean saveReport(Report report) {
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = conn.prepareStatement("INSERT INTO market_reports (id, reporter_id, reporter_name, reported_id, reported_name, report_type, target_id, reason, details, report_time, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                try {
                    ps.setString(1, report.getId());
                    ps.setString(2, report.getReporterId());
                    ps.setString(3, report.getReporterName());
                    ps.setString(4, report.getReportedId());
                    ps.setString(5, report.getReportedName());
                    ps.setString(6, report.getReportType().name());
                    ps.setString(7, report.getTargetId());
                    ps.setString(8, report.getReason());
                    ps.setString(9, report.getDetails());
                    ps.setLong(10, report.getReportTime().toEpochSecond(ZoneOffset.UTC));
                    ps.setString(11, report.getStatus().name());
                    ps.executeUpdate();
                    bl = true;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to save report: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean updateReport(Report report) {
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();){
            boolean bl;
            block16: {
                PreparedStatement ps = conn.prepareStatement("UPDATE market_reports SET status = ?, resolved_by = ?, resolved_time = ?, resolution = ? WHERE id = ?");
                try {
                    ps.setString(1, report.getStatus().name());
                    ps.setString(2, report.getResolvedBy());
                    if (report.getResolvedTime() != null) {
                        ps.setLong(3, report.getResolvedTime().toEpochSecond(ZoneOffset.UTC));
                    } else {
                        ps.setNull(3, -5);
                    }
                    ps.setString(4, report.getResolution());
                    ps.setString(5, report.getId());
                    ps.executeUpdate();
                    bl = true;
                    if (ps == null) break block16;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to update report: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void loadReports() {
        try (Connection conn = this.plugin.getDatabaseManager().getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT * FROM market_reports ORDER BY report_time DESC");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Report report = new Report(rs.getString("id"), rs.getString("reporter_id"), rs.getString("reporter_name"), rs.getString("reported_id"), rs.getString("reported_name"), Report.ReportType.valueOf(rs.getString("report_type")), rs.getString("target_id"), rs.getString("reason"), rs.getString("details"), LocalDateTime.ofEpochSecond(rs.getLong("report_time"), 0, ZoneOffset.UTC), Report.ReportStatus.valueOf(rs.getString("status")), rs.getString("resolved_by"), rs.getObject("resolved_time") != null ? LocalDateTime.ofEpochSecond(rs.getLong("resolved_time"), 0, ZoneOffset.UTC) : null, rs.getString("resolution"));
                this.reportCache.put(report.getId(), report);
            }
            this.plugin.getLogger().info("Loaded " + this.reportCache.size() + " reports from database");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to load reports: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void reload() {
        this.reportCache.clear();
        this.cooldowns.clear();
        this.loadReports();
    }
}

