/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.models.TradeHistory;
import MPP.marketPlacePlus.utils.ItemUtils;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TradeHistoryManager {
    private final MarketPlacePlus plugin;

    public TradeHistoryManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
    }

    public void recordAuctionPurchase(MarketItem marketItem, Player buyer) {
        TradeHistory trade = new TradeHistory(UUID.randomUUID().toString(), marketItem.getSellerId(), marketItem.getSellerName(), buyer.getUniqueId(), buyer.getName(), marketItem.getItemStack(), marketItem.getSerializedItem(), marketItem.getPrice(), marketItem.getItemStack().getAmount(), LocalDateTime.now(), TradeHistory.TradeType.AUCTION_HOUSE);
        this.plugin.getDatabaseManager().saveTradeHistory(trade);
    }

    public void recordShopPurchase(PlayerShop shop, Player buyer, ItemStack item, double totalPrice) {
        TradeHistory trade = new TradeHistory(UUID.randomUUID().toString(), shop.getOwnerId(), shop.getOwnerName(), buyer.getUniqueId(), buyer.getName(), item, ItemUtils.serializeItem(item), totalPrice, item.getAmount(), LocalDateTime.now(), TradeHistory.TradeType.PLAYER_SHOP);
        this.plugin.getDatabaseManager().saveTradeHistory(trade);
    }

    public void recordDirectTrade(Player seller, Player buyer, ItemStack item, double price) {
        TradeHistory trade = new TradeHistory(UUID.randomUUID().toString(), seller.getUniqueId(), seller.getName(), buyer.getUniqueId(), buyer.getName(), item, ItemUtils.serializeItem(item), price, item.getAmount(), LocalDateTime.now(), TradeHistory.TradeType.DIRECT_TRADE);
        this.plugin.getDatabaseManager().saveTradeHistory(trade);
    }

    public void clearPlayerHistory(UUID playerId) {
        this.plugin.getDatabaseManager().clearPlayerTradeHistory(playerId);
    }

    public double getPlayerTotalEarnings(UUID playerId) {
        List<TradeHistory> history = this.plugin.getDatabaseManager().getPlayerTradeHistory(playerId);
        return history.stream().filter(trade -> trade.getSellerId().equals(playerId)).mapToDouble(TradeHistory::getPrice).sum();
    }

    public int getTotalTransactionCount() {
        return this.plugin.getDatabaseManager().getTotalTransactionCount();
    }

    public double getTotalTransactionVolume() {
        return this.plugin.getDatabaseManager().getTotalTransactionVolume();
    }

    public List<TradeHistory> getPlayerHistory(UUID playerId) {
        return this.plugin.getDatabaseManager().getPlayerTradeHistory(playerId);
    }

    public int getPlayerSalesCount(UUID playerId) {
        List<TradeHistory> history = this.getPlayerHistory(playerId);
        return (int)history.stream().filter(trade -> trade.getSellerId().equals(playerId)).count();
    }

    public int getPlayerPurchaseCount(UUID playerId) {
        List<TradeHistory> history = this.getPlayerHistory(playerId);
        return (int)history.stream().filter(trade -> trade.getBuyerId().equals(playerId)).count();
    }

    public double getPlayerTotalSpent(UUID playerId) {
        List<TradeHistory> history = this.getPlayerHistory(playerId);
        return history.stream().filter(trade -> trade.getBuyerId().equals(playerId)).mapToDouble(TradeHistory::getPrice).sum();
    }

    public double getPlayerTotalEarned(UUID playerId) {
        List<TradeHistory> history = this.getPlayerHistory(playerId);
        return history.stream().filter(trade -> trade.getSellerId().equals(playerId)).mapToDouble(TradeHistory::getPrice).sum();
    }

    public Set<UUID> getUniqueTradePartners(UUID playerId) {
        List<TradeHistory> history = this.getPlayerHistory(playerId);
        HashSet<UUID> partners = new HashSet<UUID>();
        history.forEach(trade -> {
            if (trade.getSellerId().equals(playerId)) {
                partners.add(trade.getBuyerId());
            } else if (trade.getBuyerId().equals(playerId)) {
                partners.add(trade.getSellerId());
            }
        });
        return partners;
    }

    public LocalDateTime getLastTradeTime(UUID playerId) {
        List<TradeHistory> history = this.getPlayerHistory(playerId);
        return history.stream().map(TradeHistory::getTradeTime).max(LocalDateTime::compareTo).orElse(null);
    }

    public void recordTransaction(UUID buyer, UUID seller, ItemStack item, double price, String type) {
        TradeHistory trade = new TradeHistory(UUID.randomUUID().toString(), seller, this.plugin.getServer().getOfflinePlayer(seller).getName(), buyer, this.plugin.getServer().getOfflinePlayer(buyer).getName(), item, ItemUtils.serializeItem(item), price, item.getAmount(), LocalDateTime.now(), TradeHistory.TradeType.valueOf(type.toUpperCase().replace(" ", "_")));
        this.plugin.getDatabaseManager().saveTradeHistory(trade);
    }
}

